/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImplFactory;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class ServerSocket {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private SocketImpl impl;
    private boolean oldImpl = false;
    private static SocketImplFactory factory;
    static /* synthetic */ Class class$java$net$SocketAddress;

    public ServerSocket() throws IOException {
        this.setImpl();
    }

    public ServerSocket(int n2) throws IOException {
        this(n2, 50, null);
    }

    public ServerSocket(int n2, int n3) throws IOException {
        this(n2, n3, null);
    }

    public ServerSocket(int n2, int n3, InetAddress inetAddress) throws IOException {
        this.setImpl();
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + n2);
        }
        if (n3 < 1) {
            n3 = 50;
        }
        try {
            this.bind(new InetSocketAddress(inetAddress, n2));
        }
        catch (SecurityException securityException) {
            this.close();
            throw securityException;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        Class[] classArray = new Class[]{class$java$net$SocketAddress == null ? (class$java$net$SocketAddress = ServerSocket.class$("java.net.SocketAddress")) : class$java$net$SocketAddress, Integer.TYPE};
        try {
            this.impl.getClass().getDeclaredMethod("connect", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.oldImpl = true;
        }
    }

    private void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new PlainSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setServerSocket(this);
        }
    }

    void createImpl() throws SocketException {
        this.setImpl();
        try {
            this.impl.create(true);
            this.created = true;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (n2 < 1) {
            n2 = 50;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            this.getImpl().bind(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.getImpl().listen(n2);
            this.bound = true;
        }
        catch (SecurityException securityException) {
            this.bound = false;
            throw securityException;
        }
        catch (IOException iOException) {
            this.bound = false;
            throw iOException;
        }
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        Socket socket = new Socket(null);
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        SocketImpl socketImpl = null;
        try {
            if (socket.impl == null) {
                socket.setImpl();
            }
            socketImpl = socket.impl;
            socket.impl = null;
            socketImpl.address = new InetAddress();
            socketImpl.fd = new FileDescriptor();
            this.getImpl().accept(socketImpl);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept(socketImpl.getInetAddress().getHostAddress(), socketImpl.getPort());
            }
        }
        catch (IOException iOException) {
            if (socketImpl != null) {
                socketImpl.reset();
            }
            socket.impl = socketImpl;
            throw iOException;
        }
        catch (SecurityException securityException) {
            if (socketImpl != null) {
                socketImpl.reset();
            }
            socket.impl = socketImpl;
            throw securityException;
        }
        socket.impl = socketImpl;
        socket.postAccept();
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.created) {
            this.impl.close();
        }
        this.closed = true;
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void setSoTimeout(int n2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, new Integer(n2));
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setReuseAddress(boolean bl2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, new Boolean(bl2));
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.impl.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }

    void setBound() {
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }

    public synchronized void setReceiveBufferSize(int n2) throws SocketException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("negative receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(n2));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n2 = 0;
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            n2 = (Integer)object;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n2 = -1;
        String string = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyHost"));
        string = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyPort"));
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (string2 != null) {
            factory = new SocksSocketImplFactory(string2, n2);
        }
    }
}

