/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.DeniedCertificateStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.usability.Trace;

public class TrustDecider {
    private static CertificateStore rootStore = new RootCACertificateStore();
    private static CertificateStore permanentStore = new PluginCertificateStore();
    private static CertificateStore sessionStore = new SessionCertificateStore();
    private static CertificateStore deniedStore = new DeniedCertificateStore();

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new PluginCertificateStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isAllPermissionGranted(CodeSource var0) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        var1_1 = var0.getCertificates();
        var2_2 = var0.getLocation().toString();
        if (var1_1 == null) {
            if (TrustDecider.isBrowserMozilla()) {
                return TrustDecider.isAllPermissionGranted(var0, var2_2, null, null, 0, null, 0, "");
            }
            return false;
        }
        var3_3 = 0;
        var4_4 = 0;
        while (var4_4 < var1_1.length) {
            block26: {
                var5_5 = var3_3;
                var6_6 = null;
                var7_7 = null;
                if (var1_1.length != 1 || !(var1_1[0] instanceof X509Certificate)) ** GOTO lbl40
                try {
                    ((X509Certificate)var1_1[0]).checkValidity();
                }
                catch (CertificateExpiredException var8_9) {
                    if (var6_6 == null) {
                        var6_6 = var8_9;
                    }
                    break block26;
                }
                catch (CertificateNotYetValidException var9_13) {
                    if (var7_7 != null) break block26;
                    var7_7 = var9_13;
                }
                break block26;
                while (var1_1[var5_5] instanceof X509Certificate && var1_1[var5_5 + 1] instanceof X509Certificate && TrustDecider.isIssuerOf((X509Certificate)var1_1[var5_5], (X509Certificate)var1_1[var5_5 + 1])) {
                    block27: {
                        try {
                            ((X509Certificate)var1_1[var5_5]).checkValidity();
                            ((X509Certificate)var1_1[var5_5 + 1]).checkValidity();
                        }
                        catch (CertificateExpiredException var8_10) {
                            if (var6_6 == null) {
                                var6_6 = var8_10;
                            }
                        }
                        catch (CertificateNotYetValidException var9_14) {
                            if (var7_7 != null) break block27;
                            var7_7 = var9_14;
                        }
                    }
                    ++var5_5;
lbl40:
                    // 2 sources

                    if (var5_5 + 1 < var1_1.length) continue;
                }
            }
            var4_4 = var5_5 + 1;
            if (TrustDecider.isBrowserMozilla()) {
                var8_8 = TrustDecider.makeChain(var1_1, var3_3, var4_4);
                if (var8_8 != null) {
                    var9_12 = new int[var8_8.length];
                    var10_16 = false;
                    while (var10_16 < var8_8.length) {
                        var9_12[var10_16] = var8_8[var10_16].length;
                        var10_16 += 1;
                    }
                    var11_17 = (X509Certificate)var1_1[0];
                    var12_19 = var11_17.getSignature();
                    if (TrustDecider.isAllPermissionGranted(var0, var2_2, var8_8, var9_12, var8_8.length, var12_19, var12_19.length, var14_21 = (var13_20 = var11_17.getSubjectDN()).getName())) {
                        return true;
                    }
                }
            } else {
                var8_11 = false;
                TrustDecider.rootStore.load();
                TrustDecider.permanentStore.load();
                TrustDecider.sessionStore.load();
                TrustDecider.deniedStore.load();
                var9_15 = false;
                var10_16 = false;
                if (TrustDecider.deniedStore.contains(var1_1[var3_3])) {
                    return false;
                }
                if (!TrustDecider.rootStore.verify(var1_1[var5_5])) {
                    var9_15 = true;
                }
                if (TrustDecider.permanentStore.contains(var1_1[var3_3])) {
                    return true;
                }
                if (TrustDecider.sessionStore.contains(var1_1[var3_3])) {
                    return true;
                }
                if (var6_6 != null || var7_7 != null) {
                    var10_16 = true;
                }
                if ((var11_18 = TrustDecider.showSecurityDialog(var0, var9_15, var10_16)) == 0) {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.grant.session"), 2);
                    TrustDecider.sessionStore.add(var1_1[var3_3]);
                    TrustDecider.sessionStore.save();
                    var8_11 = true;
                } else if (var11_18 == 2) {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.grant.forever"), 2);
                    TrustDecider.permanentStore.add(var1_1[var3_3]);
                    TrustDecider.permanentStore.save();
                    var8_11 = true;
                } else {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.deny"), 2);
                    TrustDecider.deniedStore.add(var1_1[var3_3]);
                    TrustDecider.deniedStore.save();
                }
                return var8_11;
            }
            var3_3 = var4_4;
        }
        return false;
    }

    private static boolean isBrowserMozilla() {
        return false;
    }

    private static boolean isAllPermissionGranted(CodeSource codeSource, String string, byte[][] byArray, int[] nArray, int n, byte[] byArray2, int n2, String string2) {
        return false;
    }

    private static byte[][] makeChain(Certificate[] certificateArray, int n, int n2) throws CertificateEncodingException {
        if (n == n2) {
            return null;
        }
        byte[][] byArrayArray = new byte[n2 - n][];
        int n3 = n;
        while (n3 < n2) {
            byArrayArray[n3 - n] = certificateArray[n3].getEncoded();
            ++n3;
        }
        return byArrayArray;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    static int showSecurityDialog(CodeSource codeSource, boolean bl, boolean bl2) {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedBlockAction(codeSource, bl, bl2));
        int n2 = 2;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private static class PrivilegedBlockAction
    implements PrivilegedAction {
        Certificate[] certs;
        boolean rootCANotValid = false;
        boolean timeNotValid = false;

        PrivilegedBlockAction(CodeSource codeSource, boolean bl, boolean bl2) {
            this.certs = codeSource.getCertificates();
            this.rootCANotValid = bl;
            this.timeNotValid = bl2;
        }

        public Object run() {
            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(this.certs, this.rootCANotValid, this.timeNotValid);
            return new Integer(trustDeciderDialog.DoModal());
        }
    }
}

