/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

final class X509TrustManagerImpl
implements X509TrustManager {
    private Collection a = new HashSet();
    private Map b = new HashMap();
    private static final Debug c = Debug.getInstance("ssl");

    X509TrustManagerImpl(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                certificateArray = keyStore.getCertificate(string);
                if (!(certificateArray instanceof X509Certificate)) continue;
                if (c != null && Debug.isOn("trustmanager")) {
                    System.out.println("adding as trusted cert: " + certificateArray);
                }
                this.a((X509Certificate)certificateArray);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (c != null && Debug.isOn("trustmanager")) {
                System.out.println("adding private entry as trusted cert: " + certificateArray[0]);
            }
            this.a((X509Certificate)certificateArray[0]);
        }
    }

    private void a(X509Certificate x509Certificate) {
        this.a.add(x509Certificate);
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)this.b.get(x500Principal);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            this.b.put(x500Principal, arrayList);
        }
        arrayList.add(x509Certificate);
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.a(x509CertificateArray, "Client." + string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.a(x509CertificateArray, string);
    }

    private void a(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Date date = new Date();
        x509CertificateArray = this.a(x509CertificateArray, date);
        int n = 0;
        while (n < x509CertificateArray.length) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = x509CertificateArray[n];
            try {
                this.a(x509Certificate2, n, string);
            }
            catch (Exception exception) {
                if (c != null && Debug.isOn("trustmanager")) {
                    System.out.println("failed critical extension check: " + x509Certificate2);
                    System.out.println("ext exception was: " + exception);
                }
                throw new CertificateException("failed critical extension check");
            }
            if (this.b(x509Certificate2)) {
                if (c != null && Debug.isOn("trustmanager")) {
                    System.out.println("stop on trusted cert: " + x509Certificate2);
                }
                return;
            }
            Principal principal = x509Certificate2.getIssuerDN();
            X509Certificate x509Certificate3 = x509Certificate = n + 1 < x509CertificateArray.length ? x509CertificateArray[n + 1] : x509Certificate2;
            if (!principal.equals(x509Certificate.getSubjectDN())) {
                String string2 = n + 1 < x509CertificateArray.length ? "Certificate chaining error: issuer DN != subject DN" : "Could not find trusted certificate";
                throw new CertificateException(string2);
            }
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (Exception exception) {
                if (c != null && Debug.isOn("trustmanager")) {
                    System.out.println("verify failed: " + x509Certificate2);
                    System.out.println("verify exception was: " + exception);
                }
                throw new CertificateException(exception.getMessage());
            }
            ++n;
        }
        throw new CertificateException("Couldn't find trusted certificate");
    }

    private X509Certificate[] a(X509Certificate[] x509CertificateArray, Date date) {
        X509Certificate x509Certificate;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(x509CertificateArray.length);
        boolean bl = false;
        if (x509CertificateArray.length == 0) {
            return x509CertificateArray;
        }
        int n = 0;
        while (n < x509CertificateArray.length) {
            x509Certificate = x509CertificateArray[n];
            X509Certificate x509Certificate2 = this.a(x509Certificate, date);
            if (x509Certificate2 == null) {
                try {
                    x509Certificate.checkValidity(date);
                }
                catch (Exception exception) {
                    if (c != null && Debug.isOn("trustmanager")) {
                        System.out.println("out of date cert: " + x509Certificate);
                    }
                    return new X509Certificate[0];
                }
            } else {
                x509Certificate = x509Certificate2;
                bl = true;
                if (c != null && Debug.isOn("trustmanager")) {
                    System.out.println("updated cert with: " + x509Certificate);
                }
            }
            arrayList.add(x509Certificate);
            ++n;
        }
        n = x509CertificateArray.length - 1;
        Principal principal = x509CertificateArray[n].getSubjectDN();
        Principal principal2 = x509CertificateArray[n].getIssuerDN();
        if (!principal2.equals(principal) && (x509Certificate = this.b(x509CertificateArray[n], date)) != null) {
            if (c != null && Debug.isOn("trustmanager")) {
                System.out.println("add missing root cert: " + x509Certificate);
            }
            bl = true;
            arrayList.add(x509Certificate);
        }
        if (bl) {
            return arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return x509CertificateArray;
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.a.size()];
        this.a.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    private boolean b(X509Certificate x509Certificate) {
        return this.a.contains(x509Certificate);
    }

    private X509Certificate a(X509Certificate x509Certificate, Date date) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        List list = (List)this.b.get(x500Principal);
        if (list == null) {
            return null;
        }
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate) || !x509Certificate2.getSubjectX500Principal().equals(x500Principal2) || !x509Certificate2.getIssuerX500Principal().equals(x500Principal) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            return x509Certificate2;
        }
        return null;
    }

    private X509Certificate b(X509Certificate x509Certificate, Date date) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        List list = (List)this.b.get(x500Principal);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (!x509Certificate2.getSubjectX500Principal().equals(x500Principal)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                if (c == null || !Debug.isOn("trustmanager")) continue;
                System.out.println("local root cert is invalid: " + x509Certificate2);
                continue;
            }
            return x509Certificate2;
        }
        return null;
    }

    private void a(X509Certificate x509Certificate, int n, String string) throws Exception {
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null || set.size() == 0) {
            return;
        }
        this.a(set);
        this.a(x509Certificate, set, n);
        if (n == 0) {
            this.a(x509Certificate, set, string);
        } else {
            this.a(x509Certificate, set);
        }
        this.b(x509Certificate, set);
    }

    private void a(Set set) throws Exception {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("2.5.29.19") || string.equals("2.5.29.15") || string.equals("2.5.29.37") || string.equals("2.16.840.1.113730.1.1")) continue;
            throw new Exception("Contains unknown critical extensions");
        }
    }

    private void a(X509Certificate x509Certificate, Set set, int n) throws Exception {
        int n2;
        if (set != null && !set.isEmpty() && set.contains(new String("2.5.29.19")) && (n2 = x509Certificate.getBasicConstraints()) >= 0 && n > 0 && n - 1 > n2) {
            throw new Exception("Violated basic constraints");
        }
    }

    private void a(X509Certificate x509Certificate, Set set, String string) throws Exception {
        if (set != null && !set.isEmpty()) {
            Object object;
            if (set.contains("2.5.29.15")) {
                boolean bl;
                object = x509Certificate.getKeyUsage();
                if (object == null || ((boolean[])object).length == 0) {
                    throw new Exception("Invalid key usage extension.");
                }
                boolean bl2 = object[0];
                Object object2 = bl = ((boolean[])object).length >= 3 ? object[2] : false;
                if (string.indexOf("Client") != -1) {
                    if (!bl2) {
                        throw new Exception("Wrong key usage. Expect digitalSignature.");
                    }
                } else if (string.indexOf("DHE_DSS") != -1) {
                    if (!bl2) {
                        throw new Exception("Wrong key usage. Expect digitalSignature");
                    }
                } else if (string.indexOf("DHE_RSA") != -1) {
                    if (!bl2) {
                        throw new Exception("Wrong key usage. Expect digitalSignature");
                    }
                } else if (string.indexOf("RSA_EXPORT") != -1) {
                    if (!bl2) {
                        throw new Exception("Wrong key usage. Expect digitalSignature.");
                    }
                } else if (string.indexOf("RSA") != -1) {
                    if (!bl) {
                        throw new Exception("Wrong key usage. Expect keyEncipherment.");
                    }
                } else if (string.indexOf("UNKNOWN") != -1) {
                    if (!bl2) {
                        throw new Exception("Wrong key usage. Expect digitalSignature.");
                    }
                } else {
                    throw new Exception("Wrong key usage");
                }
            }
            if (set.contains("2.5.29.37")) {
                object = x509Certificate.getExtendedKeyUsage();
                if (string.indexOf("Client") == -1 && !object.contains("1.3.6.1.5.5.7.3.1") || string.indexOf("Client") != -1 && !object.contains("1.3.6.1.5.5.7.3.2")) {
                    throw new Exception("Wrong extended key usage.");
                }
            }
        }
    }

    private void a(X509Certificate x509Certificate, Set set) throws Exception {
        boolean[] blArray;
        if (set != null && !set.isEmpty() && set.contains(new String("2.5.29.15")) && (blArray = x509Certificate.getKeyUsage()) != null && blArray.length > 5 && !blArray[5]) {
            throw new Exception("Wrong key usage");
        }
    }

    private void b(X509Certificate x509Certificate, Set set) throws Exception {
        if (set != null && !set.isEmpty() && set.contains(new String("2.16.840.1.113730.1.1"))) {
            byte[] byArray = x509Certificate.getExtensionValue("2.16.840.1.113730.1.1");
            if (byArray == null) {
                throw new Exception("Empty NetscapeCertType extension");
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray());
            boolean[] blArray = netscapeCertTypeExtension.getKeyUsageMappedBits();
            if (blArray != null && blArray.length > 5 && !blArray[5]) {
                throw new Exception("Invalid NetscapeCertType extension");
            }
        }
    }
}

