/*

    $id$, part of
    faucet and hose: network pipe utilities
    Copyright (C) 1992 Robert Forsman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef common_h_
#define common_h_

/* set from argv[0] by the main() routine */
extern char *programname;

/* list of file descriptors to dup from the socket */
extern int	*fds;
extern int	nfds;

/* the mode to use when shutting down the socket
	<0: don't do any shutdown
	0 : shut down recieves (write-only)
	>0: shut down sends (read-only)
  */

extern int	how_shutdown;

/* add a file descriptor to the list */
void add_fd(/*int fd*/);

/* do the dup from the argument socket to the list of file descriptors,
   perform the requested shutdown... */
void dup_n(/*int socket*/);

/**********************************************************************/

int name_to_inet_port(/* char* */);

/**********************************************************************/

struct in_addr ** /* addr_array */
convert_hostname(/* char *, int * */);

/**********************************************************************/

int
bindlocal(/* int, char *, char*, int */);

/**********************************************************************/

void				/* this is in version.c */
emit_version(/* char*, int */);

#endif /* common_h_ */
