/* biosgetn.S: BIOS call: get PnP ISA system device info */
/*
 * $Header: /root/pnp/module/RCS/biosgetn.S,v 1.3 1996/06/12 18:56:34 root Exp $
 *
 * $Log: biosgetn.S,v $
 * Revision 1.3  1996/06/12  18:56:34  root
 * standard internal i/f & BIOS read/query
 *
 * Revision 1.2  1996/05/26  19:07:44  root
 * code restructured & modularized
 *
 * Revision 1.1  1996/05/26  15:33:30  root
 * initial revision
 *
 */

/*
 * (c) Copyright 1996  D.W.Howells <dwh@nexor.co.uk>,
 */

#ifdef __ELF__
  #define ENTRY(x) x
#else
  #define ENTRY(x) _##x
#endif

#define GET_NUM_NODES 0

/*
 * int pnp_bios__getnumdev(
 *	u_char *count,		; where to store num nodes
 *	u_int *size		; where to store largest node size
 *	);
 */
#define COUNT	0x08(%ebp)
#define SIZE	0x0c(%ebp)

.globl ENTRY(pnp_bios__getnumdev)
ENTRY(pnp_bios__getnumdev):
	pushl %ebp
	movl %esp,%ebp
	pushl %ebx
	pushl %ecx
	pushl %edx

	/* push the arguments as 16-bit values */
#define ARGBLOCK 0x0c
	subl $ARGBLOCK,%esp
	movl %esp,%edx
	movl ENTRY(pnpbios_ds),%eax		/* BIOS selector */
	movw %ax,0x0a(%edx)
	movl ENTRY(pnpbios_kdata_ds),%eax	/* seg for NodeSize */
	movw %ax,0x08(%edx)
	movl $02,%ax				/* offset for NodeSize */
	movw %ax,0x06(%edx)
	movl ENTRY(pnpbios_kdata_ds),%eax	/* seg for NumNodes */
	movw %ax,0x04(%edx)
	movw $00,%ax				/* offset for NumNodes */
	movw %ax,0x02(%edx)
	movw $GET_NUM_NODES,%ax			/* function */
	movw %ax,0x00(%edx)

	/* stack the return address to here */
	subl $0x04,%esp
	movl %esp,%edx
	movw ENTRY(pnpbios_ret_cs),%ax
	movw %ax,0x02(%edx)		/* %cs */
	movw $0x0000,%ax
	movw %ax,0x00(%edx)		/* %ip */

	/* stack the BIOS address to be called (32-bit lret!!!!) */
	movw ENTRY(pnpbios_cs),%eax
	andl $0xffff,%eax
	pushl %eax			/* %cs */
	movl ENTRY(pnpbios_entry),%eax
	andl $0xffff,%eax
	pushl %eax			/* %eip */

	/* return address to here placed in registers */
	leal ENTRY(return_from_BIOS),%ebx
	movw %cs,%cx
	andl $0xffff,%ecx

	/* call BIOS */
	lret

/*
 * This is where BIOS indirectly returns to (%ax holds the return value)
 *
 *
 */
ENTRY(return_from_BIOS):
	/* unstack the parameters */
	addl $ARGBLOCK,%esp

	/* make return an int */
	cwtl

	/* now sort out the arg-returned values */
	mov %es,%bx
	mov ENTRY(pnpbios_kdata_ds),%ecx
	mov %cx,%es
	mov %es:0x0000,%dl
	mov %es:0x0002,%cx
	mov %bx,%es

	/* store numnodes then nodesize */	
	mov COUNT,%ebx
	movb %dl,(%ebx)
	mov SIZE,%ebx
	and $0xffff,%ecx
	mov %ecx,(%ebx)

	/* tidy the stack */
	pop %edx
	pop %ecx
	pop %ebx
	pop %ebp
	ret
