// Run: %dxc -T vs_6_0 -E main

// According to HLSL reference:
// The 'ldexp' function can only operate on float, vector of float, and matrix of floats.

// CHECK:      [[glsl:%\d+]] = OpExtInstImport "GLSL.std.450"

void main() {
  float    a1, a2, ldexp_a;
  float4   b1, b2, ldexp_b;
  float2x3 c1, c2, ldexp_c;
  
// CHECK:          [[a1:%\d+]] = OpLoad %float %a1
// CHECK-NEXT:     [[a2:%\d+]] = OpLoad %float %a2
// CHECK-NEXT:    [[exp:%\d+]] = OpExtInst %float [[glsl]] Exp2 [[a2]]
// CHECK-NEXT:    [[res:%\d+]] = OpFMul %float [[a1]] [[exp]]
// CHECK-NEXT:                   OpStore %ldexp_a [[res]]
  ldexp_a = ldexp(a1, a2);

// CHECK:          [[b1:%\d+]] = OpLoad %v4float %b1
// CHECK-NEXT:     [[b2:%\d+]] = OpLoad %v4float %b2
// CHECK-NEXT:    [[exp:%\d+]] = OpExtInst %v4float [[glsl]] Exp2 [[b2]]
// CHECK-NEXT:    [[res:%\d+]] = OpFMul %v4float [[b1]] [[exp]]
// CHECK-NEXT:                   OpStore %ldexp_b [[res]]
  ldexp_b = ldexp(b1, b2);

// CHECK:               [[c1:%\d+]] = OpLoad %mat2v3float %c1
// CHECK-NEXT:          [[c2:%\d+]] = OpLoad %mat2v3float %c2
// CHECK-NEXT:     [[c1_row0:%\d+]] = OpCompositeExtract %v3float [[c1]] 0
// CHECK-NEXT:     [[c2_row0:%\d+]] = OpCompositeExtract %v3float [[c2]] 0
// CHECK-NEXT:         [[exp:%\d+]] = OpExtInst %v3float [[glsl]] Exp2 [[c2_row0]]
// CHECK-NEXT:        [[res0:%\d+]] = OpFMul %v3float [[c1_row0]] [[exp]]
// CHECK-NEXT:     [[c1_row1:%\d+]] = OpCompositeExtract %v3float [[c1]] 1
// CHECK-NEXT:     [[c2_row1:%\d+]] = OpCompositeExtract %v3float [[c2]] 1
// CHECK-NEXT:         [[exp:%\d+]] = OpExtInst %v3float [[glsl]] Exp2 [[c2_row1]]
// CHECK-NEXT:        [[res1:%\d+]] = OpFMul %v3float [[c1_row1]] [[exp]]
// CHECK-NEXT:     [[ldexp_c:%\d+]] = OpCompositeConstruct %mat2v3float [[res0]] [[res1]]
// CHECK-NEXT:                        OpStore %ldexp_c [[ldexp_c]]
  ldexp_c = ldexp(c1, c2);
}
