/* valamarkupreader.c generated by valac, the Vala compiler
 * generated from valamarkupreader.vala, do not modify */

/* valamarkupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValaParamSpecMarkupReader ValaParamSpecMarkupReader;

struct _ValaMarkupReaderPrivate {
	gchar* _filename;
	gchar* _name;
	gchar* _content;
	GMappedFile* mapped_file;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
};

struct _ValaParamSpecMarkupReader {
	GParamSpec parent_instance;
};

static gint ValaMarkupReader_private_offset;
static gpointer vala_markup_reader_parent_class = NULL;

static void vala_markup_reader_set_filename (ValaMarkupReader* self,
                                      const gchar* value);
static void vala_markup_reader_set_name (ValaMarkupReader* self,
                                  const gchar* value);
static void vala_markup_reader_set_content (ValaMarkupReader* self,
                                     const gchar* value);
static gchar* vala_markup_reader_read_name (ValaMarkupReader* self);
static void vala_markup_reader_space (ValaMarkupReader* self);
static gchar* vala_markup_reader_text (ValaMarkupReader* self,
                                gchar end_char,
                                gboolean rm_trailing_whitespace);
static void vala_markup_reader_finalize (ValaMarkupReader * obj);
static GType vala_markup_reader_get_type_once (void);

static inline gpointer
vala_markup_reader_get_instance_private (ValaMarkupReader* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMarkupReader_private_offset);
}

const gchar*
vala_markup_reader_get_filename (ValaMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
vala_markup_reader_set_filename (ValaMarkupReader* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}

const gchar*
vala_markup_reader_get_name (ValaMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
vala_markup_reader_set_name (ValaMarkupReader* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

const gchar*
vala_markup_reader_get_content (ValaMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}

static void
vala_markup_reader_set_content (ValaMarkupReader* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp0_;
}

ValaMarkupReader*
vala_markup_reader_construct (GType object_type,
                              const gchar* filename)
{
	ValaMarkupReader* self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaMarkupReader*) g_type_create_instance (object_type);
	vala_markup_reader_set_filename (self, filename);
	{
		GMappedFile* _tmp0_ = NULL;
		GMappedFile* _tmp1_;
		GMappedFile* _tmp2_;
		GMappedFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GMappedFile* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = g_mapped_file_new (filename, FALSE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_mapped_file_unref0 (self->priv->mapped_file);
		self->priv->mapped_file = _tmp2_;
		_tmp3_ = self->priv->mapped_file;
		_tmp4_ = g_mapped_file_get_contents (_tmp3_);
		self->priv->begin = _tmp4_;
		_tmp5_ = self->priv->begin;
		_tmp6_ = self->priv->mapped_file;
		self->priv->end = _tmp5_ + g_mapped_file_get_length (_tmp6_);
		_tmp7_ = self->priv->begin;
		self->priv->current = _tmp7_;
		self->priv->line = 1;
		self->priv->column = 1;
		_g_mapped_file_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		vala_report_error (NULL, "Unable to map file `%s': %s", filename, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

ValaMarkupReader*
vala_markup_reader_new (const gchar* filename)
{
	return vala_markup_reader_construct (VALA_TYPE_MARKUP_READER, filename);
}

ValaMarkupReader*
vala_markup_reader_construct_from_string (GType object_type,
                                          const gchar* filename,
                                          const gchar* content)
{
	ValaMarkupReader* self = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	self = (ValaMarkupReader*) g_type_create_instance (object_type);
	vala_markup_reader_set_filename (self, filename);
	self->priv->begin = content;
	_tmp0_ = self->priv->begin;
	_tmp1_ = strlen (content);
	_tmp2_ = _tmp1_;
	self->priv->end = _tmp0_ + _tmp2_;
	_tmp3_ = self->priv->begin;
	self->priv->current = _tmp3_;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}

ValaMarkupReader*
vala_markup_reader_new_from_string (const gchar* filename,
                                    const gchar* content)
{
	return vala_markup_reader_construct_from_string (VALA_TYPE_MARKUP_READER, filename, content);
}

gchar*
vala_markup_reader_get_attribute (ValaMarkupReader* self,
                                  const gchar* attr)
{
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = self->priv->attributes;
	_tmp1_ = vala_map_get (_tmp0_, attr);
	result = (gchar*) _tmp1_;
	return result;
}

ValaMap*
vala_markup_reader_get_attributes (ValaMarkupReader* self)
{
	ValaHashMap* _result_ = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	_result_ = _tmp3_;
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp4_;
		ValaSet* _tmp5_;
		ValaSet* _tmp6_;
		ValaIterator* _tmp7_;
		ValaIterator* _tmp8_;
		_tmp4_ = self->priv->attributes;
		_tmp5_ = vala_map_get_keys (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_iterable_iterator ((ValaIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_iterable_unref0 (_tmp6_);
		_key_it = _tmp8_;
		while (TRUE) {
			ValaIterator* _tmp9_;
			gchar* key = NULL;
			ValaIterator* _tmp10_;
			gpointer _tmp11_;
			ValaHashMap* _tmp12_;
			const gchar* _tmp13_;
			ValaMap* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			_tmp9_ = _key_it;
			if (!vala_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _key_it;
			_tmp11_ = vala_iterator_get (_tmp10_);
			key = (gchar*) _tmp11_;
			_tmp12_ = _result_;
			_tmp13_ = key;
			_tmp14_ = self->priv->attributes;
			_tmp15_ = key;
			_tmp16_ = vala_map_get (_tmp14_, _tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			vala_map_set ((ValaMap*) _tmp12_, _tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (key);
		}
		_vala_iterator_unref0 (_key_it);
	}
	result = (ValaMap*) _result_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
vala_markup_reader_read_name (ValaMarkupReader* self)
{
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_;
		gchar _tmp9_;
		gunichar u = 0U;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == ' ') {
			_tmp7_ = TRUE;
		} else {
			gchar* _tmp10_;
			gchar _tmp11_;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_[0];
			_tmp7_ = _tmp11_ == '\t';
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gchar* _tmp12_;
			gchar _tmp13_;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_[0];
			_tmp6_ = _tmp13_ == '>';
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gchar* _tmp14_;
			gchar _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = _tmp14_[0];
			_tmp5_ = _tmp15_ == '/';
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gchar* _tmp16_;
			gchar _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_[0];
			_tmp4_ = _tmp17_ == '=';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gchar* _tmp18_;
			gchar _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_[0];
			_tmp3_ = _tmp19_ == '\n';
		}
		if (_tmp3_) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		_tmp22_ = self->priv->current;
		u = g_utf8_get_char_validated ((const gchar*) _tmp20_, (gssize) ((glong) (_tmp21_ - _tmp22_)));
		if (u != ((gunichar) -1)) {
			gchar* _tmp23_;
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + g_unichar_to_utf8 (u, NULL);
		} else {
			vala_report_error (NULL, "invalid UTF-8 character");
		}
	}
	_tmp24_ = self->priv->current;
	_tmp25_ = begin;
	if (_tmp24_ == _tmp25_) {
	}
	_tmp26_ = begin;
	_tmp27_ = self->priv->current;
	_tmp28_ = begin;
	_tmp29_ = string_substring ((const gchar*) _tmp26_, (glong) 0, (glong) ((gint) (_tmp27_ - _tmp28_)));
	result = _tmp29_;
	return result;
}

ValaMarkupTokenType
vala_markup_reader_read_token (ValaMarkupReader* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaMap* _tmp0_;
	ValaMarkupTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp109_;
	ValaMarkupTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->attributes;
	vala_map_clear (_tmp0_);
	if (self->priv->empty_element) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		self->priv->empty_element = FALSE;
		_tmp1_ = self->priv->begin;
		vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
		_tmp2_ = self->priv->begin;
		vala_source_location_init (&_vala_token_end, _tmp2_, self->priv->line, self->priv->column);
		result = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	vala_markup_reader_set_content (self, NULL);
	vala_markup_reader_set_name (self, NULL);
	vala_markup_reader_space (self);
	type = VALA_MARKUP_TOKEN_TYPE_NONE;
	_tmp3_ = self->priv->current;
	begin = _tmp3_;
	_tmp4_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp4_, self->priv->line, self->priv->column);
	_tmp5_ = self->priv->current;
	_tmp6_ = self->priv->end;
	if (_tmp5_ >= _tmp6_) {
		type = VALA_MARKUP_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		if (_tmp8_ == '<') {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = self->priv->current;
			self->priv->current = _tmp9_ + 1;
			_tmp10_ = self->priv->current;
			_tmp11_ = self->priv->end;
			if (_tmp10_ >= _tmp11_) {
			} else {
				gchar* _tmp12_;
				gchar _tmp13_;
				_tmp12_ = self->priv->current;
				_tmp13_ = _tmp12_[0];
				if (_tmp13_ == '?') {
				} else {
					gchar* _tmp14_;
					gchar _tmp15_;
					_tmp14_ = self->priv->current;
					_tmp15_ = _tmp14_[0];
					if (_tmp15_ == '!') {
						gchar* _tmp16_;
						gboolean _tmp17_ = FALSE;
						gboolean _tmp18_ = FALSE;
						gchar* _tmp19_;
						gchar* _tmp20_;
						_tmp16_ = self->priv->current;
						self->priv->current = _tmp16_ + 1;
						_tmp19_ = self->priv->current;
						_tmp20_ = self->priv->end;
						if (_tmp19_ < (_tmp20_ - 1)) {
							gchar* _tmp21_;
							gchar _tmp22_;
							_tmp21_ = self->priv->current;
							_tmp22_ = _tmp21_[0];
							_tmp18_ = _tmp22_ == '-';
						} else {
							_tmp18_ = FALSE;
						}
						if (_tmp18_) {
							gchar* _tmp23_;
							gchar _tmp24_;
							_tmp23_ = self->priv->current;
							_tmp24_ = _tmp23_[1];
							_tmp17_ = _tmp24_ == '-';
						} else {
							_tmp17_ = FALSE;
						}
						if (_tmp17_) {
							gchar* _tmp25_;
							ValaSourceLocation _tmp41_ = {0};
							ValaSourceLocation _tmp42_ = {0};
							ValaMarkupTokenType _tmp43_;
							_tmp25_ = self->priv->current;
							self->priv->current = _tmp25_ + 2;
							while (TRUE) {
								gchar* _tmp26_;
								gchar* _tmp27_;
								gboolean _tmp28_ = FALSE;
								gboolean _tmp29_ = FALSE;
								gchar* _tmp30_;
								gchar _tmp31_;
								gchar* _tmp40_;
								_tmp26_ = self->priv->current;
								_tmp27_ = self->priv->end;
								if (!(_tmp26_ < (_tmp27_ - 2))) {
									break;
								}
								_tmp30_ = self->priv->current;
								_tmp31_ = _tmp30_[0];
								if (_tmp31_ == '-') {
									gchar* _tmp32_;
									gchar _tmp33_;
									_tmp32_ = self->priv->current;
									_tmp33_ = _tmp32_[1];
									_tmp29_ = _tmp33_ == '-';
								} else {
									_tmp29_ = FALSE;
								}
								if (_tmp29_) {
									gchar* _tmp34_;
									gchar _tmp35_;
									_tmp34_ = self->priv->current;
									_tmp35_ = _tmp34_[2];
									_tmp28_ = _tmp35_ == '>';
								} else {
									_tmp28_ = FALSE;
								}
								if (_tmp28_) {
									gchar* _tmp36_;
									_tmp36_ = self->priv->current;
									self->priv->current = _tmp36_ + 3;
									break;
								} else {
									gchar* _tmp37_;
									gchar _tmp38_;
									_tmp37_ = self->priv->current;
									_tmp38_ = _tmp37_[0];
									if (_tmp38_ == '\n') {
										gint _tmp39_;
										_tmp39_ = self->priv->line;
										self->priv->line = _tmp39_ + 1;
										self->priv->column = 0;
									}
								}
								_tmp40_ = self->priv->current;
								self->priv->current = _tmp40_ + 1;
							}
							_tmp43_ = vala_markup_reader_read_token (self, &_tmp41_, &_tmp42_);
							_vala_token_begin = _tmp41_;
							_vala_token_end = _tmp42_;
							result = _tmp43_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					} else {
						gchar* _tmp44_;
						gchar _tmp45_;
						_tmp44_ = self->priv->current;
						_tmp45_ = _tmp44_[0];
						if (_tmp45_ == '/') {
							gchar* _tmp46_;
							gchar* _tmp47_;
							gchar* _tmp48_;
							gboolean _tmp49_ = FALSE;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp54_;
							type = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
							_tmp46_ = self->priv->current;
							self->priv->current = _tmp46_ + 1;
							_tmp47_ = vala_markup_reader_read_name (self);
							_tmp48_ = _tmp47_;
							vala_markup_reader_set_name (self, _tmp48_);
							_g_free0 (_tmp48_);
							_tmp50_ = self->priv->current;
							_tmp51_ = self->priv->end;
							if (_tmp50_ >= _tmp51_) {
								_tmp49_ = TRUE;
							} else {
								gchar* _tmp52_;
								gchar _tmp53_;
								_tmp52_ = self->priv->current;
								_tmp53_ = _tmp52_[0];
								_tmp49_ = _tmp53_ != '>';
							}
							if (_tmp49_) {
							}
							_tmp54_ = self->priv->current;
							self->priv->current = _tmp54_ + 1;
						} else {
							gchar* _tmp55_;
							gchar* _tmp56_;
							gchar* _tmp93_;
							gchar _tmp94_;
							gboolean _tmp96_ = FALSE;
							gchar* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp101_;
							type = VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
							_tmp55_ = vala_markup_reader_read_name (self);
							_tmp56_ = _tmp55_;
							vala_markup_reader_set_name (self, _tmp56_);
							_g_free0 (_tmp56_);
							vala_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp57_ = FALSE;
								gboolean _tmp58_ = FALSE;
								gchar* _tmp59_;
								gchar* _tmp60_;
								gchar* attr_name = NULL;
								gchar* _tmp65_;
								gboolean _tmp66_ = FALSE;
								gchar* _tmp67_;
								gchar* _tmp68_;
								gchar* _tmp71_;
								gboolean _tmp72_ = FALSE;
								gboolean _tmp73_ = FALSE;
								gchar* _tmp74_;
								gchar* _tmp75_;
								gchar quote = '\0';
								gchar* _tmp80_;
								gchar _tmp81_;
								gchar* _tmp82_;
								gchar* attr_value = NULL;
								gchar* _tmp83_;
								gboolean _tmp84_ = FALSE;
								gchar* _tmp85_;
								gchar* _tmp86_;
								gchar* _tmp89_;
								ValaMap* _tmp90_;
								const gchar* _tmp91_;
								const gchar* _tmp92_;
								_tmp59_ = self->priv->current;
								_tmp60_ = self->priv->end;
								if (_tmp59_ < _tmp60_) {
									gchar* _tmp61_;
									gchar _tmp62_;
									_tmp61_ = self->priv->current;
									_tmp62_ = _tmp61_[0];
									_tmp58_ = _tmp62_ != '>';
								} else {
									_tmp58_ = FALSE;
								}
								if (_tmp58_) {
									gchar* _tmp63_;
									gchar _tmp64_;
									_tmp63_ = self->priv->current;
									_tmp64_ = _tmp63_[0];
									_tmp57_ = _tmp64_ != '/';
								} else {
									_tmp57_ = FALSE;
								}
								if (!_tmp57_) {
									break;
								}
								_tmp65_ = vala_markup_reader_read_name (self);
								attr_name = _tmp65_;
								vala_markup_reader_space (self);
								_tmp67_ = self->priv->current;
								_tmp68_ = self->priv->end;
								if (_tmp67_ >= _tmp68_) {
									_tmp66_ = TRUE;
								} else {
									gchar* _tmp69_;
									gchar _tmp70_;
									_tmp69_ = self->priv->current;
									_tmp70_ = _tmp69_[0];
									_tmp66_ = _tmp70_ != '=';
								}
								if (_tmp66_) {
								}
								_tmp71_ = self->priv->current;
								self->priv->current = _tmp71_ + 1;
								vala_markup_reader_space (self);
								_tmp74_ = self->priv->current;
								_tmp75_ = self->priv->end;
								if (_tmp74_ >= _tmp75_) {
									_tmp73_ = TRUE;
								} else {
									gchar* _tmp76_;
									gchar _tmp77_;
									_tmp76_ = self->priv->current;
									_tmp77_ = _tmp76_[0];
									_tmp73_ = _tmp77_ != '"';
								}
								if (_tmp73_) {
									_tmp72_ = TRUE;
								} else {
									gchar* _tmp78_;
									gchar _tmp79_;
									_tmp78_ = self->priv->current;
									_tmp79_ = _tmp78_[0];
									_tmp72_ = _tmp79_ != '\'';
								}
								if (_tmp72_) {
								}
								_tmp80_ = self->priv->current;
								_tmp81_ = _tmp80_[0];
								quote = _tmp81_;
								_tmp82_ = self->priv->current;
								self->priv->current = _tmp82_ + 1;
								_tmp83_ = vala_markup_reader_text (self, quote, FALSE);
								attr_value = _tmp83_;
								_tmp85_ = self->priv->current;
								_tmp86_ = self->priv->end;
								if (_tmp85_ >= _tmp86_) {
									_tmp84_ = TRUE;
								} else {
									gchar* _tmp87_;
									gchar _tmp88_;
									_tmp87_ = self->priv->current;
									_tmp88_ = _tmp87_[0];
									_tmp84_ = _tmp88_ != quote;
								}
								if (_tmp84_) {
								}
								_tmp89_ = self->priv->current;
								self->priv->current = _tmp89_ + 1;
								_tmp90_ = self->priv->attributes;
								_tmp91_ = attr_name;
								_tmp92_ = attr_value;
								vala_map_set (_tmp90_, _tmp91_, _tmp92_);
								vala_markup_reader_space (self);
								_g_free0 (attr_value);
								_g_free0 (attr_name);
							}
							_tmp93_ = self->priv->current;
							_tmp94_ = _tmp93_[0];
							if (_tmp94_ == '/') {
								gchar* _tmp95_;
								self->priv->empty_element = TRUE;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + 1;
								vala_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							_tmp97_ = self->priv->current;
							_tmp98_ = self->priv->end;
							if (_tmp97_ >= _tmp98_) {
								_tmp96_ = TRUE;
							} else {
								gchar* _tmp99_;
								gchar _tmp100_;
								_tmp99_ = self->priv->current;
								_tmp100_ = _tmp99_[0];
								_tmp96_ = _tmp100_ != '>';
							}
							if (_tmp96_) {
							}
							_tmp101_ = self->priv->current;
							self->priv->current = _tmp101_ + 1;
						}
					}
				}
			}
		} else {
			gchar* _tmp102_;
			gchar _tmp103_;
			vala_markup_reader_space (self);
			_tmp102_ = self->priv->current;
			_tmp103_ = _tmp102_[0];
			if (_tmp103_ != '<') {
				gchar* _tmp104_;
				gchar* _tmp105_;
				_tmp104_ = vala_markup_reader_text (self, '<', TRUE);
				_tmp105_ = _tmp104_;
				vala_markup_reader_set_content (self, _tmp105_);
				_g_free0 (_tmp105_);
			} else {
				ValaSourceLocation _tmp106_ = {0};
				ValaSourceLocation _tmp107_ = {0};
				ValaMarkupTokenType _tmp108_;
				_tmp108_ = vala_markup_reader_read_token (self, &_tmp106_, &_tmp107_);
				_vala_token_begin = _tmp106_;
				_vala_token_end = _tmp107_;
				result = _tmp108_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
			type = VALA_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	_tmp109_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp109_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static gchar*
vala_markup_reader_text (ValaMarkupReader* self,
                         gchar end_char,
                         gboolean rm_trailing_whitespace)
{
	GString* content = NULL;
	GString* _tmp0_;
	gchar* text_begin = NULL;
	gchar* _tmp1_;
	gchar* last_linebreak = NULL;
	gchar* _tmp2_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GString* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	content = _tmp0_;
	_tmp1_ = self->priv->current;
	text_begin = _tmp1_;
	_tmp2_ = self->priv->current;
	last_linebreak = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gunichar u = 0U;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = _tmp7_ != end_char;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = self->priv->end;
		_tmp10_ = self->priv->current;
		u = g_utf8_get_char_validated ((const gchar*) _tmp8_, (gssize) ((glong) (_tmp9_ - _tmp10_)));
		if (u == ((gunichar) -1)) {
			vala_report_error (NULL, "invalid UTF-8 character");
		} else {
			if (u == ((gunichar) '&')) {
				gchar* next_pos = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = self->priv->current;
				next_pos = _tmp11_ + g_unichar_to_utf8 (u, NULL);
				_tmp12_ = next_pos;
				if (g_str_has_prefix ((const gchar*) _tmp12_, "amp;")) {
					GString* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					GString* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp13_ = content;
					_tmp14_ = text_begin;
					_tmp15_ = self->priv->current;
					_tmp16_ = text_begin;
					_tmp17_ = string_substring ((const gchar*) _tmp14_, (glong) 0, (glong) ((gint) (_tmp15_ - _tmp16_)));
					_tmp18_ = _tmp17_;
					g_string_append (_tmp13_, _tmp18_);
					_g_free0 (_tmp18_);
					_tmp19_ = content;
					g_string_append_c (_tmp19_, '&');
					_tmp20_ = self->priv->current;
					self->priv->current = _tmp20_ + 5;
					_tmp21_ = self->priv->current;
					text_begin = _tmp21_;
				} else {
					gchar* _tmp22_;
					_tmp22_ = next_pos;
					if (g_str_has_prefix ((const gchar*) _tmp22_, "quot;")) {
						GString* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						GString* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						_tmp23_ = content;
						_tmp24_ = text_begin;
						_tmp25_ = self->priv->current;
						_tmp26_ = text_begin;
						_tmp27_ = string_substring ((const gchar*) _tmp24_, (glong) 0, (glong) ((gint) (_tmp25_ - _tmp26_)));
						_tmp28_ = _tmp27_;
						g_string_append (_tmp23_, _tmp28_);
						_g_free0 (_tmp28_);
						_tmp29_ = content;
						g_string_append_c (_tmp29_, '"');
						_tmp30_ = self->priv->current;
						self->priv->current = _tmp30_ + 6;
						_tmp31_ = self->priv->current;
						text_begin = _tmp31_;
					} else {
						gchar* _tmp32_;
						_tmp32_ = next_pos;
						if (g_str_has_prefix ((const gchar*) _tmp32_, "apos;")) {
							GString* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							GString* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp33_ = content;
							_tmp34_ = text_begin;
							_tmp35_ = self->priv->current;
							_tmp36_ = text_begin;
							_tmp37_ = string_substring ((const gchar*) _tmp34_, (glong) 0, (glong) ((gint) (_tmp35_ - _tmp36_)));
							_tmp38_ = _tmp37_;
							g_string_append (_tmp33_, _tmp38_);
							_g_free0 (_tmp38_);
							_tmp39_ = content;
							g_string_append_c (_tmp39_, '\'');
							_tmp40_ = self->priv->current;
							self->priv->current = _tmp40_ + 6;
							_tmp41_ = self->priv->current;
							text_begin = _tmp41_;
						} else {
							gchar* _tmp42_;
							_tmp42_ = next_pos;
							if (g_str_has_prefix ((const gchar*) _tmp42_, "lt;")) {
								GString* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								GString* _tmp49_;
								gchar* _tmp50_;
								gchar* _tmp51_;
								_tmp43_ = content;
								_tmp44_ = text_begin;
								_tmp45_ = self->priv->current;
								_tmp46_ = text_begin;
								_tmp47_ = string_substring ((const gchar*) _tmp44_, (glong) 0, (glong) ((gint) (_tmp45_ - _tmp46_)));
								_tmp48_ = _tmp47_;
								g_string_append (_tmp43_, _tmp48_);
								_g_free0 (_tmp48_);
								_tmp49_ = content;
								g_string_append_c (_tmp49_, '<');
								_tmp50_ = self->priv->current;
								self->priv->current = _tmp50_ + 4;
								_tmp51_ = self->priv->current;
								text_begin = _tmp51_;
							} else {
								gchar* _tmp52_;
								_tmp52_ = next_pos;
								if (g_str_has_prefix ((const gchar*) _tmp52_, "gt;")) {
									GString* _tmp53_;
									gchar* _tmp54_;
									gchar* _tmp55_;
									gchar* _tmp56_;
									gchar* _tmp57_;
									gchar* _tmp58_;
									GString* _tmp59_;
									gchar* _tmp60_;
									gchar* _tmp61_;
									_tmp53_ = content;
									_tmp54_ = text_begin;
									_tmp55_ = self->priv->current;
									_tmp56_ = text_begin;
									_tmp57_ = string_substring ((const gchar*) _tmp54_, (glong) 0, (glong) ((gint) (_tmp55_ - _tmp56_)));
									_tmp58_ = _tmp57_;
									g_string_append (_tmp53_, _tmp58_);
									_g_free0 (_tmp58_);
									_tmp59_ = content;
									g_string_append_c (_tmp59_, '>');
									_tmp60_ = self->priv->current;
									self->priv->current = _tmp60_ + 4;
									_tmp61_ = self->priv->current;
									text_begin = _tmp61_;
								} else {
									gchar* _tmp62_;
									_tmp62_ = next_pos;
									if (g_str_has_prefix ((const gchar*) _tmp62_, "percnt;")) {
										GString* _tmp63_;
										gchar* _tmp64_;
										gchar* _tmp65_;
										gchar* _tmp66_;
										gchar* _tmp67_;
										gchar* _tmp68_;
										GString* _tmp69_;
										gchar* _tmp70_;
										gchar* _tmp71_;
										_tmp63_ = content;
										_tmp64_ = text_begin;
										_tmp65_ = self->priv->current;
										_tmp66_ = text_begin;
										_tmp67_ = string_substring ((const gchar*) _tmp64_, (glong) 0, (glong) ((gint) (_tmp65_ - _tmp66_)));
										_tmp68_ = _tmp67_;
										g_string_append (_tmp63_, _tmp68_);
										_g_free0 (_tmp68_);
										_tmp69_ = content;
										g_string_append_c (_tmp69_, '%');
										_tmp70_ = self->priv->current;
										self->priv->current = _tmp70_ + 8;
										_tmp71_ = self->priv->current;
										text_begin = _tmp71_;
									} else {
										gchar* _tmp72_;
										_tmp72_ = self->priv->current;
										self->priv->current = _tmp72_ + g_unichar_to_utf8 (u, NULL);
									}
								}
							}
						}
					}
				}
			} else {
				gchar* _tmp75_;
				gint _tmp76_;
				if (u == ((gunichar) '\n')) {
					gint _tmp73_;
					gchar* _tmp74_;
					_tmp73_ = self->priv->line;
					self->priv->line = _tmp73_ + 1;
					self->priv->column = 0;
					_tmp74_ = self->priv->current;
					last_linebreak = _tmp74_;
				}
				_tmp75_ = self->priv->current;
				self->priv->current = _tmp75_ + g_unichar_to_utf8 (u, NULL);
				_tmp76_ = self->priv->column;
				self->priv->column = _tmp76_ + 1;
			}
		}
	}
	_tmp77_ = text_begin;
	_tmp78_ = self->priv->current;
	if (_tmp77_ != _tmp78_) {
		GString* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		_tmp79_ = content;
		_tmp80_ = text_begin;
		_tmp81_ = self->priv->current;
		_tmp82_ = text_begin;
		_tmp83_ = string_substring ((const gchar*) _tmp80_, (glong) 0, (glong) ((gint) (_tmp81_ - _tmp82_)));
		_tmp84_ = _tmp83_;
		g_string_append (_tmp79_, _tmp84_);
		_g_free0 (_tmp84_);
	}
	_tmp85_ = self->priv->current;
	_tmp86_ = last_linebreak;
	self->priv->column = self->priv->column + ((gint) (_tmp85_ - _tmp86_));
	if (rm_trailing_whitespace) {
		gchar* str_pos = NULL;
		GString* _tmp87_;
		const gchar* _tmp88_;
		GString* _tmp89_;
		GString* _tmp99_;
		gchar* _tmp100_;
		GString* _tmp101_;
		const gchar* _tmp102_;
		_tmp87_ = content;
		_tmp88_ = _tmp87_->str;
		_tmp89_ = content;
		str_pos = ((gchar*) _tmp88_) + _tmp89_->len;
		{
			gchar* _tmp90_;
			gboolean _tmp91_ = FALSE;
			_tmp90_ = str_pos;
			str_pos = _tmp90_ - 1;
			_tmp91_ = TRUE;
			while (TRUE) {
				gboolean _tmp93_ = FALSE;
				gchar* _tmp94_;
				GString* _tmp95_;
				const gchar* _tmp96_;
				if (!_tmp91_) {
					gchar* _tmp92_;
					_tmp92_ = str_pos;
					str_pos = _tmp92_ - 1;
				}
				_tmp91_ = FALSE;
				_tmp94_ = str_pos;
				_tmp95_ = content;
				_tmp96_ = _tmp95_->str;
				if (_tmp94_ > ((gchar*) _tmp96_)) {
					gchar* _tmp97_;
					gchar _tmp98_;
					_tmp97_ = str_pos;
					_tmp98_ = _tmp97_[0];
					_tmp93_ = g_ascii_isspace (_tmp98_);
				} else {
					_tmp93_ = FALSE;
				}
				if (!_tmp93_) {
					break;
				}
			}
		}
		_tmp99_ = content;
		_tmp100_ = str_pos;
		_tmp101_ = content;
		_tmp102_ = _tmp101_->str;
		g_string_erase (_tmp99_, (gssize) ((_tmp100_ - ((gchar*) _tmp102_)) + 1), (gssize) -1);
	}
	_tmp103_ = content;
	_tmp104_ = _tmp103_->str;
	_tmp105_ = g_strdup (_tmp104_);
	result = _tmp105_;
	_g_string_free0 (content);
	return result;
}

static void
vala_markup_reader_space (ValaMarkupReader* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = g_ascii_isspace (_tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		if (_tmp6_ == '\n') {
			gint _tmp7_;
			_tmp7_ = self->priv->line;
			self->priv->line = _tmp7_ + 1;
			self->priv->column = 0;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
}

static void
vala_value_markup_reader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_markup_reader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_markup_reader_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_markup_reader_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_markup_reader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_markup_reader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_markup_reader_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaMarkupReader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_markup_reader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_markup_reader_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	ValaMarkupReader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_markup_reader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_markup_reader (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ValaParamSpecMarkupReader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_MARKUP_READER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_markup_reader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_MARKUP_READER), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_markup_reader (GValue* value,
                              gpointer v_object)
{
	ValaMarkupReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_MARKUP_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_MARKUP_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_markup_reader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_markup_reader_unref (old);
	}
}

void
vala_value_take_markup_reader (GValue* value,
                               gpointer v_object)
{
	ValaMarkupReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_MARKUP_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_MARKUP_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_markup_reader_unref (old);
	}
}

static void
vala_markup_reader_class_init (ValaMarkupReaderClass * klass,
                               gpointer klass_data)
{
	vala_markup_reader_parent_class = g_type_class_peek_parent (klass);
	((ValaMarkupReaderClass *) klass)->finalize = vala_markup_reader_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMarkupReader_private_offset);
}

static void
vala_markup_reader_instance_init (ValaMarkupReader * self,
                                  gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_markup_reader_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	self->priv->attributes = (ValaMap*) _tmp3_;
	self->ref_count = 1;
}

static void
vala_markup_reader_finalize (ValaMarkupReader * obj)
{
	ValaMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MARKUP_READER, ValaMarkupReader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_content);
	_g_mapped_file_unref0 (self->priv->mapped_file);
	_vala_map_unref0 (self->priv->attributes);
}

/**
 * Simple reader for a subset of XML.
 */
static GType
vala_markup_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_markup_reader_init, vala_value_markup_reader_free_value, vala_value_markup_reader_copy_value, vala_value_markup_reader_peek_pointer, "p", vala_value_markup_reader_collect_value, "p", vala_value_markup_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMarkupReader), 0, (GInstanceInitFunc) vala_markup_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_markup_reader_type_id;
	vala_markup_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaMarkupReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaMarkupReader_private_offset = g_type_add_instance_private (vala_markup_reader_type_id, sizeof (ValaMarkupReaderPrivate));
	return vala_markup_reader_type_id;
}

GType
vala_markup_reader_get_type (void)
{
	static volatile gsize vala_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_reader_type_id__volatile)) {
		GType vala_markup_reader_type_id;
		vala_markup_reader_type_id = vala_markup_reader_get_type_once ();
		g_once_init_leave (&vala_markup_reader_type_id__volatile, vala_markup_reader_type_id);
	}
	return vala_markup_reader_type_id__volatile;
}

gpointer
vala_markup_reader_ref (gpointer instance)
{
	ValaMarkupReader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_markup_reader_unref (gpointer instance)
{
	ValaMarkupReader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_MARKUP_READER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

const gchar*
vala_markup_token_type_to_string (ValaMarkupTokenType self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_MARKUP_TOKEN_TYPE_START_ELEMENT:
		{
			result = "start element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_END_ELEMENT:
		{
			result = "end element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_TEXT:
		{
			result = "text";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_EOF:
		{
			result = "end of file";
			return result;
		}
		default:
		{
			result = "unknown token type";
			return result;
		}
	}
}

static GType
vala_markup_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_MARKUP_TOKEN_TYPE_NONE, "VALA_MARKUP_TOKEN_TYPE_NONE", "none"}, {VALA_MARKUP_TOKEN_TYPE_START_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_START_ELEMENT", "start-element"}, {VALA_MARKUP_TOKEN_TYPE_END_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_END_ELEMENT", "end-element"}, {VALA_MARKUP_TOKEN_TYPE_TEXT, "VALA_MARKUP_TOKEN_TYPE_TEXT", "text"}, {VALA_MARKUP_TOKEN_TYPE_EOF, "VALA_MARKUP_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
	GType vala_markup_token_type_type_id;
	vala_markup_token_type_type_id = g_enum_register_static ("ValaMarkupTokenType", values);
	return vala_markup_token_type_type_id;
}

GType
vala_markup_token_type_get_type (void)
{
	static volatile gsize vala_markup_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_token_type_type_id__volatile)) {
		GType vala_markup_token_type_type_id;
		vala_markup_token_type_type_id = vala_markup_token_type_get_type_once ();
		g_once_init_leave (&vala_markup_token_type_type_id__volatile, vala_markup_token_type_type_id);
	}
	return vala_markup_token_type_type_id__volatile;
}

