Cannot take address of temporary value.

Erroneous code example:

```compile_fail,E0745
# #![feature(raw_ref_op)]
fn temp_address() {
    let ptr = &raw const 2;   // ERROR
}
```

To avoid the error, first bind the temporary to a named local variable.

```
# #![feature(raw_ref_op)]
fn temp_address() {
    let val = 2;
    let ptr = &raw const val;
}
```
