.TH XEV 1 __xorgversion__
.SH NAME
xev - print contents of X events
.SH SYNOPSIS
.B "xev"
[\-display \fIdisplayname\fP] [\-geometry \fIgeom\fP]
[\-bw \fIpixels\fP] [\-bs \fI{NotUseful,WhenMapped,Always}\fP]
[\-id \fIwindowid\fP] [\-root] [\-s] [\-name \fIstring\fP] [\-rv]
.SH DESCRIPTION
.PP
\fIXev\fP creates a window and then asks the X server to send it
\fIevents\fP whenever anything happens to the window (such as it being
moved, resized, typed in, clicked in, etc.).  You can also attach it to an
existing window.  It is useful for seeing what causes events to occur and to
display the information that they contain; it is essentially a debugging and
development tool, and should not be needed in normal usage.
.SH OPTIONS
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry \fIgeom\fP
This option specifies the size and/or location of the window, if a window is
to be created.
.TP 8
.B \-bw \fIpixels\fP
This option specifies the border width for the window.
.TP 8
.B \-bs \fI{NotUseful,WhenMapped,Always}\fP
This option specifies what kind of backing store to give the window.
The default is NotUseful. Backing store refers to the the pixels saved
off-screen when the X server maintains the contents of a window; NotUseful
means that the xev process will redraw its contents itself, as necessary.
.TP 8
.B \-id \fIwindowid\fP
This option specifies that the window with the given id should be
monitored, instead of creating a new window.
.TP 8
.B \-root
This option specifies that the root window should be
monitored, instead of creating a new window.
.TP 8
.B \-s
This option specifies that save-unders should be enabled on the window. Save
unders are similar to backing store, but they refer rather to the saving of
pixels off-screen when the current window obscures other windows. Save
unders are only advisory, and are normally set for popup dialogs and other
transient windows.
.TP 8
.B \-name \fIstring\fP
This option specifies the name to assign to the created window.
.TP 8
.B \-rv
This option specifies that the window should be in reverse video.
.SH "SEE ALSO"
X(__miscmansuffix__), xwininfo(__appmansuffix__), xdpyinfo(__appmansuffix__), Xlib Programmers Manual, X Protocol
Specification
.br
See \fIX(__miscmansuffix__)\fP for a full statement of rights and permissions.
.SH AUTHOR
Jim Fulton, MIT X Consortium
