/* Any copyright is dedicated to the public domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

// Bug 709759 - Test the stop ability of <iframe mozbrowser>.

// The img that is loaded will never be returned and will block
// the page from loading, the timeout ensures that the page is
// actually blocked from loading, once stop is called the
// image load will be cancaelled and mozbrowserloadend should be called.

"use strict";
SimpleTest.waitForExplicitFinish();

var iframe;
var stopped = false;
var imgSrc = 'http://test/tests/dom/browser-element/mochitest/file_bug709759.sjs';

function runTest() {
  browserElementTestHelpers.setEnabledPref(true);
  browserElementTestHelpers.addPermission();

  iframe = document.createElement('iframe');
  iframe.mozbrowser = true;

  iframe.addEventListener('mozbrowserloadend', loadend);
  iframe.src = 'data:text/html,<html>' +
    '<body><img src="' + imgSrc + '" /></body></html>';

  document.body.appendChild(iframe);

  setTimeout(function() {
    stopped = true;
    iframe.stop();
  }, 200);
}

function loadend() {
  ok(stopped, 'Iframes network connections were stopped');
  SimpleTest.finish();
}

runTest();
