.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbAddGeomDoodad __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAddGeomDoodad \- Add one doodad to a section of a keyboard geometry or to the 
top-level geometry
.SH SYNOPSIS
.HP
.B XkbDoodadPtr XkbAddGeomDoodad
.BI "(\^XkbGeometryPtr " "geom" "\^,"
.BI "XkbSectionPtr " "section" "\^,"
.BI "Atom " "name" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- geom
geometry to which the doodad is added
.TP
.I \- section
section, if any, to which the doodad is added
.TP
.I \- name
name of the new doodad 
.SH DESCRIPTION
.LP
Xkb provides functions to add a single new element to the top-level keyboard 
geometry. In each case the 
.I num_ * 
fields of the corresponding structure is incremented by 1. These functions do 
not change 
.I sz_* 
unless there is no more room in the array. Some of these functions fill in the 
values of the element's structure from the arguments. For other functions, you 
must explicitly write code to fill the structure's elements.

The top-level geometry description includes a list of 
.I geometry properties. 
A geometry property associates an arbitrary string with an equally arbitrary 
name. Programs that display images of keyboards can use geometry properties as 
hints, but they are not interpreted by Xkb. No other geometry structures refer 
to geometry properties.

A 
.I doodad 
describes some visible aspect of the keyboard that is not a key and is not a 
section. 
.I XkbAddGeomDoodad 
adds a doodad with name specified by 
.I name 
to the geometry 
.I geom 
if 
.I section 
is NULL or to the section of the geometry specified by 
.I section 
if 
.I section 
is not NULL. 
.I XkbAddGeomDoodad 
returns NULL if any of the parameters is empty or if it was not able to allocate 
space for the doodad. If there is already a doodad with the name 
.I name 
in the doodad array for the geometry (if 
.I section 
is NULL) or the section (if 
.I section 
is non-NULL), a pointer to that doodad is returned. To allocate space for an 
arbitrary number of doodads to a section, use the 
.I XkbAllocGeomSectionDoodads 
function. To allocate space for an arbitrary number of doodads to a keyboard 
geometry, use the 
.I XkbAllocGeomDoodads 
function.
.SH STRUCTURES
.LP
.nf

    typedef union _XkbDoodad {
        XkbAnyDoodadRec            any;
        XkbShapeDoodadRec          shape;
        XkbTextDoodadRec           text;
        XkbIndicatorDoodadRec      indicator;
        XkbLogoDoodadRec           logo;
    } XkbDoodadRec, *XkbDoodadPtr;
    
.fi
.SH "SEE ALSO"
.BR XkbAllocGeomDoodads (__libmansuffix__),
.BR XkbAllocGeomSectionDoodads (__libmansuffix__)
