.ds q \N'34'
.TH WACOM 4x "linuxwacom 0.8.3" "X Version 11"
.SH NAME
wacom \- Wacom input driver
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" idevname \*q
.B  "  Driver \*qwacom\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B wacom 
is an X input driver for Wacom devices.
.PP
The
.B wacom
driver functions as a pointer input device, and may be used as the
X server's core pointer.
.SH SUPPORTED HARDWARE
This driver supports the Wacom IV and Wacom V protocols. Serial tablets only 
need this driver.  USB tablet support is available on some Linux platforms. 
USB tablets needs wacom kernel driver being loaded before this driver starts.  
Please check linuxwacom.sf.net for latest updates of Wacom X and kernel drivers.
.SH CONFIGURATION DETAILS
Please refer to xorg.conf(5x) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
Multiple instances of the Wacom devices can cohabit. It can be useful
to define multiple devices with different active zones. Each device
supports the following entries:
.RS 8
.TP 4
.B Option \fI"Type"\fP \fI"stylus"|"eraser"|"cursor"|"pad"|"touch"\fP
sets the type of tool the device represents. This option is mandatory.  
The core options, such as "SendCoreEvents" or "AlwaysCore", are  
unnecessary in Gimp if you don't need to move system cursor outside 
of Gimp drawing area.  "pad" is for Intuos 3 or Cintiq 21UX tablet 
ExpressKeys/menu strips, and Graphire 4 or Bamboo tablet buttons, wheel, 
and/or ring.  It is required  for Intuos3,  CintiqV5, Graphire 4, and 
Bamboo if you want to use keystroke features.  "pad" is reported as a 
second tool in the driver. "touch" is for the tablet with touch support. 
Right now only a few Tablet PCs have this feature. 
.TP 4
.B Option \fI"Device"\fP \fI"path"\fP
sets the path to the special file which represents serial line where
the tablet is plugged.  You have to specify it for each subsection with
the same value if you want to have multiple devices with the same tablet.
This option is mandatory.
.TP 4
.B Option \fI"ForceDevice"\fP \fI"ISDV4"\fP
tells the driver to dialog with the tablet the serial Tablet PC way.  It 
is a special Wacom IV protocol, called ISDV4 protocol.  This option is 
mandatory for serial Tablet PCs only.
.TP 4
.B Option \fI"Suppress"\fP \fI"number"\fP
sets the position increment under which not to transmit coordinates.
This entry must be specified only in the first Wacom subsection if you have
multiple devices for one tablet. If you don't specify this entry, the default 
value,  which is 2, will be used. To disable suppression, the entry should be 
specified as 0.  When suppress is defined,  an event will be sent only when at 
least one of the following conditions is met:

        the change between the current X coordinate and the previous one is
greater than suppress;

        the change between the current Y coordinate and the previous one is
greater than suppress;

        the change between the current pressure and the previous one is
greater than suppress;

        the change between the  current degree of rotation and the previous
one of the transducer is greater than suppress;

        the change between the current absolute wheel value and the previous 
one is equal to or greater than suppress;

        the change between the current tilt value and the previous one is equal 
to or greater than suppress (if tilt is supported);

        relative wheel value has changed;

        button value has changed;

        proximity has changed.
.TP 4
.B Option \fI"Mode"\fP \fI"Relative"|"Absolute"\fP
sets the mode of the device.  The default value for stylus, pad and
eraser is Absolute; cursor is Relative;
touch defaults to Relative for tablets with touch pads and Absolute for
touch screens.
.TP 4
.B Option \fI"TopX"\fP \fI"number"\fP
X coordinate of the top corner of the active zone.  Default to 0. 
.TP 4
.B Option \fI"TopY"\fP \fI"number"\fP
Y coordinate of the top corner of the active zone.  Default to 0.
.TP 4
.B Option \fI"BottomX"\fP \fI"number"\fP
X coordinate of the bottom corner of the active zone.  Default to width of the tablet.
.TP 4
.B Option \fI"BottomY"\fP \fI"number"\fP
Y coordinate of the bottom corner of the active zone.  Default to height of the tablet.
.TP 4
.B Option \fI"ButtonsOnly"\fP \fI"on"|"off"\fP
disables the device's motion events.  Default to off.
.TP 4
.B Option \fI"ButtonM"\fP \fI"AC"\fP
reports an action AC when button M is pressed,  where M 
is one of the device supported  button numbers,  it can be 1 
to 32. Wacom uses a driver-internal button mapping, where any physical
button appears to the X server as the button specified by the ButtonM
mapping. Hence, if two physical buttons have the same ButtonM mapping, the
server will think they are the same physical button.
The default action reported to the X server is mouse button M click. Because
X uses buttons 4, 5, 6, and 7 as the four scrolling directions, physical
buttons 4 and higher are mapped to 8 and higher by default.
To ignore the button click, i.e., to not report any button click event 
to the X server,  use "0" or "button 0".
.TP 4
.B Option \fI"TPCButton"\fP \fI"on"|"off"\fP
enables the stylus buttons as  Tablet PC buttons,  i.e., reports stylus 
button event only when its tip is pressed.  Default to "on" for Tablet PCs; 
"off" for all other models.
.TP 4
.B Option \fI"Touch"\fP \fI"on"|"off"\fP
enables the touch event for Tablet PC that supports touch feature,  i.e., 
system cursor moves when user touches the tablet.  Default to "on" for 
Tablet PCs with touch feature; "off" for all other models.
.TP 4
.B Option \fI"Capacity"\fP \fI"number"\fP
sets touch sensitivity level for capacitive touch device, where number 
can be an integer from -1 to 5.  Default is 3 for capacitive tools and 
-1 for none capacitive tools.
.TP 4
.B Option \fI"Speed"\fP \fI"Rspeed"\fP
sets the cursor's relative movement speed to Rspeed.  The default value is 1.0.  
A Rspeed greater than 1.0 will speed up the cursor's relative movement.  A Rspeed 
less than 1.0 but greater than 0 will slow down the cursor's relative movement. 
A Rspeed too close to 0 is not recommanded.
.TP 4
.B Option \fI"Twinview"\fP \fI"horizontal"|"vertical"|"leftof"|"aboveof"|"xinerama"|"none"\fP
sets the orientation of TwinView to map the tablet to one screen and to be able 
to move the screen cursor from one screen to the other when tool reaches the 
edge of the tablet.  The cursor can be constrained in a specific screen if 
"ScreenNo" option is added.  If you  want to map the tablet to the whole desktop,   
you should NOT add this option.  The default is "none". Note: due to historic 
reason, "horizontal"  represents the  "RightOf" and "vertical" represents the 
"BelowOf" in acutal TwinView setup.
.TP 4
.B Option \fI"TVResolution"\fP \fI"res0,res1"\fP
specifies different resolutions for the two screens in TwinView setup.  For example, 
if the resolution of screen 0 (res0) is 1024x768 and screen 1 (res1) is 1280x1024, 
the option will be set to:
            Option "TVResolution" "1024x768,1280x1024" 

This option is used only when TwinView option is not none.  It is unnecessary to add 
this option if your screens are displaying in the same resolutions.
.TP 4
.B Option \fI"ScreenNo"\fP \fI"n"\fP
In a multi-monitor environment, specifies the screen number in which the cursor can move.
.TP 4
.B Option \fI"MMonitor"\fP \fI"n"\fP
turns on/off across monitor movement on a non-TwinView multi-monitor desktop. 
The default is "on". Here n starts from  0, which indicates the first screen.
.TP 4
.B Option \fI"Rotate"\fP \fI"CW"|"CCW"|"HALF"|"NONE"\fP
rotates the tablet orientation counterclockwise (CCW) or clockwise (CW) or 180 degrees (HALF). 
If you have specific tablet mappings, i.e. TopX/Y or BottomX/Y were set, the mapping will be 
applied before rotation. The default is "NONE".
.TP 4
.B Option \fI"PressCurve"\fP \fI"x1,y1,x2,y2"\fP
sets pressure curve by control points x1, y1, x2, and y2.  Their values are in range 
from 0..100. The input for 
	linear curve (default) is "0,0,100,100"; 
	slightly depressed curve (firmer) might be "5,0,100,95"; 
	slightly raised curve (softer) might be "0,5,95,100".
The pressure curve is only applicable to devices of type stylus or eraser,
other devices do not honor this setting.
.TP 4
.B Option \fI"KeepShape"\fP \fI"on"|"off"\fP
When this option is enabled, the active zone  begins according to TopX
and TopY.  The bottom corner is adjusted to keep the ratio width/height
of the active zone the same as the screen while maximizing the area
described by TopX, TopY, BottomX, BottomY.
.TP 4
.B Option \fI"DebugLevel"\fP \fI"number"\fP
sets the level of debugging info reported.  There are 12 levels, specified by 
the integers between 1 and 12.  Once it is defined, all the debug messages 
with a level less than or equal to the "number" will be logged into 
/etc/X11/Xorg.0.log.
.TP 4
.B Option \fI"CommonDBG"\fP \fI"number"\fP
sets the level of debugging info for all devices defined for the  
same tablet. There are 12 levels in use, specified by the 
integers between 1 and 12. Once it is defined, all the debug 
messages with a level less than or equal to the "number" will 
be logged into /etc/X11/Xorg.0.log.
.TP 4
.B Option \fI"CursorProx"\fP \fI"number"\fP
sets the max distance from tablet to stop reporting movement for cursor in relative mode. 
Default for Intuos series is 10, for Graphire series (including Volitos) is 42.
.TP 4
.B Option \fI"Serial"\fP \fI"number"\fP
sets the serial number associated with the physical device. This allows
to have multiple devices of the same type (i.e. multiple pens). This
option is only available on wacom V devices (Intuos series and Cintiq 21U). 
To see which serial number belongs to a device, you need to run the utility program, 
xsetwacom, which comes with linuxwacom package.
.TP 4
.B Option \fI"Threshold"\fP \fI"number"\fP
sets the pressure threshold used to generate a button 1 events of stylus.
The default is MaxPressure*3/50.
.RE
.SH "SEE ALSO"
Xorg(1x), xorg.conf(5x), xorgconfig(1x), Xserver(1x), X(7).
.SH AUTHORS
Frederic Lepied <lepied@xfree86.org>,
Ping Cheng <pingc@wacom.com>,
John E. Joganic <jej@j-arkadia.com>,
Magnus Vigerlöf <Magnus.Vigerlof@ipbo.se>
