/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import org.openrdf.sail.rdbms.schema.ValueTable;

public class URITable {
    private ValueTable shorter;
    private ValueTable longer;
    private int version;

    public URITable(ValueTable shorter, ValueTable longer) {
        this.shorter = shorter;
        this.longer = longer;
    }

    public void close() throws SQLException {
        this.shorter.close();
        this.longer.close();
    }

    public int getBatchSize() {
        return this.shorter.getBatchSize();
    }

    public int getVersion() {
        return this.version;
    }

    public String getShortTableName() {
        return this.shorter.getName();
    }

    public String getLongTableName() {
        return this.longer.getName();
    }

    public void insertShort(Number id, String value) throws SQLException, InterruptedException {
        this.shorter.insert(id, value);
    }

    public void insertLong(Number id, String value) throws SQLException, InterruptedException {
        this.longer.insert(id, value);
    }

    public boolean expunge(String condition) throws SQLException {
        boolean bool = false;
        bool |= this.shorter.expunge(condition);
        return bool |= this.longer.expunge(condition);
    }

    public String toString() {
        return this.shorter.getName() + " UNION ALL " + this.longer.getName();
    }

    public void optimize() throws SQLException {
        this.shorter.optimize();
        this.longer.optimize();
    }
}

