/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

public class OncRpcException
extends Exception {
    public static final int RPC_SUCCESS = 0;
    public static final int RPC_CANTENCODEARGS = 1;
    public static final int RPC_CANTDECODERES = 2;
    public static final int RPC_CANTSEND = 3;
    public static final int RPC_CANTRECV = 4;
    public static final int RPC_TIMEDOUT = 5;
    public static final int RPC_VERSMISMATCH = 6;
    public static final int RPC_AUTHERROR = 7;
    public static final int RPC_PROGUNAVAIL = 8;
    public static final int RPC_PROGVERSMISMATCH = 9;
    public static final int RPC_PROCUNAVAIL = 10;
    public static final int RPC_CANTDECODEARGS = 11;
    public static final int RPC_SYSTEMERROR = 12;
    public static final int RPC_UNKNOWNPROTO = 17;
    public static final int RPC_PMAPFAILURE = 14;
    public static final int RPC_PROGNOTREGISTERED = 15;
    public static final int RPC_FAILED = 16;
    public static final int RPC_BUFFEROVERFLOW = 42;
    public static final int RPC_BUFFERUNDERFLOW = 43;
    public static final int RPC_WRONGMESSAGE = 44;
    private int reason;
    private String message;

    public OncRpcException() {
        this(16);
    }

    public OncRpcException(String s) {
        this.reason = 16;
        this.message = s;
    }

    public OncRpcException(int r, String s) {
        this.reason = r;
        this.message = s;
    }

    public OncRpcException(int r) {
        this.reason = r;
        switch (r) {
            case 1: {
                this.message = "can not encode RPC arguments";
                break;
            }
            case 2: {
                this.message = "can not decode RPC result";
                break;
            }
            case 4: {
                this.message = "can not receive ONC/RPC data";
                break;
            }
            case 3: {
                this.message = "can not send ONC/RPC data";
                break;
            }
            case 5: {
                this.message = "ONC/RPC call timed out";
                break;
            }
            case 6: {
                this.message = "ONC/RPC version mismatch";
                break;
            }
            case 7: {
                this.message = "ONC/RPC authentification error";
                break;
            }
            case 8: {
                this.message = "ONC/RPC program not available";
                break;
            }
            case 11: {
                this.message = "can not decode ONC/RPC arguments";
                break;
            }
            case 9: {
                this.message = "ONC/RPC program version mismatch";
                break;
            }
            case 10: {
                this.message = "ONC/RPC procedure not available";
                break;
            }
            case 12: {
                this.message = "ONC/RPC system error";
                break;
            }
            case 17: {
                this.message = "unknown protocol";
                break;
            }
            case 14: {
                this.message = "ONC/RPC portmap failure";
                break;
            }
            case 15: {
                this.message = "ONC/RPC program not registered";
                break;
            }
            case 16: {
                this.message = "ONC/RPC generic failure";
                break;
            }
            case 42: {
                this.message = "ONC/RPC buffer overflow";
                break;
            }
            case 43: {
                this.message = "ONC/RPC buffer underflow";
                break;
            }
            case 44: {
                this.message = "wrong ONC/RPC message type received";
                break;
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public int getReason() {
        return this.reason;
    }

    static {
        RPC_SUCCESS = 0;
        RPC_CANTENCODEARGS = 1;
        RPC_CANTDECODERES = 2;
        RPC_CANTSEND = 3;
        RPC_CANTRECV = 4;
        RPC_TIMEDOUT = 5;
        RPC_VERSMISMATCH = 6;
        RPC_AUTHERROR = 7;
        RPC_PROGUNAVAIL = 8;
        RPC_PROGVERSMISMATCH = 9;
        RPC_PROCUNAVAIL = 10;
        RPC_CANTDECODEARGS = 11;
        RPC_SYSTEMERROR = 12;
        RPC_UNKNOWNPROTO = 17;
        RPC_PMAPFAILURE = 14;
        RPC_PROGNOTREGISTERED = 15;
        RPC_FAILED = 16;
        RPC_BUFFEROVERFLOW = 42;
        RPC_BUFFERUNDERFLOW = 43;
        RPC_WRONGMESSAGE = 44;
    }
}

