/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object(null){
        private /* synthetic */ WeakHashMap this$0;
        {
            this.this$0 = this$0;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o == null || this == o;
        }
    };
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.theEntrySet = new WeakEntrySet(this);
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[initialCapacity];
    }

    public WeakHashMap(Map m) {
        this(m.size(), 0.75f);
        this.putAll(m);
    }

    private int hash(Object key) {
        return Math.abs(key.hashCode() % this.buckets.length);
    }

    void cleanQueue() {
        Reference bucket = this.queue.poll();
        while (bucket != null) {
            this.internalRemove((WeakBucket)bucket);
            bucket = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] oldBuckets = this.buckets;
        int newsize = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newsize * this.loadFactor);
        this.buckets = new WeakBucket[newsize];
        for (int i = 0; i < oldBuckets.length; ++i) {
            WeakBucket bucket = oldBuckets[i];
            while (bucket != null) {
                WeakBucket nextBucket = bucket.next;
                Object key = bucket.get();
                if (key == null) {
                    bucket.slot = -1;
                    --this.size;
                } else {
                    int slot;
                    bucket.slot = slot = this.hash(key);
                    bucket.next = this.buckets[slot];
                    this.buckets[slot] = bucket;
                }
                bucket = nextBucket;
            }
        }
    }

    private WeakBucket.WeakEntry internalGet(Object key) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = this.buckets[slot];
        while (bucket != null) {
            WeakBucket.WeakEntry entry = bucket.getEntry();
            if (entry != null && key.equals(entry.key)) {
                return entry;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private void internalAdd(Object key, Object value) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = new WeakBucket(key, this.queue, value, slot);
        bucket.next = this.buckets[slot];
        this.buckets[slot] = bucket;
        ++this.size;
    }

    void internalRemove(WeakBucket bucket) {
        int slot = bucket.slot;
        if (slot == -1) {
            return;
        }
        bucket.slot = -1;
        if (this.buckets[slot] == bucket) {
            this.buckets[slot] = bucket.next;
        } else {
            WeakBucket prev = this.buckets[slot];
            while (prev.next != bucket) {
                prev = prev.next;
            }
            prev.next = bucket.next;
        }
        --this.size;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        this.cleanQueue();
        return this.internalGet(key) != null;
    }

    public Object get(Object key) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object key, Object value) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry != null) {
            return entry.setValue(value);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(key, value);
        return null;
    }

    public Object remove(Object key) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(entry.getBucket());
        return entry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    public void clear() {
        super.clear();
    }

    public boolean containsValue(Object value) {
        this.cleanQueue();
        return super.containsValue(value);
    }

    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    public void putAll(Map m) {
        super.putAll(m);
    }

    public Collection values() {
        this.cleanQueue();
        return super.values();
    }

    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object key, ReferenceQueue queue, Object value, int slot) {
            super(key, queue);
            this.value = value;
            this.slot = slot;
        }

        WeakEntry getEntry() {
            Object key = this.get();
            if (key == null) {
                return null;
            }
            return new WeakEntry(this, key);
        }

        class WeakEntry
        implements Map.Entry {
            private /* synthetic */ WeakBucket this$1;
            Object key;

            public WeakEntry(WeakBucket this$1, Object key) {
                this.this$1 = this$1;
                this.key = key;
            }

            public WeakBucket getBucket() {
                return this.this$1;
            }

            public Object getKey() {
                if (this.key == NULL_KEY) {
                    return null;
                }
                return this.key;
            }

            public Object getValue() {
                return this.this$1.value;
            }

            public Object setValue(Object newVal) {
                Object oldVal = this.this$1.value;
                this.this$1.value = newVal;
                return oldVal;
            }

            public int hashCode() {
                return this.key.hashCode() ^ AbstractMap.hashCode(this.this$1.value);
            }

            public boolean equals(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return this.key.equals(e.getKey()) && AbstractMap.equals(this.this$1.value, e.getValue());
                }
                return false;
            }

            public String toString() {
                return this.key + "=" + this.this$1.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        private /* synthetic */ WeakHashMap this$0;

        static /* synthetic */ WeakHashMap access$1(WeakEntrySet inst$, WeakHashMap write_parm_value$) {
            inst$.this$0 = write_parm_value$;
            return inst$.this$0;
        }

        static WeakHashMap access$0(WeakEntrySet inst$) {
            return inst$.this$0;
        }

        WeakEntrySet(WeakHashMap this$0) {
            this.this$0 = this$0;
        }

        public int size() {
            return this.this$0.size;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private /* synthetic */ WeakEntrySet this$1;
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry;
                int knownMod;
                {
                    this.this$1 = this$1;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.nextEntry = this.findNext(null);
                    this.knownMod = WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount;
                }

                private void checkMod() {
                    this.this$1.this$0.cleanQueue();
                    if (this.knownMod != WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount) {
                        throw new ConcurrentModificationException();
                    }
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry lastEntry) {
                    int slot;
                    WeakBucket nextBucket;
                    if (lastEntry != null) {
                        nextBucket = lastEntry.getBucket().next;
                        slot = lastEntry.getBucket().slot;
                    } else {
                        nextBucket = WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets[0];
                        slot = 0;
                    }
                    while (true) {
                        if (nextBucket != null) {
                            WeakBucket.WeakEntry entry = nextBucket.getEntry();
                            if (entry != null) {
                                return entry;
                            }
                            nextBucket = nextBucket.next;
                            continue;
                        }
                        if (++slot == WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets.length) {
                            return null;
                        }
                        nextBucket = WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets[slot];
                    }
                }

                public boolean hasNext() {
                    this.checkMod();
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount;
                    this.this$1.this$0.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }
    }
}

