/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    Class propertyType;
    Method getMethod;
    Method setMethod;
    Class propertyEditorClass;
    boolean bound;
    boolean constrained;

    PropertyDescriptor(String name) {
        this.setName(name);
    }

    public PropertyDescriptor(String name, Class beanClass) throws IntrospectionException {
        this.setName(name);
        if (name.length() == 0) {
            throw new IntrospectionException("empty property name");
        }
        String caps = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.findMethods(beanClass, "is" + caps, "get" + caps, "set" + caps);
        if (this.getMethod == null) {
            throw new IntrospectionException("Cannot find an is" + caps + " or get" + caps + " method");
        }
        if (this.setMethod == null) {
            throw new IntrospectionException("Cannot find a " + caps + " method");
        }
        this.checkMethods();
    }

    public PropertyDescriptor(String name, Class beanClass, String getMethodName, String setMethodName) throws IntrospectionException {
        this.setName(name);
        this.findMethods(beanClass, getMethodName, null, setMethodName);
        if (this.getMethod == null && getMethodName != null) {
            throw new IntrospectionException("Cannot find a getter method called " + getMethodName);
        }
        if (this.setMethod == null && setMethodName != null) {
            throw new IntrospectionException("Cannot find a setter method called " + setMethodName);
        }
        this.checkMethods();
    }

    public PropertyDescriptor(String name, Method getMethod, Method setMethod) throws IntrospectionException {
        this.setName(name);
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        if (getMethod != null) {
            this.propertyType = getMethod.getReturnType();
        } else if (setMethod != null) {
            this.propertyType = setMethod.getParameterTypes()[0];
        }
        this.checkMethods();
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.getMethod;
    }

    public Method getWriteMethod() {
        return this.setMethod;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setPropertyEditorClass(Class propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    private void findMethods(Class beanClass, String getMethodName1, String getMethodName2, String setMethodName) throws IntrospectionException {
        block13: {
            try {
                if (getMethodName1 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName1, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (this.getMethod == null && getMethodName2 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName2, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (setMethodName == null) break block13;
                if (this.getMethod != null) {
                    Class propertyType = this.getMethod.getReturnType();
                    if (propertyType == Void.TYPE) {
                        String msg = "The property's read method has return type 'void'";
                        throw new IntrospectionException(msg);
                    }
                    Class[] setArgs = new Class[]{propertyType};
                    try {
                        this.setMethod = beanClass.getMethod(setMethodName, setArgs);
                    }
                    catch (NoSuchMethodException e) {}
                    break block13;
                }
                if (getMethodName1 != null || getMethodName2 != null) break block13;
                Method[] methods = beanClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(setMethodName) || methods[i].getParameterTypes().length != 1 || methods[i].getReturnType() != Void.TYPE) continue;
                    this.setMethod = methods[i];
                    break;
                }
            }
            catch (SecurityException e) {
                String msg = "SecurityException thrown on attempt to access methods.";
                throw new IntrospectionException(msg);
            }
        }
    }

    private void checkMethods() throws IntrospectionException {
        if (this.getMethod != null) {
            if (this.getMethod.getParameterTypes().length > 0) {
                throw new IntrospectionException("get method has parameters");
            }
            this.propertyType = this.getMethod.getReturnType();
            if (this.propertyType == Void.TYPE) {
                throw new IntrospectionException("get method has void return type");
            }
        }
        if (this.setMethod != null) {
            if (this.setMethod.getParameterTypes().length != 1) {
                String msg = "set method does not have exactly one parameter";
                throw new IntrospectionException(msg);
            }
            if (this.getMethod == null) {
                this.propertyType = this.setMethod.getParameterTypes()[0];
            } else {
                if (!this.propertyType.equals(this.setMethod.getParameterTypes()[0])) {
                    String msg = "set and get methods do not share the same type";
                    throw new IntrospectionException(msg);
                }
                if (!this.getMethod.getDeclaringClass().isAssignableFrom(this.setMethod.getDeclaringClass()) && !this.setMethod.getDeclaringClass().isAssignableFrom(this.getMethod.getDeclaringClass())) {
                    String msg = "set and get methods are not in the same class.";
                    throw new IntrospectionException(msg);
                }
            }
        }
    }
}

