/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import gnu.java.awt.Buffers;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ComponentDataBlitOp
implements RasterOp {
    public static ComponentDataBlitOp INSTANCE = new ComponentDataBlitOp();

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        }
        DataBuffer srcDB = src.getDataBuffer();
        DataBuffer destDB = dest.getDataBuffer();
        ComponentSampleModel srcSM = (ComponentSampleModel)src.getSampleModel();
        ComponentSampleModel destSM = (ComponentSampleModel)dest.getSampleModel();
        int srcScanlineStride = srcSM.getScanlineStride();
        int destScanlineStride = destSM.getScanlineStride();
        int srcX = src.getMinX() - src.getSampleModelTranslateX();
        int srcY = src.getMinY() - src.getSampleModelTranslateY();
        int destX = dest.getMinX() - dest.getSampleModelTranslateX();
        int destY = dest.getMinY() - dest.getSampleModelTranslateY();
        int numBands = srcSM.getNumBands();
        int srcOffset = numBands * srcX + srcScanlineStride * srcY + srcDB.getOffset();
        int destOffset = numBands * destX + destScanlineStride * destY + destDB.getOffset();
        int rowSize = src.getWidth() * numBands;
        int h = src.getHeight();
        if (rowSize == srcScanlineStride && rowSize == destScanlineStride) {
            rowSize *= h;
            h = 1;
        }
        Object srcArray = Buffers.getData(srcDB);
        Object destArray = Buffers.getData(destDB);
        for (int yd = 0; yd < h; ++yd) {
            System.arraycopy(srcArray, srcOffset, destArray, destOffset, rowSize);
            srcOffset += srcScanlineStride;
            destOffset += destScanlineStride;
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPoint, Point2D destPoint) {
        if (destPoint == null) {
            return (Point2D)srcPoint.clone();
        }
        destPoint.setLocation(srcPoint);
        return destPoint;
    }

    public RenderingHints getRenderingHints() {
        throw new UnsupportedOperationException("not implemented");
    }
}

