.TH sane-gphoto2 5 "04 September 2001" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-gphoto2
.SH NAME
sane-gphoto2 \- SANE backend for gphoto2 supported cameras
.SH DESCRIPTION
The
.B sane-gphoto2
library implements a SANE (Scanner Access Now Easy) backend that
provides access to the digital cameras supported by gphoto2. 
This backend has only been tested with a handful of cameras so far.  Patches
to support other models are welcome.
.PP
Because of the limited testing of this backend, it is commented out
in @CONFIGDIR@/dll.conf by default.  Either the comment
character must be removed or the backend must be called explicitly.
E.g. `scanimage -d gphoto2' or `xscanimage gphoto2'.
.SH "DEVICE NAMES"
The current version of the backend only allows one camera to be
connected.  The device name is always "0".
.SH CONFIGURATION
The contents of the
.I gphoto2.conf
specify the characteristics of the camera to be used.   Resolutions
(high resolution, low resolution, and thumbnail size) are
required since they are needed by the sane frontends, but can't be obtained
through the gphoto2 interface.  Valid ports and cameras can be obtained
by "gphoto2 --list-cameras" and "gphoto2 --list-ports".
.PP
The dumpinquiry line causes some information about the camera to 
be printed.
.PP
Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
The "topfolder" line specifies the "fixed" part of the file path.  For 
example, on the Kodak DC-240, files are stored in the directory 
/DCIM/100DC240.  The /DCIM portion is constant, but 100DC240 will
change and must be read from the camers.  In this case, the 
line would read "topfolder=/DCIM"
.PP
Some cameras don't implement a file structure and store all pictures
in the "/" directory.  This is indicated by setting "subdirs=0" with
"topfolder=/"
.PP
.RS
port=usb:
.br
camera=Kodak DC240
.br
# this is a comment
.br
high_resolution=1280x960
.br
low_resolution=640x480
.br
thumb_resolution=160x120
.br
dumpinquiry
.RE
.PP
.SH FILES
.TP
.I @CONFIGDIR@/gphoto2.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-gphoto2.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-gphoto2.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_GPHOTO2
If the library was compiled with debugging support enabled, this
environment variable controls the debug level for this backend. 
A value of 128 requests maximally copious debug output; smaller
levels reduce verbosity.
.TP 
.B GP_DEBUG
Set to 1, 2, or 3, to enable various levels of debugging within the 
gphoto2 libraries.

.SH "SEE ALSO"
sane(7)

.SH AUTHOR
Peter S. Fales

.PP
The manpage was largeley copied from the dc210 manpage.

.SH BUGS
Many, no doubt.
.PP
More general comments, suggestions, and inquiries about frontends
or SANE should go to the SANE Developers mailing list 
(see http://www.sane\-project.org/mailing\-lists.html for details). 
You must be subscribed to the list, otherwise your mail won't be
sent to the subscribers.

