/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <string.h>

#include <glib.h>

#include <pan/base/debug.h>
#include <pan/base/pan-glib-extensions.h>

#include <pan/task.h>

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

/*****
******
*****/

void
task_constructor (Task                    * task,
                  PanObjectDestructor       destructor,
                  StatusItemDescribeFunc    describe,
                  Server                  * server,
                  gboolean                  high_priority)
{
	g_return_if_fail (task != NULL);

	/* construct parent's bits */
	status_item_constructor (STATUS_ITEM(task), destructor, describe);

	/* construct task's bits */
	pan_warn_if_fail (server != NULL);
	task->server = server;
	task->hint_abort = FALSE;
	task->high_priority = high_priority;
	task->gets_bodies = FALSE;
	task->task_ran_callback = pan_callback_new ();
	task->identifiers = g_ptr_array_new ();
	task->thread_qty = 0;
	task->sockets = NULL;
	task_state_set_health (&task->state, TASK_OK);
	task_state_set_work_completed (&task->state);

        debug1 (DEBUG_PAN_OBJECT, "task constructor: %p", task);
}

void
task_destructor (PanObject* obj)
{
	Task * task;

	/* sanity clause */
	g_return_if_fail (obj != NULL);

	/* clean up task bits */
        debug1 (DEBUG_PAN_OBJECT, "task destructor: %p", obj);
	task = TASK(obj);
	pan_callback_free (task->task_ran_callback);
	pan_g_ptr_array_foreach (task->identifiers, (GFunc)g_object_unref, NULL);
	g_ptr_array_free (task->identifiers, TRUE);
	if (task->sockets != NULL) {
		g_warning ("task->sockets != NULL");
		g_slist_free (task->sockets);
		task->sockets = NULL;
	}

	/* clean up parent's bits */
	status_item_destructor (obj);
}

/*****
******
*****/

void
task_add_identifiers (Task                * task,
                      MessageIdentifier  ** identifiers,
                      int                   identifier_qty)
{
	guint i;

	/* sanity clause */
	g_return_if_fail (task!=NULL);
	g_return_if_fail (identifiers!=NULL);
	g_return_if_fail (identifier_qty>0);
	for (i=0; i<identifier_qty; ++i)
		g_return_if_fail (PAN_IS_MESSAGE_IDENTIFIER(identifiers[i]));

	/* add the message-ids */	
	for (i=0; i<identifier_qty; ++i) {
		g_object_ref (identifiers[i]);
		g_ptr_array_add (task->identifiers, identifiers[i]);
	}
}

GPtrArray*
task_get_identifiers (Task * task)
{
	GPtrArray * retval = g_ptr_array_new ();

	/* sanity clause */
	g_return_val_if_fail (task!=NULL, retval);

	/* get the message-ids */
	pan_g_ptr_array_assign (retval, task->identifiers->pdata, task->identifiers->len);
	return retval;
}
