/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Character
implements Serializable,
Comparable {
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('C');
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte SURROGATE = 19;
    public static final byte PRIVATE_USE = 18;
    public static final byte UNASSIGNED = 0;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    private static final int TYPE_MASK = 31;
    private static final int NO_BREAK_MASK = 32;
    private static final int MIRROR_MASK = 64;

    private static native char readChar(char var0);

    public Character(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Character && this.value == ((Character)o).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(char ch) {
        return String.valueOf(ch);
    }

    public static boolean isLowerCase(char ch) {
        return Character.getType(ch) == 2;
    }

    public static boolean isUpperCase(char ch) {
        return Character.getType(ch) == 1;
    }

    public static boolean isTitleCase(char ch) {
        return Character.getType(ch) == 3;
    }

    public static boolean isDigit(char ch) {
        return Character.getType(ch) == 9;
    }

    public static boolean isDefined(char ch) {
        return Character.getType(ch) != 0;
    }

    public static boolean isLetter(char ch) {
        return (62 >> (Character.getType(ch) & 0x1F) & 1) != 0;
    }

    public static boolean isLetterOrDigit(char ch) {
        return (574 >> (Character.getType(ch) & 0x1F) & 1) != 0;
    }

    public static boolean isJavaLetter(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isJavaLetterOrDigit(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static boolean isJavaIdentifierStart(char ch) {
        return (75498558 >> (Character.getType(ch) & 0x1F) & 1) != 0;
    }

    public static boolean isJavaIdentifierPart(char ch) {
        int category = Character.getType(ch);
        return (75564926 >> (category & 0x1F) & 1) != 0 || category == 15 && Character.isIdentifierIgnorable(ch);
    }

    public static boolean isUnicodeIdentifierStart(char ch) {
        return (1086 >> (Character.getType(ch) & 0x1F) & 1) != 0;
    }

    public static boolean isUnicodeIdentifierPart(char ch) {
        int category = Character.getType(ch);
        return (8456062 >> (category & 0x1F) & 1) != 0 || category == 15 && Character.isIdentifierIgnorable(ch);
    }

    public static boolean isIdentifierIgnorable(char ch) {
        return ch <= '\u009f' && (ch <= '\b' || ch > '~' || ch <= '\u001b' && ch > '\r') || Character.getType(ch) == 16;
    }

    public static native char toLowerCase(char var0);

    public static native char toUpperCase(char var0);

    public static native char toTitleCase(char var0);

    public static native int digit(char var0, int var1);

    public static native int getNumericValue(char var0);

    public static boolean isSpace(char ch) {
        char c = ch;
        ch = (char)(c - '\u0001');
        return c <= ' ' && (-2147476736 >> (ch & 0x1F) & 1) != 0;
    }

    public static boolean isSpaceChar(char ch) {
        return (28672 >> (Character.getType(ch) & 0x1F) & 1) != 0;
    }

    public static boolean isWhitespace(char ch) {
        char attr = Character.readChar(ch);
        return (28672 >> (attr & 0x1F) & 1) != 0 && ((attr >> 5 ^ 1) & 1) != 0 || ch <= '\u001f' && (-268419584 >> (ch & 0x1F) & 1) != 0;
    }

    public static boolean isISOControl(char ch) {
        return Character.getType(ch) == 15;
    }

    public static native int getType(char var0);

    public static char forDigit(int digit, int radix) {
        if (radix < 2 || radix > 36 || digit < 0 || digit >= radix) {
            return '\u0000';
        }
        if (digit < 10) {
            return (char)(48 + digit);
        }
        return (char)(87 + digit);
    }

    public static native byte getDirectionality(char var0);

    public static boolean isMirrored(char ch) {
        return (Character.readChar(ch) >> 6 & 1) != 0;
    }

    public int compareTo(Character anotherCharacter) {
        return this.value - anotherCharacter.value;
    }

    public int compareTo(Object o) {
        return this.compareTo((Character)o);
    }

    public static final class UnicodeBlock
    extends Subset {
        private final char start;
        private final char end;
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock('\u0000', '\u007f', "BASIC_LATIN");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock('\u0080', '\u00ff', "LATIN_1_SUPPLEMENT");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock('\u0100', '\u017f', "LATIN_EXTENDED_A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock('\u0180', '\u024f', "LATIN_EXTENDED_B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock('\u0250', '\u02af', "IPA_EXTENSIONS");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock('\u02b0', '\u02ff', "SPACING_MODIFIER_LETTERS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock('\u0300', '\u036f', "COMBINING_DIACRITICAL_MARKS");
        public static final UnicodeBlock GREEK = new UnicodeBlock('\u0370', '\u03ff', "GREEK");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock('\u0400', '\u04ff', "CYRILLIC");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock('\u0530', '\u058f', "ARMENIAN");
        public static final UnicodeBlock HEBREW = new UnicodeBlock('\u0590', '\u05ff', "HEBREW");
        public static final UnicodeBlock ARABIC = new UnicodeBlock('\u0600', '\u06ff', "ARABIC");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock('\u0700', '\u074f', "SYRIAC");
        public static final UnicodeBlock THAANA = new UnicodeBlock('\u0780', '\u07bf', "THAANA");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock('\u0900', '\u097f', "DEVANAGARI");
        public static final UnicodeBlock BENGALI = new UnicodeBlock('\u0980', '\u09ff', "BENGALI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock('\u0a00', '\u0a7f', "GURMUKHI");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock('\u0a80', '\u0aff', "GUJARATI");
        public static final UnicodeBlock ORIYA = new UnicodeBlock('\u0b00', '\u0b7f', "ORIYA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock('\u0b80', '\u0bff', "TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock('\u0c00', '\u0c7f', "TELUGU");
        public static final UnicodeBlock KANNADA = new UnicodeBlock('\u0c80', '\u0cff', "KANNADA");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock('\u0d00', '\u0d7f', "MALAYALAM");
        public static final UnicodeBlock SINHALA = new UnicodeBlock('\u0d80', '\u0dff', "SINHALA");
        public static final UnicodeBlock THAI = new UnicodeBlock('\u0e00', '\u0e7f', "THAI");
        public static final UnicodeBlock LAO = new UnicodeBlock('\u0e80', '\u0eff', "LAO");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock('\u0f00', '\u0fff', "TIBETAN");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock('\u1000', '\u109f', "MYANMAR");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock('\u10a0', '\u10ff', "GEORGIAN");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock('\u1100', '\u11ff', "HANGUL_JAMO");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock('\u1200', '\u137f', "ETHIOPIC");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock('\u13a0', '\u13ff', "CHEROKEE");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock('\u1400', '\u167f', "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS");
        public static final UnicodeBlock OGHAM = new UnicodeBlock('\u1680', '\u169f', "OGHAM");
        public static final UnicodeBlock RUNIC = new UnicodeBlock('\u16a0', '\u16ff', "RUNIC");
        public static final UnicodeBlock KHMER = new UnicodeBlock('\u1780', '\u17ff', "KHMER");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock('\u1800', '\u18af', "MONGOLIAN");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock('\u1e00', '\u1eff', "LATIN_EXTENDED_ADDITIONAL");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock('\u1f00', '\u1fff', "GREEK_EXTENDED");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock('\u2000', '\u206f', "GENERAL_PUNCTUATION");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock('\u2070', '\u209f', "SUPERSCRIPTS_AND_SUBSCRIPTS");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock('\u20a0', '\u20cf', "CURRENCY_SYMBOLS");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock('\u20d0', '\u20ff', "COMBINING_MARKS_FOR_SYMBOLS");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock('\u2100', '\u214f', "LETTERLIKE_SYMBOLS");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock('\u2150', '\u218f', "NUMBER_FORMS");
        public static final UnicodeBlock ARROWS = new UnicodeBlock('\u2190', '\u21ff', "ARROWS");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock('\u2200', '\u22ff', "MATHEMATICAL_OPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock('\u2300', '\u23ff', "MISCELLANEOUS_TECHNICAL");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock('\u2400', '\u243f', "CONTROL_PICTURES");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock('\u2440', '\u245f', "OPTICAL_CHARACTER_RECOGNITION");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock('\u2460', '\u24ff', "ENCLOSED_ALPHANUMERICS");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock('\u2500', '\u257f', "BOX_DRAWING");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock('\u2580', '\u259f', "BLOCK_ELEMENTS");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock('\u25a0', '\u25ff', "GEOMETRIC_SHAPES");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock('\u2600', '\u26ff', "MISCELLANEOUS_SYMBOLS");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock('\u2700', '\u27bf', "DINGBATS");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock('\u2800', '\u28ff', "BRAILLE_PATTERNS");
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock('\u2e80', '\u2eff', "CJK_RADICALS_SUPPLEMENT");
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock('\u2f00', '\u2fdf', "KANGXI_RADICALS");
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock('\u2ff0', '\u2fff', "IDEOGRAPHIC_DESCRIPTION_CHARACTERS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock('\u3000', '\u303f', "CJK_SYMBOLS_AND_PUNCTUATION");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock('\u3040', '\u309f', "HIRAGANA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock('\u30a0', '\u30ff', "KATAKANA");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock('\u3100', '\u312f', "BOPOMOFO");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock('\u3130', '\u318f', "HANGUL_COMPATIBILITY_JAMO");
        public static final UnicodeBlock KANBUN = new UnicodeBlock('\u3190', '\u319f', "KANBUN");
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock('\u31a0', '\u31bf', "BOPOMOFO_EXTENDED");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock('\u3200', '\u32ff', "ENCLOSED_CJK_LETTERS_AND_MONTHS");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock('\u3300', '\u33ff', "CJK_COMPATIBILITY");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock('\u3400', '\u4db5', "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock('\u4e00', '\u9fff', "CJK_UNIFIED_IDEOGRAPHS");
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock('\ua000', '\ua48f', "YI_SYLLABLES");
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock('\ua490', '\ua4cf', "YI_RADICALS");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock('\uac00', '\ud7a3', "HANGUL_SYLLABLES");
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock('\ud800', '\udfff', "SURROGATES_AREA");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock('\ue000', '\uf8ff', "PRIVATE_USE_AREA");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock('\uf900', '\ufaff', "CJK_COMPATIBILITY_IDEOGRAPHS");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock('\ufb00', '\ufb4f', "ALPHABETIC_PRESENTATION_FORMS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock('\ufb50', '\ufdff', "ARABIC_PRESENTATION_FORMS_A");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock('\ufe20', '\ufe2f', "COMBINING_HALF_MARKS");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock('\ufe30', '\ufe4f', "CJK_COMPATIBILITY_FORMS");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock('\ufe50', '\ufe6f', "SMALL_FORM_VARIANTS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock('\ufe70', '\ufefe', "ARABIC_PRESENTATION_FORMS_B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock('\uff00', '\uffef', "HALFWIDTH_AND_FULLWIDTH_FORMS");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock('\ufff0', '\ufffd', "SPECIALS");
        private static final UnicodeBlock[] sets = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, ARMENIAN, HEBREW, ARABIC, SYRIAC, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, KHMER, MONGOLIAN, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, BRAILLE_PATTERNS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, SURROGATES_AREA, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS};

        private UnicodeBlock(char start, char end, String name) {
            super(name);
            this.start = start;
            this.end = end;
        }

        public static UnicodeBlock of(char ch) {
            if (ch == '\ufeff') {
                return SPECIALS;
            }
            int low = 0;
            int hi = sets.length - 1;
            while (low <= hi) {
                int mid = low + hi >> 1;
                UnicodeBlock b = sets[mid];
                if (ch < b.start) {
                    hi = mid - 1;
                    continue;
                }
                if (ch > b.end) {
                    low = mid + 1;
                    continue;
                }
                return b;
            }
            return null;
        }
    }

    public static class Subset {
        private final String name;

        protected Subset(String name) {
            this.name = name.toString();
        }

        public final boolean equals(Object o) {
            return o == this;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

