/* treeview stuff */
void set_relative_tree_id(gint i);


gint 
set_relative_tree_id_from_model(	GtkTreeModel *treemodel);

gint 
get_relative_sort_column(	void);

gint 
get_ascending(			void);

GtkTreeIter *
get_iter_from_reference(	GtkTreeModel * treemodel, 
				GtkTreeRowReference *reference);

gboolean 
get_selectpath_iter(		GtkTreeIter * iter, 
				tree_entry_t ** en);

void 
on_treeview_column_click(	GtkTreeViewColumn * column, 
				gpointer data);

gboolean 
local_branch_is_visible(	GtkTreeModel *treemodel);

treestuff_t *
get_only_visible_treestuff(	void);
 
GtkTreeView *
get_bigger_treeview(		void);

gint 
get_active_tree_id(		void);

gint 
get_relative_tree_id(		void);

gint 
get_tree_id(			GtkTreeView *treeview);

treestuff_t *
get_treestuff(			GtkTreeView *treeview);

int 
get_the_root(			GtkTreeView * treeview, 
				GtkTreeIter * iter, 
				tree_entry_t ** en, 
				int which);

int 
erase_the_root(			GtkTreeView * treeview, 
				int which);

gboolean 
find_root(			GtkTreeView * treeview, 
				int which);

#define get_local_root(x,y,z) get_the_root(x,y,z,ROOT_FILES)
#define erase_local_root(x) erase_the_root(x,ROOT_FILES)

#define get_recent_root(x,y,z) get_the_root(x,y,z,ROOT_RECENT)
#define erase_recent_root(x) erase_the_root(x,ROOT_RECENT)

#define get_frequent_root(x,y,z) get_the_root(x,y,z,ROOT_FREQUENT)
#define erase_frequent_root(x) erase_the_root(x,ROOT_FREQUENT)

#define get_find_root(x,y,z) get_the_root(x,y,z,ROOT_FIND)
#define erase_find_root(x) erase_the_root(x,ROOT_FIND)

#define get_bookmark_root(x,y,z) get_the_root(x,y,z,ROOT_BOOKMARKS)
#define erase_bookmark_root(x) erase_the_root(x,ROOT_BOOKMARKS)

#define get_trash_root(x,y,z) get_the_root(x,y,z,ROOT_TRASH)
#define erase_trash_root(x) erase_the_root(x,ROOT_TRASH)

#ifdef USE_SMB_BRANCH
#define get_network_root(x,y,z) get_the_root(x,y,z,ROOT_NETWORK)
#define erase_network_root(x) erase_the_root(x,ROOT_NETWORK)
#endif

#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
#define get_fstab_root(x,y,z) get_the_root(x,y,z,ROOT_FSTAB)
#define erase_fstab_root(x) erase_the_root(x,ROOT_FSTAB)
#endif


const gchar *
xffm_filename(			gchar *path);

/* messaging stuff */
const gchar *
time_to_string (		time_t when) ;

const gchar *
sizetag(			off_t tama, 
				gint count);

#define set_progress(x,y) set_progress_generic(x,y,1)
#define set_progress_bytes(x,y) set_progress_generic(x,y,0)
void 
set_progress_generic(		int count, 
				int total, 
				int caso);

void 
set_entry_tag(			tree_entry_t * en, 
				off_t tama);

void 
cursor_wait(			void);

void 
cursor_reset(			void);

void 
print_status(			const gchar *id, 
				...);

void 
print_status_tmp(		GdkPixbuf * icono, 
				...);

void 
print_diagnostics(		const gchar *id, 
				...);

void 
print_diagnostics_tmp(		GdkPixbuf * icono, 
				...);

void 
clear_diagnostics(		void);

void 
set_font(			GtkTreeModel *treemodel,  
				GtkTreeIter * iterator);

/* hide/show stuff */

void 
hideit(				GtkWidget * parent, 
				const gchar * widget_name);

void 
showit(				GtkWidget * parent, 
				const gchar * widget_name);

void 
hide_text(			GtkWidget * parent);

void 
show_text(			GtkWidget * parent);

void 
show_stop(			void);

void 
hide_stop(			void);

/* miscelaneous stuff */
char *
our_host_name(GtkTreeView * treeview);

void 
set_title(GtkTreeView * treeview, gchar **path);

gchar ** 
text_type_OK(			const gchar *path);

gint 
count_files(			gchar *path);

const gchar *
abbreviate_end(			gchar *string,
				int length);

const gchar *
abreviate(			gchar *path);

void 
set_processing_pending(		void);

void 
unset_processing_pending(	void);

gboolean 
processing_pending(		void);

const char *
tod(void);

void 
count_selection(		GtkTreeModel * treemodel, 
				GtkTreePath * treepath, 
				GtkTreeIter * iter, 
				gpointer data);

const gchar *
utf_2_local_string(		const gchar *t);

void 
process_pending_gtk(		void);

const gchar *
get_xffm_home(			void); 

void 
disable_diagnostics(		void);

void 
enable_diagnostics(		void);

gboolean 
is_number(			char *c);

void 
fork_function(			void *data);

const gchar *
my_utf_string(			const gchar *t);

void 
cleanup_tmpfiles(		void);

gchar *
randomTmpName(char *ext);

void ascii_readable (char *the_char);
void ascii_unreadable (char *the_char);
