/* Copyright (C) 2002 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	 Boston, MA 02111-1307, USA.
	 */

#ifndef XVIMWIN_H
#define XVIMWIN_H
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <klineedit.h>
#include <qvbuttongroup.h>
#include <qradiobutton.h>
#include "xvim.h"

class XVim_Win : public QWidget {
	Q_OBJECT
public:
	XVim_Win(QWidget *w=NULL);
	~XVim_Win();

protected slots:
	void execute(const QString&);

protected:
	QVBoxLayout *vbl;
	QVButtonGroup *gb;
	QRadioButton *eval;
	QRadioButton *keys;
	KLineEdit *server; //servername
	KLineEdit *command; //command line
	QLabel *result; //expressions result
	XVim *xvim; //kernel
};

#endif //XVIMWIN_H
