/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <stdio.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks_mainwindow_menu.h"
#include "callbacks_mainwindow_toolbar.h"
#include "callbacks_mainwindow.h"
#include "callbacks_mainwindow_qsoframe.h"
#include "gui_mainwindow.h"
#include "gui_aboutdialog.h"
#include "gui_b4dialog.h"
#include "gui_closedialog.h"
#include "gui_defaultsdialog.h"
#include "gui_dialogsdialog.h"
#include "gui_dupecheckdialog.h"
#include "gui_openlogdialog.h"
#include "gui_helpdialog.h"
#include "gui_logeditordialog.h"
#include "gui_newlogdialog.h"
#include "gui_printdialog.h"
#include "gui_preferencesdialog.h"
#include "gui_saveasdialog.h"
#include "gui_searchdialog.h"
#if WANT_HAMLIB
#	include "gui_tracedialog.h"
#endif
#include "support.h"

GtkWidget *mainwindow, *mainnotebook;

GtkWidget*
create_mainwindow (void)
{
	GtkWidget *mainwindow;
	GdkPixbuf *mainwindow_icon_pixbuf;
	GtkWidget *mainvbox;
	GtkWidget *menubar;
	GtkWidget *log;
	GtkWidget *log_menu;
	GtkWidget *new;
	GtkWidget *image703;
	GtkWidget *open;
	GtkWidget *image704;
	GtkWidget *scheidslijn1;
	GtkWidget *save;
	GtkWidget *image705;
	GtkWidget *saveas;
	GtkWidget *image706;
	GtkWidget *close;
	GtkWidget *image707;
	GtkWidget *scheidslijn2;
	GtkWidget *print;
	GtkWidget *image708;
	GtkWidget *exit;
	GtkWidget *image709;
	GtkWidget *edit;
	GtkWidget *edit_menu;
	GtkWidget *clearframe;
	GtkWidget *image710;
	GtkWidget *search;
	GtkWidget *image711;
	GtkWidget *clickall;
	GtkWidget *image712;
	GtkWidget *tools;
	GtkWidget *tools_menu;
	GtkWidget *log_editor;
	GtkWidget *image713;
	GtkWidget *dupecheck;
	GtkWidget *trace_hamlib;
	GtkWidget *image791;
	GtkWidget *sort_log;
	GtkWidget *image733;
	GtkWidget *image714;
	GtkWidget *separator2;
	GtkWidget *view_toolbar;
	GtkWidget *worked;
	GtkWidget *settings;
	GtkWidget *settings_menu;
	GtkWidget *defaults;
	GtkWidget *image715;
	GtkWidget *dialogs;
	GtkWidget *image716;
	GtkWidget *separator1;
	GtkWidget *preferences;
	GtkWidget *image717;
	GtkWidget *help;
	GtkWidget *help_menu;
	GtkWidget *documentation1;
	GtkWidget *image718;
	GtkWidget *documentation1_menu;
	GtkWidget *helpfaq;
	GtkWidget *helpmanual;
	GtkWidget *image719;
	GtkWidget *helpreadme;
	GtkWidget *image720;
	GtkWidget *helpthanks;
	GtkWidget *helptodo;
	GtkWidget *scheidingslijn1;
	GtkWidget *about;
	GtkWidget *image721;
	GtkWidget *hpaned;
	GtkWidget *qsomainvbox;
	GtkWidget *handlebox;
	GtkWidget *hbox165;
	GtkWidget *abutton;
	GtkWidget *vbox55;
	GtkWidget *image395;
	GtkWidget *label209;
	GtkWidget *ubutton;
	GtkWidget *vbox56;
	GtkWidget *image396;
	GtkWidget *label210;
	GtkWidget *dbutton;
	GtkWidget *vbox57;
	GtkWidget *image397;
	GtkWidget *label211;
	GtkWidget *qsoscrolledwindow;
	GtkWidget *qsoviewport;
	GtkWidget *qsoframesvbox;
	GtkWidget *qsoframe;
	GtkWidget *qsofieldsvbox;
	GtkWidget *datehbox;
	GtkWidget *datebutton;
	GtkWidget *dateentry;
	GtkWidget *gmthbox;
	GtkWidget *gmtbutton;
	GtkWidget *gmtentry;
	GtkWidget *endhbox;
	GtkWidget *endbutton;
	GtkWidget *endentry;
	GtkWidget *callhbox;
	GtkWidget *calllabel;
	GtkWidget *callentry;
	GtkWidget *bandhbox;
	GtkWidget *mhzhbox;
	GtkWidget *mhzbutton;
	GtkWidget *mhzlabel;
	GtkWidget *bandhbox2;
	GtkWidget *bandoptionmenu;
	GtkWidget *convertwidget3;
	GtkWidget *bandentry;
	GtkWidget *modehbox;
	GtkWidget *modehbox1;
	GtkWidget *modebutton;
	GtkWidget *modelabel;
	GtkWidget *modehbox2;
	GtkWidget *modeoptionmenu;
	GtkWidget *convertwidget4;
	GtkWidget *modeentry;
	GtkWidget *hrsthbox;
	GtkWidget *hbox39;
	GtkWidget *rstbutton;
	GtkWidget *rstlabel;
	GtkWidget *rstentry;
	GtkWidget *mrsthbox;
	GtkWidget *myrstlabel;
	GtkWidget *myrstentry;
	GtkWidget *qslhbox;
	GtkWidget *outcheckbutton;
	GtkWidget *incheckbutton;
	GtkWidget *powerhbox;
	GtkWidget *hbox74;
	GtkWidget *powerbutton;
	GtkWidget *powerlabel;
	GtkWidget *powerentry;
	GtkWidget *namehbox;
	GtkWidget *namelabel;
	GtkWidget *nameentry;
	GtkWidget *qthhbox;
	GtkWidget *qthlabel;
	GtkWidget *qthentry;
	GtkWidget *locatorhbox;
	GtkWidget *locatorlabel;
	GtkWidget *locatorentry;
	GtkWidget *unknown1hbox;
	GtkWidget *unknownlabel1;
	GtkWidget *unknownentry1;
	GtkWidget *unknown2hbox;
	GtkWidget *unknownlabel2;
	GtkWidget *unknownentry2;
	GtkWidget *remarksvbox;
	GtkWidget *hbox149;
	GtkWidget *remarkslabel;
	GtkWidget *hbox150;
	GtkWidget *remarksentry;
	GtkWidget *label1;
	GtkWidget *dxccframe;
	GtkWidget *dxccvbox;
	GtkWidget *dxcclabel1;
	GtkWidget *dxcclabel2;
	GtkWidget *dxcclabel3;
	GtkWidget *dxcclabel4;
	GtkWidget *dxcclabel5;
	GtkWidget *label2;
	GtkWidget *locatorframe;
	GtkWidget *locatorvbox;
	GtkWidget *locatorlabel1;
	GtkWidget *label3;
	GtkWidget *statushbox;
	GtkWidget *statusbar;
	GtkWidget *frequencyhandlebox;
	GtkWidget *frequencyhbox;
	GtkWidget *frequencypixmap;
	GtkWidget *frequencylabel;
	GtkWidget *smeterhandlebox;
	GtkWidget *smeterhbox;
	GtkWidget *smeterpixmap;
	GtkWidget *smeterdrawingarea;
	GtkWidget *clockhandlebox;
	GtkWidget *clockhbox;
	GtkWidget *clockpixmap;
	GtkWidget *clocklabel;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	accel_group = gtk_accel_group_new ();

	mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_events (mainwindow, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK);
	gtk_window_set_title (GTK_WINDOW (mainwindow), "xlog");
	mainwindow_icon_pixbuf = create_pixbuf ("xlog.png");
	if (mainwindow_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (mainwindow), mainwindow_icon_pixbuf);
			g_object_unref (mainwindow_icon_pixbuf);
		}

	mainvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (mainvbox);
	gtk_container_add (GTK_CONTAINER (mainwindow), mainvbox);

	menubar = gtk_menu_bar_new ();
	gtk_widget_show (menubar);
	gtk_box_pack_start (GTK_BOX (mainvbox), menubar, FALSE, FALSE, 0);

	log = gtk_menu_item_new_with_mnemonic ("_Log");
	gtk_widget_show (log);
	gtk_container_add (GTK_CONTAINER (menubar), log);

	log_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (log), log_menu);

	new = gtk_image_menu_item_new_with_mnemonic (_("New..."));
	gtk_widget_show (new);
	gtk_container_add (GTK_CONTAINER (log_menu), new);
	gtk_widget_add_accelerator (new, "activate", accel_group, GDK_n, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image703 = gtk_image_new_from_stock ("gtk-new", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image703);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (new), image703);

	open = gtk_image_menu_item_new_with_mnemonic (_("Open"));
	gtk_widget_show (open);
	gtk_container_add (GTK_CONTAINER (log_menu), open);
	gtk_widget_add_accelerator (open, "activate", accel_group, GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image704 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image704);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (open), image704);

	scheidslijn1 = gtk_menu_item_new ();
	gtk_widget_show (scheidslijn1);
	gtk_container_add (GTK_CONTAINER (log_menu), scheidslijn1);
	gtk_widget_set_sensitive (scheidslijn1, FALSE);

	save = gtk_image_menu_item_new_with_mnemonic (_("Save"));
	gtk_widget_show (save);
	gtk_container_add (GTK_CONTAINER (log_menu), save);
	gtk_widget_add_accelerator (save, "activate", accel_group, GDK_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image705 = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image705);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (save), image705);

	saveas = gtk_image_menu_item_new_with_mnemonic (_("Save As..."));
	gtk_widget_show (saveas);
	gtk_container_add (GTK_CONTAINER (log_menu), saveas);

	image706 = gtk_image_new_from_stock ("gtk-save-as", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image706);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (saveas), image706);

	close = gtk_image_menu_item_new_with_mnemonic (_("Close"));
	gtk_widget_show (close);
	gtk_container_add (GTK_CONTAINER (log_menu), close);
	gtk_widget_add_accelerator (close, "activate", accel_group, GDK_q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image707 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image707);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (close), image707);

	scheidslijn2 = gtk_menu_item_new ();
	gtk_widget_show (scheidslijn2);
	gtk_container_add (GTK_CONTAINER (log_menu), scheidslijn2);
	gtk_widget_set_sensitive (scheidslijn2, FALSE);

	print = gtk_image_menu_item_new_with_mnemonic (_("Print"));
	gtk_widget_show (print);
	gtk_container_add (GTK_CONTAINER (log_menu), print);

	image708 = gtk_image_new_from_stock ("gtk-print", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image708);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (print), image708);

	exit = gtk_image_menu_item_new_with_mnemonic (_("Exit"));
	gtk_widget_show (exit);
	gtk_container_add (GTK_CONTAINER (log_menu), exit);
	gtk_widget_add_accelerator (exit, "activate", accel_group, GDK_x, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image709 = gtk_image_new_from_stock ("gtk-quit", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image709);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (exit), image709);

	edit = gtk_menu_item_new_with_mnemonic (_("_Edit"));
	gtk_widget_show (edit);
	gtk_container_add (GTK_CONTAINER (menubar), edit);

	edit_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (edit), edit_menu);

	clearframe = gtk_image_menu_item_new_with_mnemonic (_("Clear all"));
	gtk_widget_show (clearframe);
	gtk_container_add (GTK_CONTAINER (edit_menu), clearframe);
	gtk_widget_add_accelerator (clearframe, "activate", accel_group, GDK_y, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image710 = gtk_image_new_from_stock ("gtk-clear", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image710);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (clearframe), image710);

	search = gtk_image_menu_item_new_with_mnemonic (_("Find Callsign"));
	gtk_widget_show (search);
	gtk_container_add (GTK_CONTAINER (edit_menu), search);
	gtk_widget_add_accelerator (search, "activate", accel_group, GDK_f, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image711 = gtk_image_new_from_stock ("gtk-find", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image711);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (search), image711);

	clickall = gtk_image_menu_item_new_with_mnemonic (_("Click all"));
	gtk_widget_show (clickall);
	gtk_container_add (GTK_CONTAINER (edit_menu), clickall);
	gtk_widget_add_accelerator (clickall, "activate", accel_group, GDK_k, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	image712 = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image712);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (clickall), image712);

	tools = gtk_menu_item_new_with_mnemonic (_("_Tools"));
	gtk_widget_show (tools);
	gtk_container_add (GTK_CONTAINER (menubar), tools);

	tools_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (tools), tools_menu);

	log_editor = gtk_image_menu_item_new_with_mnemonic (_("Log Editor"));
	gtk_widget_show (log_editor);
	gtk_container_add (GTK_CONTAINER (tools_menu), log_editor);

	image713 = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image713);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (log_editor), image713);

	dupecheck = gtk_image_menu_item_new_with_mnemonic (_("Dupe Check..."));
	gtk_widget_show (dupecheck);
	gtk_container_add (GTK_CONTAINER (tools_menu), dupecheck);

  image791 = gtk_image_new_from_stock ("gtk-find-and-replace", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image791);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (dupecheck), image791);

	trace_hamlib = gtk_image_menu_item_new_with_mnemonic (_("Trace Hamlib"));
	gtk_widget_show (trace_hamlib);
	gtk_container_add (GTK_CONTAINER (tools_menu), trace_hamlib);

	image714 = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image714);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (trace_hamlib), image714);

	sort_log = gtk_image_menu_item_new_with_mnemonic (_("Sort Log by Date"));
	gtk_widget_show (sort_log);
	gtk_container_add (GTK_CONTAINER (tools_menu), sort_log);

  image733 = gtk_image_new_from_stock ("gtk-go-down", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image733);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (sort_log), image733);

	separator2 = gtk_menu_item_new ();
	gtk_widget_show (separator2);
	gtk_container_add (GTK_CONTAINER (tools_menu), separator2);
	gtk_widget_set_sensitive (separator2, FALSE);

	view_toolbar = gtk_check_menu_item_new_with_mnemonic (_("View Toolbar"));
	gtk_widget_show (view_toolbar);
	gtk_container_add (GTK_CONTAINER (tools_menu), view_toolbar);
	gtk_widget_add_accelerator (view_toolbar, "activate", accel_group, GDK_t, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	worked = gtk_check_menu_item_new_with_mnemonic (_("Worked Before"));
	gtk_widget_show (worked);
	gtk_container_add (GTK_CONTAINER (tools_menu), worked);
	gtk_widget_add_accelerator (worked, "activate", accel_group, GDK_w, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	settings = gtk_menu_item_new_with_mnemonic (_("_Settings"));
	gtk_widget_show (settings);
	gtk_container_add (GTK_CONTAINER (menubar), settings);

	settings_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (settings), settings_menu);

	defaults = gtk_image_menu_item_new_with_mnemonic (_("Defaults"));
	gtk_widget_show (defaults);
	gtk_container_add (GTK_CONTAINER (settings_menu), defaults);

	image715 = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image715);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (defaults), image715);

	dialogs = gtk_image_menu_item_new_with_mnemonic (_("Dialogs"));
	gtk_widget_show (dialogs);
	gtk_container_add (GTK_CONTAINER (settings_menu), dialogs);

	image716 = gtk_image_new_from_stock ("gtk-justify-fill", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image716);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (dialogs), image716);

	separator1 = gtk_menu_item_new ();
	gtk_widget_show (separator1);
	gtk_container_add (GTK_CONTAINER (settings_menu), separator1);
	gtk_widget_set_sensitive (separator1, FALSE);

	preferences = gtk_image_menu_item_new_with_mnemonic (_("Preferences..."));
	gtk_widget_show (preferences);
	gtk_container_add (GTK_CONTAINER (settings_menu), preferences);

	image717 = gtk_image_new_from_stock ("gtk-preferences", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image717);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (preferences), image717);

	help = gtk_menu_item_new_with_mnemonic (_("_Help"));
	gtk_widget_show (help);
	gtk_container_add (GTK_CONTAINER (menubar), help);

	help_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (help), help_menu);

	documentation1 = gtk_image_menu_item_new_with_mnemonic (_("Documentation"));
	gtk_widget_show (documentation1);
	gtk_container_add (GTK_CONTAINER (help_menu), documentation1);

	image718 = gtk_image_new_from_stock ("gtk-help", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image718);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (documentation1), image718);

	documentation1_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (documentation1), documentation1_menu);

	helpfaq = gtk_menu_item_new_with_mnemonic (_("Faq"));
	gtk_widget_show (helpfaq);
	gtk_container_add (GTK_CONTAINER (documentation1_menu), helpfaq);

	helpmanual = gtk_image_menu_item_new_with_mnemonic (_("Manual"));
	gtk_widget_show (helpmanual);
	gtk_container_add (GTK_CONTAINER (documentation1_menu), helpmanual);

	image719 = create_pixmap (mainwindow, "book.xpm");
	gtk_widget_show (image719);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (helpmanual), image719);

	helpreadme = gtk_image_menu_item_new_with_mnemonic (_("Readme"));
	gtk_widget_show (helpreadme);
	gtk_container_add (GTK_CONTAINER (documentation1_menu), helpreadme);

	image720 = gtk_image_new_from_stock ("gtk-dialog-warning", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image720);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (helpreadme), image720);

	helpthanks = gtk_menu_item_new_with_mnemonic (_("Thanks"));
	gtk_widget_show (helpthanks);
	gtk_container_add (GTK_CONTAINER (documentation1_menu), helpthanks);

	helptodo = gtk_menu_item_new_with_mnemonic (_("Todo"));
	gtk_widget_show (helptodo);
	gtk_container_add (GTK_CONTAINER (documentation1_menu), helptodo);

	scheidingslijn1 = gtk_menu_item_new ();
	gtk_widget_show (scheidingslijn1);
	gtk_container_add (GTK_CONTAINER (help_menu), scheidingslijn1);
	gtk_widget_set_sensitive (scheidingslijn1, FALSE);

	about = gtk_image_menu_item_new_with_mnemonic (_("About"));
	gtk_widget_show (about);
	gtk_container_add (GTK_CONTAINER (help_menu), about);

	image721 = gtk_image_new_from_stock ("gtk-dialog-info", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image721);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (about), image721);

	hpaned = gtk_hpaned_new ();
	gtk_widget_show (hpaned);
	gtk_box_pack_start (GTK_BOX (mainvbox), hpaned, TRUE, TRUE, 0);
	gtk_paned_set_position (GTK_PANED (hpaned), 0);

	qsomainvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (qsomainvbox);
	gtk_paned_pack1 (GTK_PANED (hpaned), qsomainvbox, FALSE, FALSE);

	handlebox = gtk_handle_box_new ();
	gtk_widget_show (handlebox);
	gtk_box_pack_start (GTK_BOX (qsomainvbox), handlebox, FALSE, FALSE, 0);

	hbox165 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox165);
	gtk_container_add (GTK_CONTAINER (handlebox), hbox165);

	abutton = gtk_button_new ();
	gtk_widget_show (abutton);
	gtk_box_pack_start (GTK_BOX (hbox165), abutton, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, abutton, _("Add a new QSO to the log [Ctrl-A]"), NULL);
	gtk_widget_add_accelerator (abutton, "clicked", accel_group, GDK_a, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	vbox55 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox55);
	gtk_container_add (GTK_CONTAINER (abutton), vbox55);

	image395 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image395);
	gtk_box_pack_start (GTK_BOX (vbox55), image395, TRUE, TRUE, 0);

	label209 = gtk_label_new (_("Add"));
	gtk_widget_show (label209);
	gtk_box_pack_start (GTK_BOX (vbox55), label209, FALSE, FALSE, 0);

	ubutton = gtk_button_new ();
	gtk_widget_show (ubutton);
	gtk_box_pack_start (GTK_BOX (hbox165), ubutton, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, ubutton, _("Update a modified log entry [Ctrl-U]"), NULL);
	gtk_widget_add_accelerator (ubutton, "clicked", accel_group, GDK_u, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	vbox56 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox56);
	gtk_container_add (GTK_CONTAINER (ubutton), vbox56);

	image396 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image396);
	gtk_box_pack_start (GTK_BOX (vbox56), image396, TRUE, TRUE, 0);

	label210 = gtk_label_new (_("Update"));
	gtk_widget_show (label210);
	gtk_box_pack_start (GTK_BOX (vbox56), label210, FALSE, FALSE, 0);

	dbutton = gtk_button_new ();
	gtk_widget_show (dbutton);
	gtk_box_pack_start (GTK_BOX (hbox165), dbutton, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (tooltips, dbutton, _("Delete a selected log entry [Ctrl-D]"), NULL);
	gtk_widget_add_accelerator (dbutton, "clicked", accel_group, GDK_d, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	vbox57 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox57);
	gtk_container_add (GTK_CONTAINER (dbutton), vbox57);

	image397 = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image397);
	gtk_box_pack_start (GTK_BOX (vbox57), image397, TRUE, TRUE, 0);

	label211 = gtk_label_new (_("Delete"));
	gtk_widget_show (label211);
	gtk_box_pack_start (GTK_BOX (vbox57), label211, FALSE, FALSE, 0);

	qsoscrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (qsoscrolledwindow);
	gtk_box_pack_start (GTK_BOX (qsomainvbox), qsoscrolledwindow, TRUE, TRUE, 0);
	GTK_WIDGET_UNSET_FLAGS (qsoscrolledwindow, GTK_CAN_FOCUS);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (qsoscrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	qsoviewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_show (qsoviewport);
	gtk_container_add (GTK_CONTAINER (qsoscrolledwindow), qsoviewport);
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (qsoviewport), GTK_SHADOW_NONE);

	qsoframesvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (qsoframesvbox);
	gtk_container_add (GTK_CONTAINER (qsoviewport), qsoframesvbox);

	qsoframe = gtk_frame_new (NULL);
	gtk_widget_show (qsoframe);
	gtk_box_pack_start (GTK_BOX (qsoframesvbox), qsoframe, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (qsoframe), 2);
	gtk_frame_set_label_align (GTK_FRAME (qsoframe), 0.5, 0.5);

	qsofieldsvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (qsofieldsvbox);
	gtk_container_add (GTK_CONTAINER (qsoframe), qsofieldsvbox);
	gtk_container_set_border_width (GTK_CONTAINER (qsofieldsvbox), 4);

	datehbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (datehbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), datehbox, FALSE, FALSE, 0);

	datebutton = gtk_button_new_with_mnemonic (_("Date"));
	gtk_widget_show (datebutton);
	gtk_box_pack_start (GTK_BOX (datehbox), datebutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (datebutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (datebutton), 2);

	dateentry = gtk_entry_new ();
	gtk_widget_show (dateentry);
	gtk_box_pack_start (GTK_BOX (datehbox), dateentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (dateentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (dateentry), 15);

	gmthbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (gmthbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), gmthbox, FALSE, FALSE, 0);

	gmtbutton = gtk_button_new_with_mnemonic ("GMT");
	gtk_widget_show (gmtbutton);
	gtk_box_pack_start (GTK_BOX (gmthbox), gmtbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (gmtbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (gmtbutton), 2);

	gmtentry = gtk_entry_new ();
	gtk_widget_show (gmtentry);
	gtk_box_pack_start (GTK_BOX (gmthbox), gmtentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (gmtentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (gmtentry), 8);

	endhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (endhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), endhbox, FALSE, FALSE, 0);

	endbutton = gtk_button_new_with_mnemonic (_("End (GMT)"));
	gtk_widget_show (endbutton);
	gtk_box_pack_start (GTK_BOX (endhbox), endbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (endbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (endbutton), 2);

	endentry = gtk_entry_new ();
	gtk_widget_show (endentry);
	gtk_box_pack_start (GTK_BOX (endhbox), endentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (endentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (endentry), 8);

	callhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (callhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), callhbox, FALSE, FALSE, 0);

	calllabel = gtk_label_new (_("Call"));
	gtk_widget_show (calllabel);
	gtk_box_pack_start (GTK_BOX (callhbox), calllabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (calllabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (calllabel), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (calllabel), 10, 0);

	callentry = gtk_entry_new ();
	gtk_widget_show (callentry);
	gtk_box_pack_start (GTK_BOX (callhbox), callentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (callentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (callentry), 15);

	bandhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (bandhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), bandhbox, FALSE, FALSE, 0);

	mhzhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (mhzhbox);
	gtk_box_pack_start (GTK_BOX (bandhbox), mhzhbox, FALSE, FALSE, 0);

	mhzbutton = gtk_button_new_with_mnemonic ("MHz");
	gtk_widget_show (mhzbutton);
	gtk_box_pack_start (GTK_BOX (mhzhbox), mhzbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (mhzbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (mhzbutton), 2);

	mhzlabel = gtk_label_new ("MHz");
	gtk_widget_show (mhzlabel);
	gtk_box_pack_start (GTK_BOX (mhzhbox), mhzlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (mhzlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (mhzlabel), GTK_JUSTIFY_CENTER);

	bandhbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (bandhbox2);
	gtk_box_pack_start (GTK_BOX (bandhbox), bandhbox2, TRUE, TRUE, 0);

	bandoptionmenu = gtk_option_menu_new ();
	gtk_widget_show (bandoptionmenu);
	gtk_box_pack_start (GTK_BOX (bandhbox2), bandoptionmenu, TRUE, TRUE, 0);
	gtk_widget_set_size_request (bandoptionmenu, 130, 27);

	convertwidget3 = gtk_menu_new ();

	gtk_option_menu_set_menu (GTK_OPTION_MENU (bandoptionmenu), convertwidget3);

	bandentry = gtk_entry_new ();
	gtk_widget_show (bandentry);
	gtk_box_pack_start (GTK_BOX (bandhbox2), bandentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (bandentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (bandentry), 15);

	modehbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (modehbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), modehbox, FALSE, FALSE, 0);

	modehbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (modehbox1);
	gtk_box_pack_start (GTK_BOX (modehbox), modehbox1, FALSE, FALSE, 0);

	modebutton = gtk_button_new_with_mnemonic (_("Mode"));
	gtk_widget_show (modebutton);
	gtk_box_pack_start (GTK_BOX (modehbox1), modebutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (modebutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (modebutton), 2);

	modelabel = gtk_label_new (_("Mode"));
	gtk_widget_show (modelabel);
	gtk_box_pack_start (GTK_BOX (modehbox1), modelabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (modelabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (modelabel), GTK_JUSTIFY_CENTER);

	modehbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (modehbox2);
	gtk_box_pack_start (GTK_BOX (modehbox), modehbox2, TRUE, TRUE, 0);

	modeoptionmenu = gtk_option_menu_new ();
	gtk_widget_show (modeoptionmenu);
	gtk_box_pack_start (GTK_BOX (modehbox2), modeoptionmenu, TRUE, TRUE, 0);
	gtk_widget_set_size_request (modeoptionmenu, 130, 27);

	convertwidget4 = gtk_menu_new ();

	gtk_option_menu_set_menu (GTK_OPTION_MENU (modeoptionmenu), convertwidget4);

	modeentry = gtk_entry_new ();
	gtk_widget_show (modeentry);
	gtk_box_pack_start (GTK_BOX (modehbox2), modeentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (modeentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (modeentry), 8);

	hrsthbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hrsthbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), hrsthbox, FALSE, FALSE, 0);

	hbox39 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox39);
	gtk_box_pack_start (GTK_BOX (hrsthbox), hbox39, FALSE, FALSE, 0);

	rstbutton = gtk_button_new_with_mnemonic ("TX(RST)");
	gtk_widget_show (rstbutton);
	gtk_box_pack_start (GTK_BOX (hbox39), rstbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (rstbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (rstbutton), 2);

	rstlabel = gtk_label_new ("TX(RST)");
	gtk_widget_show (rstlabel);
	gtk_box_pack_start (GTK_BOX (hbox39), rstlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (rstlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (rstlabel), GTK_JUSTIFY_CENTER);

	rstentry = gtk_entry_new ();
	gtk_widget_show (rstentry);
	gtk_box_pack_start (GTK_BOX (hrsthbox), rstentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (rstentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (rstentry), 15);

	mrsthbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (mrsthbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), mrsthbox, FALSE, FALSE, 0);

	myrstlabel = gtk_label_new ("RX(RST)");
	gtk_widget_show (myrstlabel);
	gtk_box_pack_start (GTK_BOX (mrsthbox), myrstlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (myrstlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (myrstlabel), GTK_JUSTIFY_CENTER);

	myrstentry = gtk_entry_new ();
	gtk_widget_show (myrstentry);
	gtk_box_pack_start (GTK_BOX (mrsthbox), myrstentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (myrstentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (myrstentry), 15);

	qslhbox = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (qslhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), qslhbox, FALSE, FALSE, 0);

	outcheckbutton = gtk_check_button_new_with_mnemonic (_("QSL out"));
	gtk_widget_show (outcheckbutton);
	gtk_box_pack_start (GTK_BOX (qslhbox), outcheckbutton, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (outcheckbutton, GTK_CAN_FOCUS);

	incheckbutton = gtk_check_button_new_with_mnemonic (_("QSL in"));
	gtk_widget_show (incheckbutton);
	gtk_box_pack_start (GTK_BOX (qslhbox), incheckbutton, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (incheckbutton, GTK_CAN_FOCUS);

	powerhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (powerhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), powerhbox, FALSE, FALSE, 0);

	hbox74 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox74);
	gtk_box_pack_start (GTK_BOX (powerhbox), hbox74, FALSE, FALSE, 0);

	powerbutton = gtk_button_new_with_mnemonic (_("Power"));
	gtk_widget_show (powerbutton);
	gtk_box_pack_start (GTK_BOX (hbox74), powerbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (powerbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (powerbutton), 2);

	powerlabel = gtk_label_new (_("Power"));
	gtk_widget_show (powerlabel);
	gtk_box_pack_start (GTK_BOX (hbox74), powerlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (powerlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (powerlabel), GTK_JUSTIFY_CENTER);

	powerentry = gtk_entry_new ();
	gtk_widget_show (powerentry);
	gtk_box_pack_start (GTK_BOX (powerhbox), powerentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (powerentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (powerentry), 8);

	namehbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (namehbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), namehbox, FALSE, FALSE, 0);

	namelabel = gtk_label_new (_("Name"));
	gtk_widget_show (namelabel);
	gtk_box_pack_start (GTK_BOX (namehbox), namelabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (namelabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (namelabel), GTK_JUSTIFY_CENTER);

	nameentry = gtk_entry_new ();
	gtk_widget_show (nameentry);
	gtk_box_pack_start (GTK_BOX (namehbox), nameentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (nameentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (nameentry), 30);

	qthhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (qthhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), qthhbox, FALSE, FALSE, 0);

	qthlabel = gtk_label_new ("QTH");
	gtk_widget_show (qthlabel);
	gtk_box_pack_start (GTK_BOX (qthhbox), qthlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (qthlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (qthlabel), GTK_JUSTIFY_CENTER);

	qthentry = gtk_entry_new ();
	gtk_widget_show (qthentry);
	gtk_box_pack_start (GTK_BOX (qthhbox), qthentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (qthentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (qthentry), 30);

	locatorhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (locatorhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), locatorhbox, FALSE, FALSE, 0);

	locatorlabel = gtk_label_new (_("Locator"));
	gtk_widget_show (locatorlabel);
	gtk_box_pack_start (GTK_BOX (locatorhbox), locatorlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (locatorlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (locatorlabel), GTK_JUSTIFY_CENTER);

	locatorentry = gtk_entry_new ();
	gtk_widget_show (locatorentry);
	gtk_box_pack_start (GTK_BOX (locatorhbox), locatorentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (locatorentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (locatorentry), 8);

	unknown1hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (unknown1hbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), unknown1hbox, FALSE, FALSE, 0);

	unknownlabel1 = gtk_label_new ("");
	gtk_widget_show (unknownlabel1);
	gtk_box_pack_start (GTK_BOX (unknown1hbox), unknownlabel1, FALSE, FALSE, 0);
	gtk_widget_set_size_request (unknownlabel1, 100, 17);
	gtk_label_set_justify (GTK_LABEL (unknownlabel1), GTK_JUSTIFY_CENTER);

	unknownentry1 = gtk_entry_new ();
	gtk_widget_show (unknownentry1);
	gtk_box_pack_start (GTK_BOX (unknown1hbox), unknownentry1, TRUE, TRUE, 0);
	gtk_widget_set_size_request (unknownentry1, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (unknownentry1), 30);

	unknown2hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (unknown2hbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), unknown2hbox, FALSE, FALSE, 0);

	unknownlabel2 = gtk_label_new ("");
	gtk_widget_show (unknownlabel2);
	gtk_box_pack_start (GTK_BOX (unknown2hbox), unknownlabel2, FALSE, FALSE, 0);
	gtk_widget_set_size_request (unknownlabel2, 100, 17);
	gtk_label_set_justify (GTK_LABEL (unknownlabel2), GTK_JUSTIFY_CENTER);

	unknownentry2 = gtk_entry_new ();
	gtk_widget_show (unknownentry2);
	gtk_box_pack_start (GTK_BOX (unknown2hbox), unknownentry2, TRUE, TRUE, 0);
	gtk_widget_set_size_request (unknownentry2, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (unknownentry2), 30);

	remarksvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (remarksvbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), remarksvbox, FALSE, FALSE, 0);

	hbox149 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox149);
	gtk_box_pack_start (GTK_BOX (remarksvbox), hbox149, FALSE, FALSE, 0);

	remarkslabel = gtk_label_new (_("Remarks"));
	gtk_widget_show (remarkslabel);
	gtk_box_pack_start (GTK_BOX (hbox149), remarkslabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (remarkslabel, 230, 17);
	gtk_label_set_justify (GTK_LABEL (remarkslabel), GTK_JUSTIFY_CENTER);

	hbox150 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox150);
	gtk_box_pack_start (GTK_BOX (remarksvbox), hbox150, FALSE, FALSE, 0);

	remarksentry = gtk_entry_new ();
	gtk_widget_show (remarksentry);
	gtk_box_pack_start (GTK_BOX (hbox150), remarksentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (remarksentry, 230, 25);
	gtk_widget_set_events (remarksentry, GDK_FOCUS_CHANGE_MASK);
	gtk_entry_set_max_length (GTK_ENTRY (remarksentry), 80);

	label1 = gtk_label_new (_("New QSO"));
	gtk_widget_show (label1);
	gtk_frame_set_label_widget (GTK_FRAME (qsoframe), label1);

	dxccframe = gtk_frame_new (NULL);
	gtk_widget_show (dxccframe);
	gtk_box_pack_start (GTK_BOX (qsoframesvbox), dxccframe, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (dxccframe), 2);
	gtk_frame_set_label_align (GTK_FRAME (dxccframe), 0.5, 0.5);

	dxccvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (dxccvbox);
	gtk_container_add (GTK_CONTAINER (dxccframe), dxccvbox);

	dxcclabel1 = gtk_label_new ("");
	gtk_widget_show (dxcclabel1);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel1), GTK_JUSTIFY_CENTER);

	dxcclabel2 = gtk_label_new ("");
	gtk_widget_show (dxcclabel2);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel2), GTK_JUSTIFY_CENTER);

	dxcclabel3 = gtk_label_new ("");
	gtk_widget_show (dxcclabel3);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel3, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel3), GTK_JUSTIFY_CENTER);

	dxcclabel4 = gtk_label_new ("");
	gtk_widget_show (dxcclabel4);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel4, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel4), GTK_JUSTIFY_CENTER);

	dxcclabel5 = gtk_label_new ("");
	gtk_widget_show (dxcclabel5);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel5, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel5), GTK_JUSTIFY_CENTER);

	label2 = gtk_label_new ("DXCC");
	gtk_widget_show (label2);
	gtk_frame_set_label_widget (GTK_FRAME (dxccframe), label2);

	locatorframe = gtk_frame_new (NULL);
	gtk_widget_show (locatorframe);
	gtk_box_pack_start (GTK_BOX (qsoframesvbox), locatorframe, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (locatorframe), 2);
	gtk_frame_set_label_align (GTK_FRAME (locatorframe), 0.5, 0.5);

	locatorvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (locatorvbox);
	gtk_container_add (GTK_CONTAINER (locatorframe), locatorvbox);

	locatorlabel1 = gtk_label_new ("");
	gtk_widget_show (locatorlabel1);
	gtk_box_pack_start (GTK_BOX (locatorvbox), locatorlabel1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (locatorlabel1), GTK_JUSTIFY_CENTER);

	label3 = gtk_label_new (_("Locator"));
	gtk_widget_show (label3);
	gtk_frame_set_label_widget (GTK_FRAME (locatorframe), label3);

	statushbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (statushbox);
	gtk_box_pack_start (GTK_BOX (mainvbox), statushbox, FALSE, FALSE, 0);

	statusbar = gtk_statusbar_new ();
	gtk_widget_show (statusbar);
	gtk_box_pack_start (GTK_BOX (statushbox), statusbar, TRUE, TRUE, 0);
	gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (statusbar), FALSE);

	frequencyhandlebox = gtk_handle_box_new ();
	gtk_widget_show (frequencyhandlebox);
	gtk_box_pack_start (GTK_BOX (statushbox), frequencyhandlebox, FALSE, FALSE, 0);

	frequencyhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (frequencyhbox);
	gtk_container_add (GTK_CONTAINER (frequencyhandlebox), frequencyhbox);

	frequencypixmap = create_pixmap (mainwindow, "mini-trx.xpm");
	gtk_widget_show (frequencypixmap);
	gtk_box_pack_start (GTK_BOX (frequencyhbox), frequencypixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (frequencypixmap), 5, 0);

	frequencylabel = gtk_label_new ("");
	gtk_widget_show (frequencylabel);
	gtk_box_pack_start (GTK_BOX (frequencyhbox), frequencylabel, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (frequencylabel), 5, 0);

	smeterhandlebox = gtk_handle_box_new ();
	gtk_widget_show (smeterhandlebox);
	gtk_box_pack_start (GTK_BOX (statushbox), smeterhandlebox, FALSE, FALSE, 0);

	smeterhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (smeterhbox);
	gtk_container_add (GTK_CONTAINER (smeterhandlebox), smeterhbox);
	gtk_container_set_border_width (GTK_CONTAINER (smeterhbox), 2);

	smeterpixmap = create_pixmap (mainwindow, "s.xpm");
	gtk_widget_show (smeterpixmap);
	gtk_box_pack_start (GTK_BOX (smeterhbox), smeterpixmap, FALSE, FALSE, 0);

	smeterdrawingarea = gtk_drawing_area_new ();
	gtk_widget_show (smeterdrawingarea);
	gtk_box_pack_start (GTK_BOX (smeterhbox), smeterdrawingarea, TRUE, TRUE, 0);
	gtk_widget_set_size_request (smeterdrawingarea, 144, 20);

	clockhandlebox = gtk_handle_box_new ();
	gtk_widget_show (clockhandlebox);
	gtk_box_pack_start (GTK_BOX (statushbox), clockhandlebox, FALSE, FALSE, 0);

	clockhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (clockhbox);
	gtk_container_add (GTK_CONTAINER (clockhandlebox), clockhbox);

	clockpixmap = create_pixmap (mainwindow, "mini-clock.xpm");
	gtk_widget_show (clockpixmap);
	gtk_box_pack_start (GTK_BOX (clockhbox), clockpixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (clockpixmap), 5, 0);

	clocklabel = gtk_label_new ("");
	gtk_widget_show (clocklabel);
	gtk_box_pack_start (GTK_BOX (clockhbox), clocklabel, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (clocklabel), 5, 0);

	g_signal_connect ((gpointer) mainwindow, "delete_event", G_CALLBACK (on_mainwindow_delete_event), NULL);
	g_signal_connect ((gpointer) new, "activate", G_CALLBACK (on_menu_new_activate), NULL);
	g_signal_connect ((gpointer) open, "activate", G_CALLBACK (on_menu_open_activate), NULL);
	g_signal_connect ((gpointer) save, "activate", G_CALLBACK (on_menu_save_activate), NULL);
	g_signal_connect ((gpointer) saveas, "activate", G_CALLBACK (on_menu_saveas_activate), NULL);
	g_signal_connect ((gpointer) close, "activate", G_CALLBACK (on_menu_close_activate), NULL);
	g_signal_connect ((gpointer) print, "activate", G_CALLBACK (on_menu_print_activate), NULL);
	g_signal_connect ((gpointer) exit, "activate", G_CALLBACK (on_menu_exit_activate), NULL);
	g_signal_connect ((gpointer) clearframe, "activate", G_CALLBACK (on_clearframe_activate), NULL);
	g_signal_connect ((gpointer) search, "activate", G_CALLBACK (on_menu_search_activate), NULL);
	g_signal_connect ((gpointer) clickall, "activate", G_CALLBACK (on_clickall_activate), NULL);
	g_signal_connect ((gpointer) log_editor, "activate", G_CALLBACK (on_menu_logeditor_activate), NULL);
	g_signal_connect ((gpointer) dupecheck, "activate", G_CALLBACK (on_menu_dupecheck_activate), NULL);
#if WANT_HAMLIB
	g_signal_connect ((gpointer) trace_hamlib, "activate", G_CALLBACK (on_trace_hamlib_activate), NULL);
#endif
  g_signal_connect ((gpointer) sort_log, "activate", G_CALLBACK (on_sort_log_activate), NULL);
	g_signal_connect ((gpointer) view_toolbar, "activate", G_CALLBACK (on_view_toolbar_activate), NULL);
	g_signal_connect ((gpointer) worked, "activate", G_CALLBACK (on_menu_worked_activate), NULL);
	g_signal_connect ((gpointer) defaults, "activate", G_CALLBACK (on_menu_defaults_activate), NULL);
	g_signal_connect ((gpointer) dialogs, "activate", G_CALLBACK (on_menu_dialogs_activate), NULL);
	g_signal_connect ((gpointer) preferences, "activate", G_CALLBACK (on_menu_preferences_activate), NULL);
	g_signal_connect ((gpointer) helpfaq, "activate", G_CALLBACK (on_helpfaq_activate), NULL);
	g_signal_connect ((gpointer) helpmanual, "activate", G_CALLBACK (on_helpmanual_activate), NULL);
	g_signal_connect ((gpointer) helpreadme, "activate", G_CALLBACK (on_helpreadme_activate), NULL);
	g_signal_connect ((gpointer) helpthanks, "activate", G_CALLBACK (on_helpthanks_activate), NULL);
	g_signal_connect ((gpointer) helptodo, "activate", G_CALLBACK (on_helptodo_activate), NULL);
	g_signal_connect ((gpointer) about, "activate", G_CALLBACK (on_menu_about_activate), NULL);
	g_signal_connect ((gpointer) abutton, "clicked", G_CALLBACK (on_abutton_clicked), NULL);
	g_signal_connect ((gpointer) ubutton, "clicked", G_CALLBACK (on_ubutton_clicked), NULL);
	g_signal_connect ((gpointer) dbutton, "clicked", G_CALLBACK (on_dbutton_clicked), NULL);
	g_signal_connect ((gpointer) datebutton, "clicked", G_CALLBACK (on_datebutton_clicked), NULL);
	g_signal_connect ((gpointer) gmtbutton, "clicked", G_CALLBACK (on_gmtbutton_clicked), NULL);
	g_signal_connect ((gpointer) endbutton, "clicked", G_CALLBACK (on_endbutton_clicked), NULL);
	g_signal_connect ((gpointer) callentry, "insert_text", G_CALLBACK (on_callentry_insert_text), NULL);
	g_signal_connect ((gpointer) callentry, "changed", G_CALLBACK (on_callentry_changed), NULL);
	g_signal_connect ((gpointer) bandoptionmenu, "key_press_event", G_CALLBACK (on_bandoptionmenu_key_press_event), NULL);
	g_signal_connect ((gpointer) modeoptionmenu, "key_press_event", G_CALLBACK (on_modeoptionmenu_key_press_event), NULL);
	g_signal_connect ((gpointer) locatorentry, "changed", G_CALLBACK (on_locatorentry_changed), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (mainwindow, mainwindow, "mainwindow");
	
	/* next 2 menus used in newlogdialog */
	GLADE_HOOKUP_OBJECT (mainwindow, menubar, "menubar");
	GLADE_HOOKUP_OBJECT (mainwindow, log_editor, "log_editor");
	GLADE_HOOKUP_OBJECT (mainwindow, clearframe, "clearframe");

	GLADE_HOOKUP_OBJECT (mainwindow, view_toolbar, "view_toolbar");
	GLADE_HOOKUP_OBJECT (mainwindow, worked, "worked");
	GLADE_HOOKUP_OBJECT (mainwindow, trace_hamlib, "trace_hamlib");
	GLADE_HOOKUP_OBJECT (mainwindow, sort_log, "sort_log");

	GLADE_HOOKUP_OBJECT (mainwindow, handlebox, "handlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, hpaned, "hpaned");

	GLADE_HOOKUP_OBJECT (mainwindow, qsoframe, "qsoframe");
	GLADE_HOOKUP_OBJECT (mainwindow, datebutton, "datebutton");
	GLADE_HOOKUP_OBJECT (mainwindow, dateentry, "dateentry");
	GLADE_HOOKUP_OBJECT (mainwindow, gmtbutton, "gmtbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, gmtentry, "gmtentry");
	GLADE_HOOKUP_OBJECT (mainwindow, endhbox, "endhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, endbutton, "endbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, endentry, "endentry");
	GLADE_HOOKUP_OBJECT (mainwindow, calllabel, "calllabel");
	GLADE_HOOKUP_OBJECT (mainwindow, callentry, "callentry");
	GLADE_HOOKUP_OBJECT (mainwindow, mhzbutton, "mhzbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, mhzlabel, "mhzlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, bandoptionmenu, "bandoptionmenu");
	GLADE_HOOKUP_OBJECT (mainwindow, bandentry, "bandentry");
	GLADE_HOOKUP_OBJECT (mainwindow, modebutton, "modebutton");
	GLADE_HOOKUP_OBJECT (mainwindow, modelabel, "modelabel");
	GLADE_HOOKUP_OBJECT (mainwindow, modeoptionmenu, "modeoptionmenu");
	GLADE_HOOKUP_OBJECT (mainwindow, modeentry, "modeentry");
	GLADE_HOOKUP_OBJECT (mainwindow, rstbutton, "rstbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, rstlabel, "rstlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, rstentry, "rstentry");
	GLADE_HOOKUP_OBJECT (mainwindow, myrstlabel, "myrstlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, myrstentry, "myrstentry");
	GLADE_HOOKUP_OBJECT (mainwindow, qslhbox, "qslhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, outcheckbutton, "outcheckbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, incheckbutton, "incheckbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, powerhbox, "powerhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, powerbutton, "powerbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, powerlabel, "powerlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, powerentry, "powerentry");
	GLADE_HOOKUP_OBJECT (mainwindow, namehbox, "namehbox");
	GLADE_HOOKUP_OBJECT (mainwindow, namelabel, "namelabel");
	GLADE_HOOKUP_OBJECT (mainwindow, nameentry, "nameentry");
	GLADE_HOOKUP_OBJECT (mainwindow, qthhbox, "qthhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, qthlabel, "qthlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, qthentry, "qthentry");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorhbox, "locatorhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorlabel, "locatorlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorentry, "locatorentry");
	GLADE_HOOKUP_OBJECT (mainwindow, unknown1hbox, "unknown1hbox");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownlabel1, "unknownlabel1");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownentry1, "unknownentry1");
	GLADE_HOOKUP_OBJECT (mainwindow, unknown2hbox, "unknown2hbox");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownlabel2, "unknownlabel2");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownentry2, "unknownentry2");
	GLADE_HOOKUP_OBJECT (mainwindow, remarksvbox, "remarksvbox");
	GLADE_HOOKUP_OBJECT (mainwindow, remarkslabel, "remarkslabel");
	GLADE_HOOKUP_OBJECT (mainwindow, remarksentry, "remarksentry");

	GLADE_HOOKUP_OBJECT (mainwindow, dxccframe, "dxccframe");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel1, "dxcclabel1");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel2, "dxcclabel2");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel3, "dxcclabel3");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel4, "dxcclabel4");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel5, "dxcclabel5");

	GLADE_HOOKUP_OBJECT (mainwindow, locatorframe, "locatorframe");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorlabel1, "locatorlabel1");

	GLADE_HOOKUP_OBJECT (mainwindow, statusbar, "statusbar");
	GLADE_HOOKUP_OBJECT (mainwindow, frequencyhandlebox, "frequencyhandlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, frequencylabel, "frequencylabel");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterhandlebox, "smeterhandlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterhbox, "smeterhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterpixmap, "smeterpixmap");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterdrawingarea, "smeterdrawingarea");
	GLADE_HOOKUP_OBJECT (mainwindow, clockhandlebox, "clockhandlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, clocklabel, "clocklabel");

	gtk_window_add_accel_group (GTK_WINDOW (mainwindow), accel_group);

	return mainwindow;
}
