/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.util.Hashtable;

public class GtkImagePainter
implements Runnable,
ImageConsumer {
    GtkImage image;
    GdkGraphics gc;
    int startX;
    int startY;
    int redBG;
    int greenBG;
    int blueBG;
    double[] affine;
    int width;
    int height;
    boolean flipX;
    boolean flipY;
    Rectangle clip;
    int s_width;
    int s_height;

    public GtkImagePainter(GtkImage image, GdkGraphics gc, int x, int y, int width, int height, Color bgcolor) {
        this.image = image;
        this.gc = (GdkGraphics)gc.create();
        this.startX = x;
        this.startY = y;
        this.redBG = bgcolor.getRed();
        this.greenBG = bgcolor.getGreen();
        this.blueBG = bgcolor.getBlue();
        this.width = width;
        this.height = height;
        this.flipY = false;
        this.flipX = false;
        this.s_height = 0;
        this.s_width = 0;
        this.clip = null;
        new Thread(this).start();
    }

    public GtkImagePainter(GtkImage image, GdkGraphics gc, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor) {
        this.image = image;
        this.gc = (GdkGraphics)gc.create();
        this.startX = dx1 < dx2 ? dx1 : dx2;
        this.startY = dy1;
        this.redBG = bgcolor.getRed();
        this.greenBG = bgcolor.getGreen();
        this.blueBG = bgcolor.getBlue();
        this.width = Math.abs(dx2 - dx1);
        this.height = Math.abs(dy2 - dy1);
        this.flipX = dx1 > dx2 && sx2 > sx1 || dx1 < dx2 && sx2 < sx1;
        this.flipY = dy1 > dy2 && sy2 > sy1 || dy1 < dy2 && sy2 < sy1;
        this.s_width = Math.abs(sx2 - sx1);
        this.s_height = Math.abs(sy2 - sy1);
        this.clip = new Rectangle(sx1, sy1, this.s_width, this.s_height);
        new Thread(this).start();
    }

    public void run() {
        this.image.startProduction(this);
        this.gc.dispose();
    }

    static int[] convertPixels(int[] pixels, ColorModel model) {
        if (model.equals(ColorModel.getRGBdefault())) {
            return pixels;
        }
        int[] ret = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            ret[i] = model.getRGB(pixels[i]);
        }
        return ret;
    }

    static int[] convertPixels(byte[] pixels, ColorModel model) {
        int[] ret = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            ret[i] = model.getRGB(pixels[i]);
        }
        return ret;
    }

    native void drawPixels(GdkGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9, int var10, int var11, double[] var12);

    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scansize) {
        if (this.clip != null) {
            Rectangle r = this.clip.intersection(new Rectangle(x, y, width, height));
            if (r.width == 0 && r.height == 0) {
                return;
            }
            offset += r.y * scansize + r.x;
            r.translate(-Math.abs(this.clip.x - this.startX), -Math.abs(this.clip.y - this.startY));
            width = r.width;
            height = r.height;
            x = r.x;
            y = r.y;
        }
        this.drawPixels(this.gc, this.redBG, this.greenBG, this.blueBG, this.startX + x, this.startY + y, width, height, GtkImagePainter.convertPixels(pixels, model), offset, scansize, this.affine);
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int offset, int scansize) {
        this.setPixels(x, y, width, height, model, GtkImagePainter.convertPixels(pixels, model), offset, scansize);
    }

    public void setDimensions(int width, int height) {
        if (!this.flipX && !this.flipY && (this.width == -1 && this.height == -1 || this.width == width && this.height == height)) {
            return;
        }
        this.affine = new double[6];
        this.affine[5] = 0.0;
        this.affine[4] = 0.0;
        this.affine[2] = 0.0;
        this.affine[1] = 0.0;
        if (this.clip != null) {
            this.affine[0] = (double)this.width / (double)this.s_width;
            this.affine[3] = (double)this.height / (double)this.s_height;
        } else {
            this.affine[0] = (double)this.width / (double)width;
            this.affine[3] = (double)this.height / (double)height;
        }
        if (this.flipX) {
            this.affine[0] = -this.affine[0];
            this.affine[4] = this.width;
        }
        if (this.flipY) {
            this.affine[3] = -this.affine[3];
            this.affine[5] = this.height;
        }
        if (this.affine[0] == 1.0 && this.affine[3] == 1.0) {
            this.affine = null;
        }
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel model) {
    }

    public void setHints(int flags) {
    }

    public void imageComplete(int status) {
    }
}

