
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by: 
 *      Author : thomas
 *      Date   : Thu Aug 28 2003
 */

#ifndef CPPHEADERCODEDOCUMENT_H
#define CPPHEADERCODEDOCUMENT_H

#include <qstring.h>

#include "../classifiercodedocument.h"
#include "../hierarchicalcodeblock.h"
#include "classifierinfo.h"

class CPPCodeGenerator;
class CPPHeaderClassDeclarationBlock;

/**
  * class CPPHeaderCodeDocument
  * A CPP UMLClassifier Header Code Document.
  */

class CPPHeaderCodeDocument : public ClassifierCodeDocument
{
	Q_OBJECT
public:

	// Constructors/Destructors
	//  

	/**
	 * Constructor
	 */
	CPPHeaderCodeDocument (UMLClassifier * classifier , CPPCodeGenerator * parent);

	/**
	 * Empty Destructor
	 */
	virtual ~CPPHeaderCodeDocument ( );

	/** add a code operation to this cpp classifier code document.
	 *  @return bool which is true IF the code operation was added successfully
	 */
	bool addCodeOperation (CodeOperation * op );

      /**
         * create a new CodeAccesorMethod object belonging to this CodeDocument.
         * @return      CodeAccessorMethod
         */
        virtual CodeAccessorMethod * newCodeAccessorMethod( CodeClassField *cf, CodeAccessorMethod::AccessorType type );

       /**
         * create a new CodeOperation object belonging to this CodeDocument.
         * @return      CodeOperation
         */
        virtual CodeOperation * newCodeOperation( UMLOperation * op );

	/**
         * create a new CodeClassField declaration block object belonging to this CodeDocument.
	 */
	virtual CodeClassFieldDeclarationBlock * newDeclarationCodeBlock (CodeClassField * cf );

       /**
         * Save the XMI representation of this object
         * @return      bool    status of save
         */
        //virtual bool saveToXMI ( QDomDocument & doc, QDomElement & root );

	// a little utility method to save us some work
	QString getCPPClassName (QString name);

protected:

        // reset/clear our inventory of textblocks in this document
        void resetTextBlocks();

        /** create new code classfield for this document.
         */
        virtual CodeClassField * newCodeClassField( UMLAttribute *at);
        virtual CodeClassField * newCodeClassField( UMLRole *role);

       /**
         * need to overwrite this for cpp header since we need to pick up the
         * header class declaration block.
         */
        virtual void loadChildTextBlocksFromNode ( QDomElement & root);

	void addOrUpdateCodeClassFieldMethodsInCodeBlock(QPtrList<CodeClassField> &list, CPPHeaderClassDeclarationBlock * codeBlock); 

        /**
         * create a new code comment. IN this case it is a CPPCodeDocumentation object.
         */
        CodeComment * newCodeComment ( );

       // IF the classifier object is modified, this will get called.
        // Possible mods include changing the filename and package
        // based on values the classifier has.
        virtual void syncNamesToParent( );

        bool forceDoc ();

	void updateContent();

private:

        CPPHeaderClassDeclarationBlock * classDeclCodeBlock;

	HierarchicalCodeBlock * publicBlock;
	HierarchicalCodeBlock * privateBlock;
	HierarchicalCodeBlock * protectedBlock;

	HierarchicalCodeBlock * namespaceBlock;

	HierarchicalCodeBlock * pubConstructorBlock;
	HierarchicalCodeBlock * protConstructorBlock;
	HierarchicalCodeBlock * privConstructorBlock;

	HierarchicalCodeBlock * pubOperationsBlock;
	HierarchicalCodeBlock * privOperationsBlock;
	HierarchicalCodeBlock * protOperationsBlock;

	QString fileName; // Just for our convience in creating code
	QString endLine; // characters for ending line. Just for our convience in creating code
	QString CPPClassName;

	void init ( );
	CPPHeaderClassDeclarationBlock * getClassDecl();

};

#endif // CPPHEADERCODEDOCUMENT_H
