/* This file is part of the KDE libraries
    Copyright (c) 2002-2003 KDE Team

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef _KDE_MACROS_H_
#define _KDE_MACROS_H_

/**
 * The KDE_NO_EXPORT macro marks the symbol of the given variable 
 * to be hidden. A hidden symbol is stripped during the linking step, 
 * so it can't be used from outside the resulting library, which is similiar
 * to static. However, static limits the visibility to the current 
 * compilation unit. hidden symbols can still be used in multiple compilation
 * units.
 *
 * \code
 * int KDE_NO_EXPORT foo;
 * int KDE_EXPORT bar;
 * \end
 */

#if __GNUC__ - 0 > 3 || (__GNUC__ - 0 == 3 && __GNUC_MINOR__ - 0 > 2)
#define KDE_NO_EXPORT __attribute__ ((visibility("hidden")))
#define KDE_EXPORT __attribute__ ((visibility("visible")))
#else
#define KDE_NO_EXPORT
#define KDE_EXPORT
#endif

/**
 * The KDE_PACKED can be used to hint the compiler that a particular
 * structure or class should not contain unnecessary paddings. 
 */

#ifdef __GNUC__
#define KDE_PACKED __attribute__((__packed__))
#else
#define KDE_PACKED
#endif

/**
 * The KDE_DEPRECATED macro can be used to trigger compile-time warnings
 * with gcc >= 3.2 when deprecated functions are used.
 *
 * For non-inline functions, the macro gets inserted at the very end of the
 * function declaration, right before the semicolon:
 *
 * \code
 * DeprecatedConstructor() KDE_DEPRECATED;
 * void deprecatedFunctionA() KDE_DEPRECATED;
 * int deprecatedFunctionB() const KDE_DEPRECATED;
 * \endcode
 *
 * Functions which are implemented inline are handled differently: for them,
 * the KDE_DEPRECATED macro is inserted at the front, right before the return
 * type, but after "static" or "virtual":
 *
 * \code
 * KDE_DEPRECATED void deprecatedInlineFunctionA() { .. }
 * virtual KDE_DEPRECATED int deprecatedInlineFunctionB() { .. }
 * static KDE_DEPRECATED bool deprecatedInlineFunctionC() { .. }
 * \end
 *
 * You can also mark whole structs or classes as deprecated, by inserting the
 * KDE_DEPRECATED macro after the struct/class keyword, but before the
 * name of the struct/class:
 *
 * \code
 * class KDE_DEPRECATED DeprecatedClass { };
 * struct KDE_DEPRECATED DeprecatedStruct { };
 * \endcode
 *
 * \note
 * It does not make much sense to use the KDE_DEPRECATED keyword for a Qt signal
 * or a slot; this is because signals and slots always get referenced by the
 * code generated by moc.
 *
 * \par
 * Also note that it is not possible to use KDE_DEPRECATED for classes which
 * use the k_dcop keyword (to indicate a DCOP interface declaration); this is
 * because the dcopidl program would choke on the unexpected declaration
 * syntax.
 */
#ifndef KDE_DEPRECATED
#if __GNUC__ - 0 > 3 || (__GNUC__ - 0 == 3 && __GNUC_MINOR__ - 0 >= 2)
# define KDE_DEPRECATED __attribute__ ((deprecated))
#else
# define KDE_DEPRECATED
#endif
#endif

#endif // _KDE_MACROS_H_
