/***************************************************************************
                           card.h  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#ifndef CARD_H
#define CARD_H

#include <qvaluelist.h>

class QString;

class Card 
{
public: 
  Card();
  Card(const QString &front, const QString &back);
  ~Card();

  QString front() const;
  QString back() const;
  void setFront(const QString &front);
  void setBack(const QString &back);

  bool frontBackReversed() const { return reversed; }
  void setFrontBackReversed(bool reverse) { reversed = reverse; }
  
private:
  QString cardFront;
  QString cardBack;
  bool reversed;
};

typedef QValueList<Card> CardList;

#endif
