/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>
Copyright (c) 2002 John Firebaugh <jfirebaugh@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskcontainer_h__
#define __taskcontainer_h__

#include <qptrlist.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qtimer.h>
#include <qtoolbutton.h>

#include "taskmanager.h"
#include "taskbar.h"

class LMBMenu;
class RMBMenu;
class TaskContainer;

typedef QPtrList<QPixmap> PixmapList;
typedef QPtrList<TaskContainer> TaskContainerList;
typedef QPtrListIterator<TaskContainer> TaskContainerListIterator;

class TaskContainer : public QToolButton
{
    Q_OBJECT

public:
    TaskContainer( Task*, TaskManager*, bool show, bool sort, bool icon, bool iconifiedOnly, QWidget *parent = 0, const char *name = 0 );
    TaskContainer( Startup*, PixmapList*, TaskManager*, bool show, bool sort, bool icon, bool iconifiedOnly, QWidget *parent = 0, const char *name = 0 );
    virtual ~TaskContainer();

    void setArrowType( Qt::ArrowType at );
    void setShowAll( bool );
    void setSortByDesktop( bool );
    void setShowIcon( bool );
    void setShowIconifiedOnly( bool s );

    void init();

    void add( Task* );
    void add( Startup* );

    void remove( Task* );
    void remove( Startup* );

    bool contains( Task* );
    bool contains( Startup* );
    bool contains( WId );

    bool isEmpty();
    bool onCurrentDesktop();
    bool isIconified();

    QString id();
    int desktop();
    QString name();

    virtual QSizePolicy sizePolicy () const;

    void publishIconGeometry( QPoint );
    void desktopChanged( int );
    void windowChanged( WId );
    bool eventFilter( QObject *o, QEvent *e );

    static void setLeftButtonAction( TaskBar::Action action )
        { leftButtonAction = action; }
    static void setMiddleButtonAction( TaskBar::Action action )
        { middleButtonAction = action; }
    static void setRightButtonAction( TaskBar::Action action )
        { rightButtonAction = action; }

    int taskCount() const { return tasks.count(); }
    int filteredTaskCount() const { return ftasks.count(); }

protected slots:
    void animationTimerFired();
    void attentionTimerFired();
    void slotClicked();
    void dragSwitch();
    void update();
    void setLastActivated();
    void taskChanged();

protected:
    void drawButton( QPainter* );
    void resizeEvent( QResizeEvent* );
    void mousePressEvent( QMouseEvent* );
    void mouseReleaseEvent( QMouseEvent* );
    void dragEnterEvent( QDragEnterEvent* );
    void dragLeaveEvent( QDragLeaveEvent* );
    void wheelEvent( QWheelEvent* );

    void performAction( TaskBar::Action action );
    void popupMenu( TaskBar::Action action );

    void updateFilteredTaskList();
    QColor blendColors( QColor, QColor );

private:
    void checkAttention( const Task* changed_task = NULL );
    QString                     sid;
    QString                     currentTooltip;
    QTimer                      animationTimer;
    QTimer                      dragSwitchTimer;
    int                         currentFrame;
    QRect                       iconRect;
    QPixmap                     animBg;
    TaskList                    tasks;
    TaskList                    ftasks;
    Task*                       lastActivated;
    StartupList                 startups;
    PixmapList*                 frames;
    ArrowType                   arrowType;
    TaskManager*                taskManager;
    bool                        showAll;
    bool                        showOnlyIconified;
    bool                        sortByDesktop;
    bool                        showIcon;
    static TaskBar::Action      leftButtonAction;
    static TaskBar::Action      middleButtonAction;
    static TaskBar::Action      rightButtonAction;
    bool                        discardNextMouseEvent;
    bool                        aboutToActivate;
    QTimer                      attentionTimer;
    enum                        { ATTENTION_BLINK_TIMEOUT = 4 };
    int                         attentionState;
    static QImage               blendGradient;
};

#endif
