/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include "global.h"

#include <qfile.h>
#include <qregexp.h>

#include <kstandarddirs.h>
#include <kservice.h>

#include <kio/netaccess.h>

Position directionToPosition( Direction d )
{
    switch( d ) {
    case ::dDown:   return ::Top;
    case ::dLeft:   return ::Right;
    case ::dRight:  return ::Left;
    default:
    case ::dUp:     return ::Bottom;
    }
}

Direction positionToDirection( Position p )
{
    switch( p ) {
    case ::Top:     return ::dDown;
    case ::Right:   return ::dLeft;
    case ::Left:    return ::dRight;
    default:
    case ::Bottom:  return ::dUp;
    }
}

int sizeValue(Size s)
{
    switch(s) {
        case Tiny:
            return 24;
        case Small:
            return 30;
        case Normal:
            return 46;
        case Large:
        default:
            return 58;
    }
}

QString newDesktopFile(const KURL& url)
{
   QString base = url.fileName();
   if (base.endsWith(".desktop"))
      base.truncate(base.length()-8);
   QRegExp r("(.*)(?=-\\d+)");
   if (r.search(base) > -1)
      base = r.cap(1);

   QString file = base + ".desktop";
 
   for(int n = 1; ++n; )
   {
      QString path = locate("appdata", file);
      if (path.isEmpty())
         break;
         
      file = QString("%2-%1.desktop").arg(n).arg(base);
   }
   file = locateLocal("appdata", file);
   return file;
}

QString copyDesktopFile(const KURL& url)
{
   QString file = newDesktopFile(url);
   KURL dest;
   dest.setPath(file);
   KIO::NetAccess::upload(url.path(), dest, 0);
   return file;   
}
