<%@page contentType="text/xml"%><%@page pageEncoding="UTF-8"%><%
// ----------------------------------------------------------------------------------------------------
// Sample web page to generate and update TreeGrid data, using TreeGrid.dll
// This page can be used as data source for examples, use Examples/Main/Examples.html?src=../Jsp/SrcPage.jsp
// TreeGrid.dll must be placed in the ../../Server/ directory, or the path must be changed in Sample() function
// Uses data from ../Data/ directory, or the path must be changed in GetIndex() function
// Shows server paging features
// ----------------------------------------------------------------------------------------------------
class Sample {
TreeGrid.Server T;
String Path;
HttpServletRequest request;

// ----------------------------------------------------------------------------------------------------
Sample(String path, HttpServletRequest req) {
Path = path; request = req;
T = new TreeGrid.Server(Path+"../../Server/TreeGrid");
}

// ----------------------------------------------------------------------------------------------------
// Returns Xml with given error message
private String Error(int num, String mess){
if(T.Loaded){
   String Err = T.LastError();
   if(Err!=null) mess = mess+"&#x0A;&#x0A;"+Err.replaceAll("\\&","&amp;").replaceAll("\\<","&lt;").replaceAll("\\\"","&quot;");
   }
return "<Grid><IO Result=\""+num+"\" Message=\""+mess+"\"/></Grid>";
}
// ----------------------------------------------------------------------------------------------------
// Returns Grids index for given file or <0 for error
private int GetIndex(String File, String Def, String Cfg, String Bonus){
if(File==null || File.equals("")) return -1;
int Index = T.FindGrid(Cfg);
if (Index >= 0){ 
   T.UpdateGrid(Index,Bonus);
   return Index;
   }
String ID = request.getRemoteHost()+File;
java.io.File F = new java.io.File(Path+"tmp/"+ID);
if(F.exists()) return T.CreateGrid(Path+"tmp\\"+ID,Path+Def,Path+"..\\..\\Grid\\Defaults.xml",Path+"..\\..\\Grid\\Text.xml",Bonus,null);
else return T.CreateGrid(Path+File,Path+Def,Path+"..\\..\\Grid\\Defaults.xml",Path+"..\\..\\Grid\\Text.xml",Bonus,null);
}
// ----------------------------------------------------------------------------------------------------
// Returns grid data, for Paging==3 returns only empty pages with information about their content
// Data contains XML with grid settings - sorting and filters
private String FuncLoadBody(String File, String Def, String Data, String Bonus) {
int Index = GetIndex(File,Def,Data,Bonus);
if(Index<0) return Error(-1,"Server DLL Error: TreeGrid XML data not found or server has not permission to read them&#x0A;Data are located at /Examples/ServerDLL/");
String Ret = T.GetBody(Index,Data);
if(Ret==null) return Error(-4,"Server DLL Error: TreeGrid XML data cannot be loaded");
String ID = request.getRemoteHost()+File;
T.SaveToFile(Index, Path+"tmp\\"+ID, 0);
return Ret;
}
// ----------------------------------------------------------------------------------------------------
// Returns children of one page or one row
// Data contains XML with page index or row id and grid settings - sorting and filters
private String FuncLoadPage(String File, String Def, String Data, String Bonus) {
int Index = GetIndex(File,Def,Data,Bonus);
if(Index < 0) return Error(-1, "Server DLL Error: TreeGrid XML data not found");
String Ret = T.GetPage(Index,Data);
if(Ret==null) return Error(-3,"Server DLL Error: Configuration changed, you need to reload grid!");
return Ret;
}
// ----------------------------------------------------------------------------------------------------
// Saves changed data to XML file
// Data contains XML with changed rows
private String FuncSave(String File, String Def, String Data, String Bonus) {
int Index = GetIndex(File,Def,Data,Bonus);
if(Index < 0) return Error(-1, "Server DLL Error: TreeGrid XML data not found");
int Ret = T.Save(Index,Data);
if(Ret < 0) return Error(Ret, "Server DLL Error: Changes were not saved");
String ID = request.getRemoteHost()+File;
T.SaveToFile(Index, Path + "tmp\\" + ID, 0);
if(Ret > 0) return Error(0, "Server DLL Warning: Not all data were successfully saved !");
return "<Grid><IO Result=\"0\"/></Grid>";
}
// ----------------------------------------------------------------------------------------------------
}; // end of class Sample
// ----------------------------------------------------------------------------------------------------
Sample S = new Sample(application.getRealPath(request.getServletPath().replaceAll("[^\\/\\\\]*[\\/][^\\/\\\\]*$","")+"ServerDLL")+"/",request);
if(!TreeGrid.Server.Loaded) out.print(S.Error(-5, TreeGrid.Server.DllError));
else try {
   String F = request.getParameter("Function"); if(F==null) F="";
   if(F.equalsIgnoreCase("LoadBody")) out.print(S.FuncLoadBody(request.getParameter("File"), request.getParameter("Def"), request.getParameter("Data"), request.getParameter("Bonus"))); 
   else if(F.equalsIgnoreCase("LoadPage")) out.print(S.FuncLoadPage(request.getParameter("File"), request.getParameter("Def"), request.getParameter("Data"), request.getParameter("Bonus"))); 
   else if(F.equalsIgnoreCase("Save")) out.print(S.FuncSave(request.getParameter("File"), request.getParameter("Def"), request.getParameter("Data"), request.getParameter("Bonus"))); 
   else out.print(S.Error(-3, "Wrong function requested"));
   }
catch(Exception ex){
   out.print(S.Error(-3, ex.getMessage()));
   }
%>
