/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.jmx;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.TypeUtil;

public class ModelMBeanImpl
implements ModelMBean,
MBeanRegistration {
    private static Log log = LogFactory.getLog((Class)ModelMBeanImpl.class);
    public static final int IMPACT_ACTION = 1;
    public static final int IMPACT_ACTION_INFO = 2;
    public static final int IMPACT_INFO = 0;
    public static final int IMPACT_UNKOWN = 3;
    public static final String STRING = "java.lang.String";
    public static final String OBJECT = "java.lang.Object";
    public static final String INT = "int";
    public static final String[] NO_PARAMS = new String[0];
    public static final boolean READ_WRITE = true;
    public static final boolean READ_ONLY = false;
    public static final boolean ON_MBEAN = true;
    public static final boolean ON_OBJECT = false;
    private static HashMap __objectId = new HashMap();
    private static String __defaultDomain = "org.mortbay";
    protected ModelMBeanInfoSupport _beanInfo;
    private MBeanServer _mBeanServer;
    private Object _object;
    private ObjectName _objectName;
    private boolean _dirty = false;
    private HashMap _getter = new HashMap(4);
    private HashMap _setter = new HashMap(4);
    private HashMap _method = new HashMap(4);
    private ArrayList _attributes = new ArrayList(4);
    private ArrayList _operations = new ArrayList(4);
    private ArrayList _notifications = new ArrayList(4);
    private String _baseObjectName = null;
    private Map _components = new HashMap(4);

    public static ModelMBean mbeanFor(Object object) {
        try {
            Class<?> clazz = object.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            ModelMBean modelMBean = null;
            boolean bl = false;
            Class<?>[] classArray = null;
            int n = 0;
            while (modelMBean == null && clazz != null) {
                Class<?> clazz2 = classArray == null ? clazz : classArray[n];
                String string = clazz2.getPackage().getName();
                String string2 = clazz2.getName().substring(string.length() + 1);
                String string3 = string + (bl ? ".jmx." : ".") + string2 + "MBean";
                try {
                    Class<?> clazz3 = classLoader.loadClass(string3);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("mbeanFor " + object + " mClass=" + clazz3));
                    }
                    modelMBean = (ModelMBean)clazz3.newInstance();
                    modelMBean.setManagedResource(object, "objectReference");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("mbeanFor " + object + " is " + modelMBean));
                    }
                    return modelMBean;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (classNotFoundException.toString().endsWith("MBean")) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)classNotFoundException.toString());
                        }
                    } else {
                        log.warn((Object)"EXCEPTION ", (Throwable)classNotFoundException);
                    }
                }
                catch (Error error) {
                    log.warn((Object)"EXCEPTION ", (Throwable)error);
                    modelMBean = null;
                }
                catch (Exception exception) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                    modelMBean = null;
                }
                if (bl) {
                    if (classArray != null) {
                        if (++n >= classArray.length) {
                            classArray = null;
                            clazz = clazz.getSuperclass();
                        }
                    } else {
                        classArray = clazz.getInterfaces();
                        n = 0;
                        if (classArray == null || classArray.length == 0) {
                            classArray = null;
                            clazz = clazz.getSuperclass();
                        }
                    }
                }
                bl = !bl;
            }
        }
        catch (Exception exception) {
            LogSupport.ignore((Log)log, (Throwable)exception);
        }
        return null;
    }

    public ModelMBeanImpl() {
    }

    public ModelMBeanImpl(Object object) {
        try {
            this.setManagedResource(object, "objectReference");
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public static String getDefaultDomain() {
        return __defaultDomain;
    }

    public static void setDefaultDomain(String string) {
        __defaultDomain = string;
    }

    public MBeanServer getMBeanServer() {
        return this._mBeanServer;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public Object getManagedResource() {
        return this._object;
    }

    public void setManagedResource(Object object, String string) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (object == null) {
            object = null;
            return;
        }
        log.debug((Object)"setManagedResource");
        if (!"objectreference".equalsIgnoreCase(string)) {
            throw new InvalidTargetObjectTypeException(string);
        }
        if (this._object == null) {
            this._object = object;
            this.defineManagedResource();
        } else {
            this._object = object;
        }
    }

    protected void defineManagedResource() {
    }

    public void setModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        throw new Error("setModelMBeanInfo not supported");
    }

    public synchronized void defineAttribute(String string) {
        this.defineAttribute(string, true, false);
    }

    public synchronized void defineAttribute(String string, boolean bl) {
        this.defineAttribute(string, bl, false);
    }

    public synchronized void defineAttribute(String string, boolean bl, boolean bl2) {
        this._dirty = true;
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        string = Introspector.decapitalize(string);
        Class<?> clazz = bl2 ? this.getClass() : this._object.getClass();
        Class<?> clazz2 = null;
        Method method = null;
        Method method2 = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if ((methodArray[i].getModifiers() & 1) == 0) continue;
            if (methodArray[i].getName().equals("get" + string2) && methodArray[i].getParameterTypes().length == 0) {
                if (method != null) {
                    throw new IllegalArgumentException("Multiple getters for attr " + string);
                }
                method = methodArray[i];
                if (clazz2 != null && !clazz2.equals(methodArray[i].getReturnType())) {
                    throw new IllegalArgumentException("Type conflict for attr " + string);
                }
                clazz2 = methodArray[i].getReturnType();
            }
            if (methodArray[i].getName().equals("is" + string2) && methodArray[i].getParameterTypes().length == 0) {
                if (method != null) {
                    throw new IllegalArgumentException("Multiple getters for attr " + string);
                }
                method = methodArray[i];
                if (clazz2 != null && !clazz2.equals(methodArray[i].getReturnType())) {
                    throw new IllegalArgumentException("Type conflict for attr " + string);
                }
                clazz2 = methodArray[i].getReturnType();
            }
            if (!bl || !methodArray[i].getName().equals("set" + string2) || methodArray[i].getParameterTypes().length != 1) continue;
            if (method2 != null) {
                throw new IllegalArgumentException("Multiple setters for attr " + string);
            }
            method2 = methodArray[i];
            if (clazz2 != null && !clazz2.equals(methodArray[i].getParameterTypes()[0])) {
                throw new IllegalArgumentException("Type conflict for attr " + string);
            }
            clazz2 = methodArray[i].getParameterTypes()[0];
        }
        if (method == null && method2 == null) {
            throw new IllegalArgumentException("No getter or setters found for " + string);
        }
        try {
            this._getter.put(string, method);
            this._setter.put(string, method2);
            this._attributes.add(new ModelMBeanAttributeInfo(string, this.findDescription(string), method, method2));
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public synchronized void defineAttribute(ModelMBeanAttributeInfo modelMBeanAttributeInfo) {
        if (this._object == null) {
            throw new IllegalStateException("No Object");
        }
        this._dirty = true;
        String string = modelMBeanAttributeInfo.getName();
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        Class<?> clazz = this._object.getClass();
        try {
            Class<?> clazz2 = TypeUtil.fromName((String)modelMBeanAttributeInfo.getType());
            if (clazz2 == null) {
                clazz2 = Thread.currentThread().getContextClassLoader().loadClass(modelMBeanAttributeInfo.getType());
            }
            Method method = null;
            Method method2 = null;
            if (modelMBeanAttributeInfo.isReadable()) {
                method = clazz.getMethod((modelMBeanAttributeInfo.isIs() ? "is" : "get") + string2, null);
            }
            if (modelMBeanAttributeInfo.isWritable()) {
                method2 = clazz.getMethod("set" + string2, clazz2);
            }
            this._getter.put(string, method);
            this._setter.put(string, method2);
            this._attributes.add(modelMBeanAttributeInfo);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public synchronized void defineOperation(String string, int n) {
        this.defineOperation(string, null, n, false);
    }

    public synchronized void defineOperation(String string, String[] stringArray, int n) {
        this.defineOperation(string, stringArray, n, false);
    }

    public synchronized void defineOperation(String string, String[] stringArray, int n, boolean bl) {
        Class<?> clazz;
        this._dirty = true;
        Class<?> clazz2 = clazz = bl ? this.getClass() : this._object.getClass();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        try {
            Object object;
            int n2;
            Class[] classArray = new Class[stringArray.length];
            MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[stringArray.length];
            String string2 = string + "(";
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object = TypeUtil.fromName((String)stringArray[n2]);
                if (object == null) {
                    object = Thread.currentThread().getContextClassLoader().loadClass(stringArray[n2]);
                }
                classArray[n2] = object;
                stringArray[n2] = ((Class)object).isPrimitive() ? TypeUtil.toName(object) : stringArray[n2];
                string2 = string2 + (n2 > 0 ? "," : "") + stringArray[n2];
            }
            string2 = string2 + ")";
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object = this.findDescription(string2 + "[" + n2 + "]");
                int n3 = ((String)object).indexOf(":");
                if (n3 < 0) {
                    object = "param" + n2 + ":" + (String)object;
                    n3 = ((String)object).indexOf(":");
                }
                mBeanParameterInfoArray[n2] = new MBeanParameterInfo(((String)object).substring(0, n3).trim(), stringArray[n2], ((String)object).substring(n3 + 1).trim());
            }
            Method method = clazz.getMethod(string, classArray);
            object = method.getReturnType();
            this._method.put(string2, method);
            this._operations.add(new ModelMBeanOperationInfo(string, this.findDescription(string2), mBeanParameterInfoArray, ((Class)object).isPrimitive() ? TypeUtil.toName((Class)object) : ((Class)object).getName(), n));
        }
        catch (Exception exception) {
            log.warn((Object)("operation " + string), (Throwable)exception);
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public synchronized void defineOperation(ModelMBeanOperationInfo modelMBeanOperationInfo) {
        this._dirty = true;
        Class<?> clazz = this._object.getClass();
        try {
            MBeanParameterInfo[] mBeanParameterInfoArray = modelMBeanOperationInfo.getSignature();
            Class[] classArray = new Class[mBeanParameterInfoArray.length];
            String string = modelMBeanOperationInfo.getName() + "(";
            for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
                Class<?> clazz2 = TypeUtil.fromName((String)mBeanParameterInfoArray[i].getType());
                if (clazz2 == null) {
                    clazz2 = Thread.currentThread().getContextClassLoader().loadClass(mBeanParameterInfoArray[i].getType());
                }
                classArray[i] = clazz2;
                string = string + (i > 0 ? "," : "") + mBeanParameterInfoArray[i].getType();
            }
            string = string + ")";
            this._method.put(string, clazz.getMethod(modelMBeanOperationInfo.getName(), classArray));
            this._operations.add(modelMBeanOperationInfo);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public synchronized MBeanInfo getMBeanInfo() {
        log.debug((Object)"getMBeanInfo");
        if (this._dirty) {
            this._dirty = false;
            ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = this._attributes.toArray(new ModelMBeanAttributeInfo[this._attributes.size()]);
            ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = this._operations.toArray(new ModelMBeanOperationInfo[this._operations.size()]);
            ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = this._notifications.toArray(new ModelMBeanNotificationInfo[this._notifications.size()]);
            this._beanInfo = new ModelMBeanInfoSupport(this._object.getClass().getName(), this.findDescription(null), modelMBeanAttributeInfoArray, null, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray);
        }
        return this._beanInfo;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method method;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttribute " + string));
        }
        if ((method = (Method)this._getter.get(string)) == null) {
            throw new AttributeNotFoundException(string);
        }
        try {
            Object object = this._object;
            if (method.getDeclaringClass().isInstance(this)) {
                object = this;
            }
            return method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)"EXCEPTION ", (Throwable)illegalAccessException);
            throw new AttributeNotFoundException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            log.warn((Object)"EXCEPTION ", (Throwable)invocationTargetException);
            throw new ReflectionException((Exception)invocationTargetException.getTargetException());
        }
    }

    public AttributeList getAttributes(String[] stringArray) {
        log.debug((Object)"getAttributes");
        AttributeList attributeList = new AttributeList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                attributeList.add(new Attribute(stringArray[i], this.getAttribute(stringArray[i])));
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        return attributeList;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method method;
        if (attribute == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAttribute " + attribute.getName() + "=" + attribute.getValue()));
        }
        if ((method = (Method)this._setter.get(attribute.getName())) == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        try {
            Object object = this._object;
            if (method.getDeclaringClass().isInstance(this)) {
                object = this;
            }
            method.invoke(object, attribute.getValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)"EXCEPTION ", (Throwable)illegalAccessException);
            throw new AttributeNotFoundException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            log.warn((Object)"EXCEPTION ", (Throwable)invocationTargetException);
            throw new ReflectionException((Exception)invocationTargetException.getTargetException());
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        log.debug((Object)"setAttributes");
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            try {
                Attribute attribute = (Attribute)iterator.next();
                this.setAttribute(attribute);
                attributeList2.add(new Attribute(attribute.getName(), this.getAttribute(attribute.getName())));
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        return attributeList2;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke " + string));
        }
        String string2 = string + "(";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + (i > 0 ? "," : "") + stringArray[i];
            }
        }
        string2 = string2 + ")";
        try {
            Method method = (Method)this._method.get(string2);
            if (method == null) {
                throw new NoSuchMethodException(string2);
            }
            Object object = this._object;
            if (method.getDeclaringClass().isInstance(this)) {
                object = this;
            }
            return method.invoke(object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.warn((Object)"EXCEPTION ", (Throwable)noSuchMethodException);
            throw new ReflectionException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)"EXCEPTION ", (Throwable)illegalAccessException);
            throw new MBeanException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.warn((Object)"EXCEPTION ", (Throwable)invocationTargetException);
            throw new ReflectionException((Exception)invocationTargetException.getTargetException());
        }
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        log.debug((Object)"load");
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        log.debug((Object)"store");
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        log.debug((Object)"addNotificationListener");
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        log.debug((Object)"getNotificationInfo");
        return null;
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        log.debug((Object)"removeNotificationListener");
    }

    public void addAttributeChangeNotificationListener(NotificationListener notificationListener, String string, Object object) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        log.debug((Object)"addAttributeChangeNotificationListener");
    }

    public void removeAttributeChangeNotificationListener(NotificationListener notificationListener, String string) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        log.debug((Object)"removeAttributeChangeNotificationListener");
    }

    public void sendAttributeChangeNotification(Attribute attribute, Attribute attribute2) throws MBeanException, RuntimeOperationsException {
        log.debug((Object)"sendAttributeChangeNotification");
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification attributeChangeNotification) throws MBeanException, RuntimeOperationsException {
        log.debug((Object)"sendAttributeChangeNotification");
    }

    public void sendNotification(String string) throws MBeanException, RuntimeOperationsException {
        log.debug((Object)"sendNotification");
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        log.debug((Object)"sendNotification");
    }

    private String findDescription(String string) {
        Class<?> clazz = this.getClass();
        String[] stringArray = new String[3];
        stringArray[0] = this._object.getClass().getName();
        if (stringArray[0].indexOf(".") >= 0) {
            stringArray[1] = stringArray[0].substring(stringArray[0].lastIndexOf(".") + 1);
        }
        while (clazz != null) {
            block14: {
                String string2;
                String string3 = clazz.getName();
                int n = string3.lastIndexOf(".");
                if (n > 0) {
                    stringArray[2] = string3.substring(n + 1);
                    string3 = string3.substring(0, n);
                } else {
                    stringArray[2] = string3;
                    string3 = null;
                }
                String string4 = string2 = string3 == null ? "mbean" : string3.replace('.', '/') + "/mbean";
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Look for: " + string2));
                }
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), this._object.getClass().getClassLoader());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Bundle " + string2));
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string5 = stringArray[i];
                        if (string5 == null) continue;
                        if (string5.endsWith("MBean")) {
                            string5 = string5.substring(0, string5.length() - 5);
                        }
                        if (string != null && string.length() > 0) {
                            string5 = string5 + "." + string;
                        }
                        try {
                            String string6 = resourceBundle.getString(string5);
                            if (string6 == null || string6.length() <= 0) continue;
                            return string6;
                        }
                        catch (Exception exception) {
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)exception.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    if (!log.isTraceEnabled()) break block14;
                    log.trace((Object)exception.toString());
                }
            }
            clazz = clazz.getSuperclass();
        }
        if (string == null || string.length() == 0) {
            return stringArray[0];
        }
        return string;
    }

    protected ObjectName newObjectName(MBeanServer mBeanServer) {
        if (this._baseObjectName != null) {
            if (this._baseObjectName.indexOf(58) >= 0) {
                return this.uniqueObjectName(mBeanServer, this._baseObjectName);
            }
            return this.uniqueObjectName(mBeanServer, ModelMBeanImpl.getDefaultDomain() + ":" + this._baseObjectName);
        }
        return this.uniqueObjectName(mBeanServer, ModelMBeanImpl.getDefaultDomain() + ":");
    }

    public void setBaseObjectName(String string) {
        this._baseObjectName = string;
    }

    public String getBaseObjectName() {
        return this._baseObjectName;
    }

    public synchronized ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this._mBeanServer = mBeanServer;
        this._objectName = objectName;
        if (this._objectName == null) {
            try {
                objectName = this.newObjectName(mBeanServer);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("preRegister " + this._objectName + " -> " + objectName));
        }
        this._objectName = objectName;
        return this._objectName;
    }

    public void postRegister(Boolean bl) {
        if (bl.booleanValue()) {
            log.info((Object)("Registered " + this._objectName));
        } else {
            this._mBeanServer = null;
            this._objectName = null;
        }
    }

    public void preDeregister() {
        log.info((Object)("Deregister " + this._objectName));
        this.getComponentMBeans(null, this._components);
        this._components.clear();
    }

    public void postDeregister() {
        this._beanInfo = null;
        this._mBeanServer = null;
        this._object = null;
        this._objectName = null;
        if (this._getter != null) {
            this._getter.clear();
        }
        this._getter = null;
        if (this._setter != null) {
            this._setter.clear();
        }
        this._setter = null;
        if (this._method != null) {
            this._method.clear();
        }
        this._method = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._attributes = null;
        if (this._operations != null) {
            this._operations.clear();
        }
        this._operations = null;
        if (this._notifications != null) {
            this._notifications.clear();
        }
        this._notifications = null;
    }

    public synchronized ObjectName uniqueObjectName(MBeanServer mBeanServer, String string) {
        return this.uniqueObjectName(mBeanServer, this._object, string);
    }

    public synchronized ObjectName uniqueObjectName(MBeanServer mBeanServer, Object object, String string) {
        Object object2;
        if (!string.endsWith("=")) {
            object2 = object.getClass().getName();
            if (((String)object2).indexOf(".") > 0) {
                object2 = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
            }
            if (((String)object2).endsWith("MBean")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 5);
            }
            if (!string.endsWith(":")) {
                string = string + ",";
            }
            string = string + (String)object2 + "=";
        }
        object2 = null;
        try {
            do {
                Integer n;
                if ((n = (Integer)__objectId.get(string)) == null) {
                    n = new Integer(0);
                }
                object2 = new ObjectName(string + n);
                n = new Integer(n + 1);
                __objectId.put(string, n);
            } while (mBeanServer != null && mBeanServer.isRegistered((ObjectName)object2));
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        return object2;
    }

    protected ObjectName[] getComponentMBeans(Object[] objectArray, Map map) {
        Object object;
        if (map == null) {
            map = this._components;
        }
        ObjectName[] objectNameArray = null;
        if (objectArray == null) {
            objectNameArray = new ObjectName[]{};
        } else {
            objectNameArray = new ObjectName[objectArray == null ? 0 : objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                ObjectName objectName = (ObjectName)map.get(objectArray[i]);
                if (objectName == null) {
                    object = ModelMBeanImpl.mbeanFor(objectArray[i]);
                    if (object == null) {
                        log.warn((Object)("No mbean for " + objectArray[i]));
                    } else {
                        try {
                            if (object instanceof ModelMBeanImpl) {
                                ((ModelMBeanImpl)object).setBaseObjectName(this.getObjectName().toString());
                                objectName = this.getMBeanServer().registerMBean(object, null).getObjectName();
                            } else {
                                objectName = this.uniqueObjectName(this.getMBeanServer(), objectArray[i], this.getObjectName().toString());
                                objectName = this.getMBeanServer().registerMBean(object, objectName).getObjectName();
                            }
                            map.put(objectArray[i], objectName);
                        }
                        catch (Exception exception) {
                            log.warn((Object)"EXCEPTION ", (Throwable)exception);
                        }
                    }
                }
                objectNameArray[i] = objectName;
            }
        }
        if (objectArray == null || map.size() > objectArray.length) {
            Object[] objectArray2 = new Object[map.size() - objectNameArray.length];
            int n = 0;
            object = map.keySet().iterator();
            block5: while (object.hasNext()) {
                Object k = object.next();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == k) continue block5;
                    }
                }
                objectArray2[n++] = k;
            }
            while (n-- > 0) {
                try {
                    this.getMBeanServer().unregisterMBean((ObjectName)map.remove(objectArray2[n]));
                }
                catch (Exception exception) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                }
            }
        }
        return objectNameArray;
    }

    protected void destroyComponentMBeans(Map map) {
        if (null == map) {
            map = this._components;
        }
        if (map == null) {
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            try {
                ObjectName objectName = (ObjectName)iterator.next();
                this.getMBeanServer().unregisterMBean(objectName);
                iterator.remove();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
    }
}

