/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.jmx;

import java.util.EventListener;
import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.RequestLog;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LifeCycleEvent;
import org.mortbay.util.LifeCycleListener;
import org.mortbay.util.jmx.LifeCycleMBean;

public class HttpContextMBean
extends LifeCycleMBean {
    private static Log log = LogFactory.getLog((Class)HttpContextMBean.class);
    private HttpContext _httpContext;
    private HashMap _rlMap = new HashMap(3);
    private HashMap _handlerMap = new HashMap();

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("virtualHosts");
        this.defineAttribute("hosts");
        this.defineAttribute("contextPath");
        this.defineAttribute("handlers", false, true);
        this.defineAttribute("requestLog", false, true);
        this.defineAttribute("classPath");
        this.defineAttribute("realm");
        this.defineAttribute("realmName");
        this.defineAttribute("redirectNullPath");
        this.defineAttribute("resourceBase");
        this.defineAttribute("maxCachedFileSize");
        this.defineAttribute("maxCacheSize");
        this.defineOperation("flushCache", 1);
        this.defineOperation("getResource", new String[]{"java.lang.String"}, 1);
        this.defineAttribute("welcomeFiles");
        this.defineOperation("addWelcomeFile", new String[]{"java.lang.String"}, 0);
        this.defineOperation("removeWelcomeFile", new String[]{"java.lang.String"}, 0);
        this.defineAttribute("mimeMap");
        this.defineOperation("setMimeMapping", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineAttribute("statsOn");
        this.defineAttribute("statsOnMs");
        this.defineOperation("statsReset", 1);
        this.defineAttribute("requests");
        this.defineAttribute("requestsActive");
        this.defineAttribute("requestsActiveMax");
        this.defineAttribute("responses1xx");
        this.defineAttribute("responses2xx");
        this.defineAttribute("responses3xx");
        this.defineAttribute("responses4xx");
        this.defineAttribute("responses5xx");
        this.defineOperation("stop", new String[]{"java.lang.Boolean.TYPE"}, 1);
        this.defineOperation("destroy", 1);
        this.defineOperation("setInitParameter", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("getInitParameter", new String[]{"java.lang.String"}, 0);
        this.defineOperation("getInitParameterNames", NO_PARAMS, 0);
        this.defineOperation("setAttribute", new String[]{"java.lang.String", "java.lang.Object"}, 1);
        this.defineOperation("getAttribute", new String[]{"java.lang.String"}, 0);
        this.defineOperation("getAttributeNames", NO_PARAMS, 0);
        this.defineOperation("removeAttribute", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addHandler", new String[]{"org.mortbay.http.HttpHandler"}, 1);
        this.defineOperation("addHandler", new String[]{"int", "org.mortbay.http.HttpHandler"}, 1);
        this.defineOperation("removeHandler", new String[]{"int"}, 1);
        this._httpContext = (HttpContext)this.getManagedResource();
        this._httpContext.addEventListener((EventListener)new LifeCycleListener(){

            public void lifeCycleStarting(LifeCycleEvent lifeCycleEvent) {
            }

            public void lifeCycleStarted(LifeCycleEvent lifeCycleEvent) {
                HttpContextMBean.this.getHandlers();
            }

            public void lifeCycleFailure(LifeCycleEvent lifeCycleEvent) {
            }

            public void lifeCycleStopping(LifeCycleEvent lifeCycleEvent) {
            }

            public void lifeCycleStopped(LifeCycleEvent lifeCycleEvent) {
                HttpContextMBean.this.destroyHandlers();
            }
        });
    }

    protected ObjectName newObjectName(MBeanServer mBeanServer) {
        ObjectName objectName = super.newObjectName(mBeanServer);
        String string = this._httpContext.getContextPath();
        if (string.length() == 0) {
            string = "/";
        }
        try {
            objectName = new ObjectName(objectName + ",context=" + string);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        return objectName;
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        if (bl.booleanValue()) {
            this.getHandlers();
        }
    }

    public void postDeregister() {
        this._httpContext = null;
        this.destroyComponentMBeans(this._handlerMap);
        super.postDeregister();
    }

    public ObjectName[] getHandlers() {
        return this.getComponentMBeans(this._httpContext.getHandlers(), this._handlerMap);
    }

    public void destroyHandlers() {
        this.destroyComponentMBeans(this._handlerMap);
    }

    public ObjectName getRequestLog() {
        RequestLog requestLog = this._httpContext.getRequestLog();
        if (requestLog == null) {
            return null;
        }
        ObjectName[] objectNameArray = this.getComponentMBeans(new Object[]{requestLog}, this._rlMap);
        if (objectNameArray.length > 0) {
            return objectNameArray[0];
        }
        return null;
    }
}

