/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.LogSupport;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private static Log log = LogFactory.getLog(XmlParser.class);
    private Map _redirectMap = new HashMap();
    private SAXParser _parser;
    private String _xpath;
    private Object _xpaths;

    public XmlParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            boolean bl = Boolean.getBoolean("org.mortbay.xml.XmlParser.NotValidating");
            sAXParserFactory.setValidating(!bl);
            this._parser = sAXParserFactory.newSAXParser();
            try {
                if (!bl) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", true);
                }
            }
            catch (Exception exception) {
                log.warn((Object)"Schema validation may not be supported");
                log.debug((Object)"", (Throwable)exception);
                bl = true;
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", !bl);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", !bl);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", !bl);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new Error(exception.toString());
        }
    }

    public XmlParser(boolean bl) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            this._parser = sAXParserFactory.newSAXParser();
            try {
                if (bl) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", bl);
                }
            }
            catch (Exception exception) {
                if (bl) {
                    log.warn((Object)"Schema validation may not be supported: ", (Throwable)exception);
                }
                LogSupport.ignore(log, exception);
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", bl);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", bl);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", bl);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new Error(exception.toString());
        }
    }

    public synchronized void redirectEntity(String string, URL uRL) {
        if (uRL != null) {
            this._redirectMap.put(string, uRL);
        }
    }

    public String getXpath() {
        return this._xpath;
    }

    public void setXpath(String string) {
        this._xpath = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "| ");
        while (stringTokenizer.hasMoreTokens()) {
            this._xpaths = LazyList.add(this._xpaths, stringTokenizer.nextToken());
        }
    }

    public synchronized Node parse(InputSource inputSource) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader xMLReader = this._parser.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsing: sid=" + inputSource.getSystemId() + ",pid=" + inputSource.getPublicId()));
        }
        this._parser.parse(inputSource, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    public synchronized Node parse(String string) throws IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse: " + string));
        }
        return this.parse(new InputSource(string));
    }

    public synchronized Node parse(File file) throws IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse: " + file));
        }
        return this.parse(new InputSource(file.toURL().toString()));
    }

    public synchronized Node parse(InputStream inputStream) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader xMLReader = this._parser.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        this._parser.parse(new InputSource(inputStream), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node parse(URL uRL) throws IOException, SAXException {
        Node node = null;
        InputStream inputStream = uRL.openStream();
        try {
            node = this.parse(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return node;
    }

    public static class Node
    extends AbstractList {
        Node _parent;
        private ArrayList _list;
        private String _tag;
        private Attribute[] _attrs;
        private boolean _lastString = false;
        private String _path;

        Node(Node node, String string, Attributes attributes) {
            this._parent = node;
            this._tag = string;
            if (attributes != null) {
                this._attrs = new Attribute[attributes.getLength()];
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getLocalName(i);
                    if (string2 == null || string2.equals("")) {
                        string2 = attributes.getQName(i);
                    }
                    this._attrs[i] = new Attribute(string2, attributes.getValue(i));
                }
            }
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public String getPath() {
            if (this._path == null) {
                this._path = this.getParent() != null && this.getParent().getTag() != null ? this.getParent().getPath() + "/" + this._tag : "/" + this._tag;
            }
            return this._path;
        }

        public Attribute[] getAttributes() {
            return this._attrs;
        }

        public String getAttribute(String string) {
            return this.getAttribute(string, null);
        }

        public String getAttribute(String string, String string2) {
            if (this._attrs == null || string == null) {
                return string2;
            }
            for (int i = 0; i < this._attrs.length; ++i) {
                if (!string.equals(this._attrs[i].getName())) continue;
                return this._attrs[i].getValue();
            }
            return string2;
        }

        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            return 0;
        }

        public Object get(int n) {
            if (this._list != null) {
                return this._list.get(n);
            }
            return null;
        }

        public Node get(String string) {
            if (this._list != null) {
                for (int i = 0; i < this._list.size(); ++i) {
                    Object e = this._list.get(i);
                    if (!(e instanceof Node)) continue;
                    Node node = (Node)e;
                    if (!string.equals(node._tag)) continue;
                    return node;
                }
            }
            return null;
        }

        public void add(int n, Object object) {
            if (this._list == null) {
                this._list = new ArrayList();
            }
            if (object instanceof String) {
                if (this._lastString) {
                    int n2 = this._list.size() - 1;
                    this._list.set(n2, (String)this._list.get(n2) + object);
                } else {
                    this._list.add(n, object);
                }
                this._lastString = true;
            } else {
                this._lastString = false;
                this._list.add(n, object);
            }
        }

        public void clear() {
            if (this._list != null) {
                this._list.clear();
            }
            this._list = null;
        }

        public String getString(String string, boolean bl, boolean bl2) {
            Node node = this.get(string);
            if (node == null) {
                return null;
            }
            String string2 = node.toString(bl);
            if (string2 != null && bl2) {
                string2 = string2.trim();
            }
            return string2;
        }

        public synchronized String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString(boolean bl) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
            synchronized (stringBuffer2) {
                this.toString(stringBuffer, bl);
                return stringBuffer.toString();
            }
        }

        public synchronized String toString(boolean bl, boolean bl2) {
            String string = this.toString(bl);
            if (string != null && bl2) {
                string = string.trim();
            }
            return string;
        }

        private synchronized void toString(StringBuffer stringBuffer, boolean bl) {
            int n;
            if (bl) {
                stringBuffer.append("<");
                stringBuffer.append(this._tag);
                if (this._attrs != null) {
                    for (n = 0; n < this._attrs.length; ++n) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this._attrs[n].getName());
                        stringBuffer.append("=\"");
                        stringBuffer.append(this._attrs[n].getValue());
                        stringBuffer.append("\"");
                    }
                }
            }
            if (this._list != null) {
                if (bl) {
                    stringBuffer.append(">");
                }
                for (n = 0; n < this._list.size(); ++n) {
                    Object e = this._list.get(n);
                    if (e == null) continue;
                    if (e instanceof Node) {
                        ((Node)e).toString(stringBuffer, bl);
                        continue;
                    }
                    stringBuffer.append(e.toString());
                }
                if (bl) {
                    stringBuffer.append("</");
                    stringBuffer.append(this._tag);
                    stringBuffer.append(">");
                }
            } else if (bl) {
                stringBuffer.append("/>");
            }
        }

        public Iterator iterator(String string) {
            return new Iterator(this, string){
                int c;
                Node _node;
                private final /* synthetic */ String val$tag;
                private final /* synthetic */ Node this$0;
                {
                    this.this$0 = node;
                    this.val$tag = string;
                    this.c = 0;
                }

                public boolean hasNext() {
                    if (this._node != null) {
                        return true;
                    }
                    while (Node.access$400(this.this$0) != null && this.c < Node.access$400(this.this$0).size()) {
                        Node node;
                        E e = Node.access$400(this.this$0).get(this.c);
                        if (e instanceof Node && this.val$tag.equals(Node.access$500(node = (Node)e))) {
                            this._node = node;
                            return true;
                        }
                        ++this.c;
                    }
                    return false;
                }

                public Object next() {
                    try {
                        if (this.hasNext()) {
                            Node node = this._node;
                            return node;
                        }
                        throw new NoSuchElementException();
                    }
                    finally {
                        this._node = null;
                        ++this.c;
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }

        static /* synthetic */ ArrayList access$400(Node node) {
            return node._list;
        }

        static /* synthetic */ String access$500(Node node) {
            return node._tag;
        }
    }

    public static class Attribute {
        private String _name;
        private String _value;

        Attribute(String string, String string2) {
            this._name = string;
            this._value = string2;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }

    private class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node _context;
        private NoopHandler _noop;

        Handler() {
            this._context = this._top = new Node(null, null, null);
            this._noop = new NoopHandler(this);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this._context = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = string == null || string.equals("") ? string3 : string2;
            Node node = new Node(this._context, string4, attributes);
            if (XmlParser.this._xpaths != null) {
                String string5 = node.getPath();
                boolean bl = false;
                int n = LazyList.size(XmlParser.this._xpaths);
                while (!bl && n-- > 0) {
                    String string6 = (String)LazyList.get(XmlParser.this._xpaths, n);
                    bl = string5.equals(string6) || string6.startsWith(string5) && string6.length() > string5.length() && string6.charAt(string5.length()) == '/';
                }
                if (bl) {
                    this._context.add(node);
                    this._context = node;
                } else {
                    XmlParser.this._parser.getXMLReader().setContentHandler(this._noop);
                }
            } else {
                this._context.add(node);
                this._context = node;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this._context = this._context._parent;
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this._context.add(new String(cArray, n, n2));
        }

        public void warning(SAXParseException sAXParseException) {
            log.debug((Object)"EXCEPTION ", (Throwable)sAXParseException);
            log.warn((Object)("WARNING@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString()));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this._error == null) {
                this._error = sAXParseException;
            }
            log.debug((Object)"EXCEPTION ", (Throwable)sAXParseException);
            log.warn((Object)("ERROR@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString()));
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this._error = sAXParseException;
            log.debug((Object)"EXCEPTION ", (Throwable)sAXParseException);
            log.warn((Object)("FATAL@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString()));
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            return sAXParseException.getSystemId() + " line:" + sAXParseException.getLineNumber() + " col:" + sAXParseException.getColumnNumber();
        }

        public InputSource resolveEntity(String string, String string2) {
            Object object;
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolveEntity(" + string + ", " + string2 + ")"));
            }
            URL uRL = null;
            if (string != null) {
                uRL = (URL)XmlParser.this._redirectMap.get(string);
            }
            if (uRL == null) {
                uRL = (URL)XmlParser.this._redirectMap.get(string2);
            }
            if (uRL == null) {
                object = string2;
                if (((String)object).lastIndexOf(47) >= 0) {
                    object = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't exact match entity in redirect map, trying " + (String)object));
                }
                uRL = (URL)XmlParser.this._redirectMap.get(object);
            }
            if (uRL != null) {
                try {
                    object = uRL.openStream();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirected entity " + string2 + " --> " + uRL));
                    }
                    InputSource inputSource = new InputSource((InputStream)object);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                catch (IOException iOException) {
                    LogSupport.ignore(log, iOException);
                }
            }
            return null;
        }
    }

    private class NoopHandler
    extends DefaultHandler {
        Handler _next;
        int _depth;

        NoopHandler(Handler handler) {
            this._next = handler;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this._depth;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this._depth == 0) {
                XmlParser.this._parser.getXMLReader().setContentHandler(this._next);
            } else {
                --this._depth;
            }
        }
    }
}

