/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Pool;

public class ThreadPool
implements LifeCycle,
Serializable {
    static Log log = LogFactory.getLog(ThreadPool.class);
    private static int __pool = 0;
    public static final String __DAEMON = "org.mortbay.util.ThreadPool.daemon";
    public static final String __PRIORITY = "org.mortbay.util.ThreadPool.priority";
    private Pool _pool;
    private Object _join = "";
    private transient boolean _started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        Class clazz = ThreadPool.class;
        synchronized (clazz) {
            string = string + __pool++;
        }
        this._pool = new Pool();
        this._pool.setPoolClass(PoolThread.class);
        this.setName(string);
    }

    public String getName() {
        return this._pool.getPoolName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        Class clazz = Pool.class;
        synchronized (clazz) {
            if (this.isStarted()) {
                if (string == null && this._pool.getPoolName() != null || string != null && !string.equals(this._pool.getPoolName())) {
                    throw new IllegalStateException("started");
                }
                return;
            }
            if (string == null) {
                if (this._pool.getPoolName() != null) {
                    this._pool = new Pool();
                    this._pool.setPoolName(this.getName());
                }
            } else if (!string.equals(this.getName())) {
                Pool pool = Pool.getPool(string);
                if (pool == null) {
                    this._pool.setPoolName(string);
                } else {
                    this._pool = pool;
                }
            }
        }
    }

    public String getPoolName() {
        return this.getName();
    }

    public void setPoolName(String string) {
        this.setName(string);
    }

    public boolean isDaemon() {
        return this._pool.getAttribute(__DAEMON) != null;
    }

    public void setDaemon(boolean bl) {
        this._pool.setAttribute(__DAEMON, bl ? "true" : null);
    }

    public boolean isStarted() {
        return this._started;
    }

    public int getThreads() {
        return this._pool.size();
    }

    public int getIdleThreads() {
        return this._pool.available();
    }

    public int getMinThreads() {
        return this._pool.getMinSize();
    }

    public void setMinThreads(int n) {
        this._pool.setMinSize(n);
    }

    public int getMaxThreads() {
        return this._pool.getMaxSize();
    }

    public void setMaxThreads(int n) {
        this._pool.setMaxSize(n);
    }

    public int getMaxIdleTimeMs() {
        return this._pool.getMaxIdleTimeMs();
    }

    public void setMaxIdleTimeMs(int n) {
        this._pool.setMaxIdleTimeMs(n);
    }

    public int getThreadsPriority() {
        int n = 5;
        Object object = this._pool.getAttribute(__PRIORITY);
        if (object != null) {
            n = (Integer)object;
        }
        return n;
    }

    public void setThreadsPriority(int n) {
        this._pool.setAttribute(__PRIORITY, new Integer(n));
    }

    public void setMaxStopTimeMs(int n) {
        log.warn((Object)"setMaxStopTimeMs is deprecated. No longer required.");
    }

    public void start() throws Exception {
        this._started = true;
        this._pool.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        this._started = false;
        this._pool.stop();
        Object object = this._join;
        synchronized (object) {
            this._join.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        while (this.isStarted() && this._pool != null) {
            Object object = this._join;
            synchronized (object) {
                try {
                    if (this.isStarted() && this._pool != null) {
                        this._join.wait(30000L);
                    }
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            }
        }
    }

    public void shrink() throws InterruptedException {
        this._pool.shrink();
    }

    public void run(Object object) throws InterruptedException {
        if (object == null) {
            return;
        }
        try {
            PoolThread poolThread = (PoolThread)this._pool.get(this.getMaxIdleTimeMs());
            if (poolThread != null) {
                poolThread.run(this, object);
            } else {
                log.warn((Object)("No thread for " + object));
                this.stopJob(null, object);
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }

    protected void handle(Object object) throws InterruptedException {
        if (object != null && object instanceof Runnable) {
            ((Runnable)object).run();
        } else {
            log.warn((Object)("Invalid job: " + object));
        }
    }

    protected void stopJob(Thread thread, Object object) {
    }

    public static class PoolThread
    extends Thread
    implements Pool.PondLife {
        Pool _pool;
        ThreadPool _jobPool;
        Object _job;
        ThreadPool _runPool;
        Object _run;
        int _id;
        String _name;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterPool(Pool pool, int n) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = pool;
                this._id = n;
                this._name = this._pool.getPoolName() + "-" + n;
                this.setName(this._name);
                this.setDaemon(pool.getAttribute(ThreadPool.__DAEMON) != null);
                Object object = pool.getAttribute(ThreadPool.__PRIORITY);
                if (object != null) {
                    this.setPriority((Integer)object);
                }
                this.start();
            }
        }

        public int getID() {
            return this._id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void poolClosing() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._run == null) {
                    this.notify();
                } else {
                    this.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void leavePool() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._jobPool == null && this._runPool == null) {
                    this.notify();
                }
                if (this._job != null && this._jobPool != null) {
                    this._jobPool.stopJob(this, this._job);
                    this._job = null;
                    this._jobPool = null;
                }
                if (this._run != null && this._runPool != null) {
                    this._runPool.stopJob(this, this._run);
                    this._run = null;
                    this._runPool = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ThreadPool threadPool, Object object) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._jobPool = threadPool;
                this._job = object;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Object object = null;
            ThreadPool threadPool = null;
            while (this._pool != null && this._pool.isStarted()) {
                InterruptedException interruptedException2222;
                boolean bl;
                PoolThread poolThread;
                Object var6_5;
                try {
                    block25: {
                        PoolThread poolThread2 = this;
                        synchronized (poolThread2) {
                            if (object == null && this._pool != null && this._pool.isStarted() && this._job == null) {
                                this.wait(this._pool.getMaxIdleTimeMs());
                            }
                            if (this._job != null) {
                                object = this._run = this._job;
                                this._job = null;
                                threadPool = this._runPool = this._jobPool;
                                this._jobPool = null;
                            }
                        }
                        if (object != null && threadPool != null) {
                            threadPool.handle(object);
                            break block25;
                        }
                        if (object != null || this._pool == null) break block25;
                        this._pool.shrink();
                    }
                    var6_5 = null;
                    poolThread = this;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    poolThread = this;
                    synchronized (poolThread) {
                        bl = object != null;
                        this._run = null;
                        object = null;
                        this._runPool = null;
                        threadPool = null;
                        try {
                            if (bl && this._pool != null) {
                                this._pool.put(this);
                            }
                        }
                        catch (InterruptedException interruptedException2222) {
                            LogSupport.ignore(log, interruptedException2222);
                        }
                    }
                    throw throwable;
                }
                synchronized (poolThread) {
                    bl = object != null;
                    this._run = null;
                    object = null;
                    this._runPool = null;
                    threadPool = null;
                    try {
                        if (bl && this._pool != null) {
                            this._pool.put(this);
                        }
                    }
                    catch (InterruptedException interruptedException2222) {
                        LogSupport.ignore(log, interruptedException2222);
                    }
                    continue;
                }
                {
                    catch (InterruptedException interruptedException3) {
                        LogSupport.ignore(log, interruptedException3);
                        var6_5 = null;
                        poolThread = this;
                        synchronized (poolThread) {
                            bl = object != null;
                            this._run = null;
                            object = null;
                            this._runPool = null;
                            threadPool = null;
                            try {
                                if (bl && this._pool != null) {
                                    this._pool.put(this);
                                }
                            }
                            catch (InterruptedException interruptedException2222) {
                                LogSupport.ignore(log, interruptedException2222);
                            }
                        }
                    }
                }
            }
        }

        public String toString() {
            return this._name;
        }
    }
}

