/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnTokens = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;

    public QuotedStringTokenizer(String string, String string2, boolean bl, boolean bl2) {
        super("");
        this._string = string;
        if (string2 != null) {
            this._delim = string2;
        }
        this._returnTokens = bl;
        this._returnQuotes = bl2;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public QuotedStringTokenizer(String string, String string2) {
        this(string, string2, false, false);
    }

    public QuotedStringTokenizer(String string) {
        this(string, null, false, false);
    }

    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int n = 0;
        boolean bl = false;
        block6: while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (n) {
                case 0: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnTokens) continue block6;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 2;
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    n = 1;
                    continue block6;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c) >= 0) {
                        if (this._returnTokens) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 2;
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 2: {
                    this._hasToken = true;
                    if (bl) {
                        bl = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        bl = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 3: {
                    this._hasToken = true;
                    if (bl) {
                        bl = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        bl = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String string = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return string;
    }

    public String nextToken(String string) throws NoSuchElementException {
        this._delim = string;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        return -1;
    }

    public static String quote(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\\' && c != '\'' && string2.indexOf(c) < 0) continue;
            StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
            QuotedStringTokenizer.quote(stringBuffer, string);
            return stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    stringBuffer.append("\\\"");
                    continue;
                }
                if (c == '\\') {
                    stringBuffer.append("\\\\");
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unquote(String string) {
        StringBuffer stringBuffer;
        char c;
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 != (c = string.charAt(string.length() - 1)) || c2 != '\"' && c2 != '\'') {
            return string;
        }
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(string.length() - 2);
        synchronized (stringBuffer2) {
            boolean bl = false;
            for (int i = 1; i < string.length() - 1; ++i) {
                char c3 = string.charAt(i);
                if (c3 == '\\' && !bl) {
                    bl = true;
                    continue;
                }
                bl = false;
                stringBuffer.append(c3);
            }
            return stringBuffer.toString();
        }
    }
}

