/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.html.Block;
import org.mortbay.html.Break;
import org.mortbay.html.Font;
import org.mortbay.html.Page;
import org.mortbay.html.TableForm;
import org.mortbay.log.LogFactory;
import org.mortbay.log.LogImpl;
import org.mortbay.log.LogSink;
import org.mortbay.log.OutputStreamLogSink;

public class Debug
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Page page = new Page();
        page.title(this.getServletInfo());
        page.attribute("text", "#000000");
        page.attribute("bgcolor", "#FFFFFF");
        page.attribute("link", "#606CC0");
        page.attribute("vlink", "#606CC0");
        page.attribute("alink", "#606CC0");
        Log log = LogFactory.getLog(Debug.class);
        if (!(log instanceof LogImpl)) {
            return;
        }
        LogImpl logImpl = (LogImpl)log;
        TableForm tableForm = new TableForm(httpServletRequest.getRequestURI());
        page.add(tableForm);
        tableForm.table().newRow().addCell(new Block("b").add(new Font(3, true).add(this.getServletInfo()))).cell().attribute("COLSPAN", "2");
        tableForm.table().add(Break.rule);
        tableForm.addCheckbox("D", "Debug On", logImpl.getDebug());
        tableForm.addTextField("V", "Verbosity Level", 6, "" + logImpl.getVerbose());
        tableForm.addTextField("P", "Debug Patterns", 40, logImpl.getDebugPatterns());
        tableForm.addCheckbox("W", "Suppress Warnings", logImpl.getSuppressWarnings());
        LogSink[] logSinkArray = logImpl.getLogSinks();
        for (int i = 0; logSinkArray != null && i < logSinkArray.length; ++i) {
            if (logSinkArray[i] == null) continue;
            tableForm.table().newRow().addCell(Break.rule).cell().attribute("COLSPAN", "2");
            tableForm.table().newRow().addCell("<B><font size=\"+1\">Log Sink " + i + ":</font></B").right();
            tableForm.table().addCell(logSinkArray[i].getClass().getName()).left();
            tableForm.addCheckbox("LSS" + i, "Started", logSinkArray[i].isStarted());
            if (!(logSinkArray[i] instanceof OutputStreamLogSink)) continue;
            OutputStreamLogSink outputStreamLogSink = (OutputStreamLogSink)logSinkArray[i];
            tableForm.addCheckbox("LT" + i, "Tag", outputStreamLogSink.isLogTags());
            tableForm.addCheckbox("LL" + i, "Label", outputStreamLogSink.isLogLabels());
            tableForm.addCheckbox("Ls" + i, "Stack Size", outputStreamLogSink.isLogStackSize());
            tableForm.addCheckbox("LS" + i, "Stack Trace", outputStreamLogSink.isLogStackTrace());
            tableForm.addCheckbox("SS" + i, "Suppress Stacks", outputStreamLogSink.isSuppressStack());
            tableForm.addCheckbox("SL" + i, "Single Line", outputStreamLogSink.isLogOneLine());
            tableForm.addTextField("LF" + i, "Log File Name", 40, outputStreamLogSink.getFilename());
        }
        tableForm.table().newRow().addCell(Break.rule).cell().attribute("COLSPAN", "2");
        tableForm.addTextField("LSC", "Add LogSink Class", 40, "org.mortbay.log.OutputStreamLogSink");
        tableForm.addButtonArea();
        tableForm.addButton("Action", "Set Options");
        tableForm.addButton("Action", "Add LogSink");
        tableForm.addButton("Action", "Delete Stopped Sinks");
        tableForm.table().newRow().addCell(Break.rule).cell().attribute("COLSPAN", "2");
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache,no-store");
        PrintWriter printWriter = httpServletResponse.getWriter();
        page.write(printWriter);
        ((Writer)printWriter).flush();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = null;
        Log log = LogFactory.getLog(Debug.class);
        if (!(log instanceof LogImpl)) {
            return;
        }
        LogImpl logImpl = (LogImpl)log;
        String string2 = httpServletRequest.getParameter("Action");
        if ("Set Options".equals(string2)) {
            logImpl.setDebug("on".equals(httpServletRequest.getParameter("D")));
            logImpl.setSuppressWarnings("on".equals(httpServletRequest.getParameter("W")));
            String string3 = httpServletRequest.getParameter("V");
            if (string3 != null && string3.length() > 0) {
                logImpl.setVerbose(Integer.parseInt(string3));
            } else {
                logImpl.setVerbose(0);
            }
            logImpl.setDebugPatterns(httpServletRequest.getParameter("P"));
            LogSink[] logSinkArray = logImpl.getLogSinks();
            for (int i = 0; logSinkArray != null && i < logSinkArray.length; ++i) {
                String string4;
                if (logSinkArray[i] == null) continue;
                if ("on".equals(httpServletRequest.getParameter("LSS" + i))) {
                    if (!logSinkArray[i].isStarted()) {
                        try {
                            logSinkArray[i].start();
                        }
                        catch (Exception exception) {
                            logImpl.warn(exception);
                        }
                    }
                } else if (logSinkArray[i].isStarted()) {
                    try {
                        logSinkArray[i].stop();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if ((string4 = httpServletRequest.getParameter("LO" + i)) == null) {
                    string4 = "";
                }
                if (!(logSinkArray[i] instanceof OutputStreamLogSink)) continue;
                OutputStreamLogSink outputStreamLogSink = (OutputStreamLogSink)logSinkArray[i];
                outputStreamLogSink.setLogTags("on".equals(httpServletRequest.getParameter("LT" + i)));
                outputStreamLogSink.setLogLabels("on".equals(httpServletRequest.getParameter("LL" + i)));
                outputStreamLogSink.setLogStackSize("on".equals(httpServletRequest.getParameter("Ls" + i)));
                outputStreamLogSink.setLogStackTrace("on".equals(httpServletRequest.getParameter("LS" + i)));
                outputStreamLogSink.setSuppressStack("on".equals(httpServletRequest.getParameter("SS" + i)));
                outputStreamLogSink.setLogOneLine("on".equals(httpServletRequest.getParameter("SL" + i)));
                outputStreamLogSink.setFilename(httpServletRequest.getParameter("LF" + i));
            }
        } else if ("Add LogSink".equals(string2)) {
            System.err.println("add log sink " + httpServletRequest.getParameter("LSC"));
            try {
                logImpl.add(httpServletRequest.getParameter("LSC"));
            }
            catch (Exception exception) {
                logImpl.warn(exception);
            }
        } else if ("Delete Stopped Sinks".equals(string2)) {
            logImpl.deleteStoppedLogSinks();
        }
        httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + httpServletRequest.getServletPath() + "/" + Long.toString(System.currentTimeMillis(), 36) + (string != null ? "#" + string : ""));
    }

    public String getServletInfo() {
        return "Debug And  Log Options";
    }
}

