/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.JarResource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;

public class WebApplicationContext
extends ServletHttpContext
implements Externalizable {
    private static Log log = LogFactory.getLog(WebApplicationContext.class);
    private String _defaultsDescriptor = "org/mortbay/jetty/servlet/webdefault.xml";
    private String _war;
    private boolean _extract;
    private boolean _ignorewebjetty;
    private boolean _distributable;
    private Configuration[] _configurations;
    private String[] _configurationClassNames;
    private transient Map _resourceAliases;
    private transient Resource _webApp;
    private transient Resource _webInf;
    private transient WebApplicationHandler _webAppHandler;
    private transient Object _contextListeners;
    private transient Map _errorPages;

    public WebApplicationContext() {
    }

    public WebApplicationContext(String string) {
        this._war = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getContextPath());
        objectOutput.writeObject(this.getVirtualHosts());
        HttpHandler[] httpHandlerArray = this.getHandlers();
        for (int i = 0; i < httpHandlerArray.length && !(httpHandlerArray[i] instanceof WebApplicationHandler); ++i) {
            objectOutput.writeObject(httpHandlerArray[i]);
        }
        objectOutput.writeObject(this.getAttributes());
        objectOutput.writeBoolean(this.isRedirectNullPath());
        objectOutput.writeInt(this.getMaxCachedFileSize());
        objectOutput.writeInt(this.getMaxCacheSize());
        objectOutput.writeBoolean(this.getStatsOn());
        objectOutput.writeObject(this.getPermissions());
        objectOutput.writeBoolean(this.isClassLoaderJava2Compliant());
        objectOutput.writeObject(this._defaultsDescriptor);
        objectOutput.writeObject(this._war);
        objectOutput.writeBoolean(this._extract);
        objectOutput.writeBoolean(this._ignorewebjetty);
        objectOutput.writeBoolean(this._distributable);
        objectOutput.writeObject(this._configurationClassNames);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setContextPath((String)objectInput.readObject());
        this.setVirtualHosts((String[])objectInput.readObject());
        Object object = objectInput.readObject();
        while (object instanceof HttpHandler) {
            this.addHandler((HttpHandler)object);
            object = objectInput.readObject();
        }
        this.setAttributes((Map)object);
        this.setRedirectNullPath(objectInput.readBoolean());
        this.setMaxCachedFileSize(objectInput.readInt());
        this.setMaxCacheSize(objectInput.readInt());
        this.setStatsOn(objectInput.readBoolean());
        this.setPermissions((PermissionCollection)objectInput.readObject());
        this.setClassLoaderJava2Compliant(objectInput.readBoolean());
        this._defaultsDescriptor = (String)objectInput.readObject();
        this._war = (String)objectInput.readObject();
        this._extract = objectInput.readBoolean();
        this._ignorewebjetty = objectInput.readBoolean();
        this._distributable = objectInput.readBoolean();
        this._configurationClassNames = (String[])objectInput.readObject();
    }

    public void setConfigurationClassNames(String[] stringArray) {
        if (null != stringArray) {
            this._configurationClassNames = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this._configurationClassNames, 0, stringArray.length);
        }
    }

    public String[] getConfigurationClassNames() {
        return this._configurationClassNames;
    }

    public void setWAR(String string) {
        this._war = string;
    }

    public String getWAR() {
        return this._war;
    }

    public WebApplicationHandler getWebApplicationHandler() {
        if (this._webAppHandler == null) {
            this.getServletHandler();
        }
        return this._webAppHandler;
    }

    private void resolveWebApp() throws IOException {
        if (this._webApp == null && this._war != null && this._war.length() > 0) {
            Serializable serializable;
            this._webApp = Resource.newResource(this._war);
            if (this._webApp.getAlias() != null) {
                log.info((Object)(this._webApp + " anti-aliased to " + this._webApp.getAlias()));
                this._webApp = Resource.newResource(this._webApp.getAlias());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
            }
            if (this._webApp.exists() && !this._webApp.isDirectory() && !this._webApp.toString().startsWith("jar:") && ((Resource)(serializable = Resource.newResource("jar:" + this._webApp + "!/"))).exists() && ((Resource)serializable).isDirectory()) {
                this._webApp = serializable;
                this._war = this._webApp.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (this._webApp.exists() && (!this._webApp.isDirectory() || this._extract && this._webApp.getFile() == null || this._extract && this._webApp.getFile() != null && !this._webApp.getFile().isDirectory())) {
                serializable = new File(this.getTempDirectory(), "webapp");
                if (((File)serializable).exists()) {
                    ((File)serializable).delete();
                }
                ((File)serializable).mkdir();
                ((File)serializable).deleteOnExit();
                log.info((Object)("Extract " + this._war + " to " + serializable));
                JarResource.extract(this._webApp, (File)serializable, true);
                this._webApp = Resource.newResource(((File)serializable).getCanonicalPath());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (!this._webApp.exists() || !this._webApp.isDirectory()) {
                log.warn((Object)("Web application not found " + this._war));
                throw new FileNotFoundException(this._war);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("webapp=" + this._webApp));
            }
            this._webInf = this._webApp.addPath("WEB-INF/");
            if (!this._webInf.exists() || !this._webInf.isDirectory()) {
                this._webInf = null;
            } else {
                serializable = this._webInf.addPath("work");
                if (((Resource)serializable).exists() && ((Resource)serializable).isDirectory() && ((Resource)serializable).getFile() != null && ((Resource)serializable).getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
                    this.setAttribute("javax.servlet.context.tempdir", ((Resource)serializable).getFile());
                }
            }
            super.setBaseResource(this._webApp);
        }
    }

    public Resource getWebInf() throws IOException {
        if (this._webInf == null) {
            this.resolveWebApp();
        }
        return this._webInf;
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._webAppHandler == null) {
            this._webAppHandler = (WebApplicationHandler)this.getHandler(WebApplicationHandler.class);
            if (this._webAppHandler == null) {
                if (this.getHandler(ServletHandler.class) != null) {
                    throw new IllegalStateException("Cannot have ServletHandler in WebApplicationContext");
                }
                this._webAppHandler = new WebApplicationHandler();
                this.addHandler(this._webAppHandler);
            }
        }
        return this._webAppHandler;
    }

    public void setPermissions(PermissionCollection permissionCollection) {
        if (!this._ignorewebjetty) {
            log.warn((Object)"Permissions set with web-jetty.xml enabled");
        }
        super.setPermissions(permissionCollection);
    }

    public boolean isIgnoreWebJetty() {
        return this._ignorewebjetty;
    }

    public void setIgnoreWebJetty(boolean bl) {
        this._ignorewebjetty = bl;
        if (bl && this.getPermissions() != null) {
            log.warn((Object)"Permissions set with web-jetty.xml enabled");
        }
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public void setDistributable(boolean bl) {
        this._distributable = bl;
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    protected Configuration[] loadConfigurations() throws Exception {
        String[] stringArray = this._configurationClassNames;
        if (null == stringArray) {
            stringArray = ((Server)this.getHttpServer()).getWebApplicationConfigurationClassNames();
        }
        if (null != stringArray) {
            Object[] objectArray = new Object[]{};
            Configuration[] configurationArray = new Configuration[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                configurationArray[i] = (Configuration)Loader.loadClass(class$org$mortbay$jetty$servlet$WebApplicationContext == null ? WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationContext") : class$org$mortbay$jetty$servlet$WebApplicationContext, stringArray[i]).getConstructors()[0].newInstance(objectArray);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded instance of " + stringArray[i]));
            }
            return configurationArray;
        }
        return new Configuration[0];
    }

    protected void configureClassPath() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebApplicationContext(this);
            this._configurations[i].configureClassPath();
        }
    }

    protected void configureDefaults() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebApplicationContext(this);
            this._configurations[i].configureDefaults();
        }
    }

    protected void configureWebApp() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebApplicationContext(this);
            this._configurations[i].configureWebApp();
        }
    }

    protected void doStart() throws Exception {
        if (this.isStarted()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        MultiException multiException = null;
        try {
            ServletHolder servletHolder;
            this.resolveWebApp();
            this.getServletHandler();
            this._configurations = this.loadConfigurations();
            this.configureClassPath();
            this.initClassLoader(true);
            thread.setContextClassLoader(this.getClassLoader());
            this.initialize();
            this.configureDefaults();
            Map.Entry entry = this._webAppHandler.getHolderEntry("test.jsp");
            if (entry != null && (servletHolder = (ServletHolder)entry.getValue()) != null && servletHolder.getInitParameter("classpath") == null) {
                String string = this.getFileClassPath();
                servletHolder.setInitParameter("classpath", string);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set classpath=" + string + " for " + servletHolder));
                }
            }
            this.configureWebApp();
            this._webAppHandler.setAutoInitializeServlets(false);
            super.doStart();
            multiException = new MultiException();
            if (this._contextListeners != null && this._webAppHandler != null) {
                servletHolder = new ServletContextEvent(this.getServletContext());
                for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                    try {
                        ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized((ServletContextEvent)servletHolder);
                        continue;
                    }
                    catch (Exception exception) {
                        multiException.add(exception);
                    }
                }
            }
            if (this._webAppHandler != null && this._webAppHandler.isStarted()) {
                try {
                    this._webAppHandler.initializeServlets();
                }
                catch (Exception exception) {
                    multiException.add(exception);
                }
            }
        }
        catch (Exception exception) {
            log.warn((Object)("Configuration error on " + this._war), (Throwable)exception);
            throw exception;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
        if (multiException != null) {
            multiException.ifExceptionThrow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        MultiException multiException = new MultiException();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            if (this._contextListeners != null && this._webAppHandler != null) {
                ServletContextEvent servletContextEvent = new ServletContextEvent(this.getServletContext());
                int n = LazyList.size(this._contextListeners);
                while (n-- > 0) {
                    try {
                        ((ServletContextListener)LazyList.get(this._contextListeners, n)).contextDestroyed(servletContextEvent);
                    }
                    catch (Exception exception) {
                        multiException.add(exception);
                    }
                }
            }
            this._contextListeners = null;
            try {
                super.doStop();
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
            this.clearSecurityConstraints();
            if (this._webAppHandler != null) {
                this.removeHandler(this._webAppHandler);
            }
            this._webAppHandler = null;
            if (this._errorPages != null) {
                this._errorPages.clear();
            }
            this._errorPages = null;
            this._webApp = null;
            this._webInf = null;
            this._configurations = null;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
        if (multiException != null) {
            multiException.ifExceptionThrow();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._defaultsDescriptor = null;
        this._war = null;
        this._configurationClassNames = null;
        if (this._resourceAliases != null) {
            this._resourceAliases.clear();
        }
        this._resourceAliases = null;
        this._contextListeners = null;
        if (this._errorPages != null) {
            this._errorPages.clear();
        }
        this._errorPages = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        block6: {
            if (!this.isStarted()) {
                return;
            }
            try {
                super.handle(string, string2, httpRequest, httpResponse);
                Object var6_5 = null;
                if (httpRequest.isHandled()) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!httpRequest.isHandled()) {
                    httpResponse.sendError(404);
                }
                httpRequest.setHandled(true);
                if (!httpResponse.isCommitted()) {
                    httpResponse.completing();
                    httpResponse.commit();
                }
                throw throwable;
            }
            httpResponse.sendError(404);
        }
        httpRequest.setHandled(true);
        if (!httpResponse.isCommitted()) {
            httpResponse.completing();
            httpResponse.commit();
        }
    }

    public synchronized void addEventListener(EventListener eventListener) throws IllegalArgumentException {
        if (eventListener instanceof ServletContextListener) {
            this._contextListeners = LazyList.add(this._contextListeners, eventListener);
        }
        super.addEventListener(eventListener);
    }

    public synchronized void removeEventListener(EventListener eventListener) {
        this._contextListeners = LazyList.remove(this._contextListeners, eventListener);
        super.removeEventListener(eventListener);
    }

    public String getDisplayName() {
        return this.getHttpContextName();
    }

    public void setDisplayName(String string) {
        this.setHttpContextName(string);
    }

    public void setDefaultsDescriptor(String string) {
        this._defaultsDescriptor = string;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setExtractWAR(boolean bl) {
        this._extract = bl;
    }

    public boolean getExtractWAR() {
        return this._extract;
    }

    protected void initialize() throws Exception {
    }

    protected UserRealm getUserRealm(String string) {
        return this.getHttpServer().getRealm(string);
    }

    public String toString() {
        String string = this.getDisplayName();
        return "WebApplicationContext[" + this.getContextPath() + "," + (string == null ? this._war : string) + "]";
    }

    public void setResourceAlias(String string, String string2) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(string, string2);
    }

    public Map getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._resourceAliases);
    }

    public String getResourceAlias(String string) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(string);
    }

    public String removeResourceAlias(String string) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(string);
    }

    public Resource getResource(String string) throws IOException {
        IOException iOException = null;
        Resource resource = null;
        try {
            resource = super.getResource(string);
            if (resource != null && resource.exists()) {
                return resource;
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        String string2 = this.getResourceAlias(string);
        if (string2 != null) {
            return super.getResource(string2);
        }
        if (iOException != null) {
            throw iOException;
        }
        return resource;
    }

    public void setErrorPage(String string, String string2) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(string, string2);
    }

    public String getErrorPage(String string) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.get(string);
    }

    public String removeErrorPage(String string) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.remove(string);
    }

    public static interface Configuration
    extends Serializable {
        public void setWebApplicationContext(WebApplicationContext var1);

        public WebApplicationContext getWebApplicationContext();

        public void configureClassPath() throws Exception;

        public void configureDefaults() throws Exception;

        public void configureWebApp() throws Exception;
    }
}

