/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.InclusiveByteRange;
import org.mortbay.http.MultiPartResponse;
import org.mortbay.http.ResourceCache;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.CachedResource;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;
import org.mortbay.util.WriterOutputStream;

public class Default
extends HttpServlet {
    private static Log log = LogFactory.getLog(Default.class);
    private HttpContext _httpContext;
    private ServletHandler _servletHandler;
    private String _AllowString = "GET, POST, HEAD, OPTIONS, TRACE";
    private boolean _acceptRanges = true;
    private boolean _dirAllowed;
    private boolean _putAllowed;
    private boolean _delAllowed;
    private boolean _redirectWelcomeFiles;
    private int _minGzipLength = -1;
    private Resource _resourceBase;

    public void init() throws UnavailableException {
        ServletContext servletContext = this.getServletContext();
        this._servletHandler = ((ServletHandler.Context)servletContext).getServletHandler();
        this._httpContext = this._servletHandler.getHttpContext();
        this._acceptRanges = this.getInitBoolean("acceptRanges");
        this._dirAllowed = this.getInitBoolean("dirAllowed");
        this._putAllowed = this.getInitBoolean("putAllowed");
        this._delAllowed = this.getInitBoolean("delAllowed");
        this._redirectWelcomeFiles = this.getInitBoolean("redirectWelcome");
        this._minGzipLength = this.getInitInt("minGzipLength");
        String string = this.getInitParameter("relativeResourceBase");
        if (string != null) {
            try {
                this._resourceBase = this._httpContext.getBaseResource().addPath(string);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                throw new UnavailableException(exception.toString());
            }
        }
        String string2 = this.getInitParameter("resourceBase");
        if (string != null && string2 != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (string2 != null) {
            try {
                this._resourceBase = Resource.newResource(string2);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                throw new UnavailableException(exception.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("resource base = " + this._resourceBase));
        }
        if (this._putAllowed) {
            this._AllowString = this._AllowString + ", PUT";
        }
        if (this._delAllowed) {
            this._AllowString = this._AllowString + ", DELETE";
        }
        if (this._putAllowed && this._delAllowed) {
            this._AllowString = this._AllowString + ", MOVE";
        }
    }

    private boolean getInitBoolean(String string) {
        String string2 = this.getInitParameter(string);
        return string2 != null && string2.length() > 0 && (string2.startsWith("t") || string2.startsWith("T") || string2.startsWith("y") || string2.startsWith("Y") || string2.startsWith("1"));
    }

    private int getInitInt(String string) {
        String string2 = this.getInitParameter(string);
        if (string2 != null && string2.length() > 0) {
            return Integer.parseInt(string2);
        }
        return -1;
    }

    protected Resource getResource(String string) throws IOException {
        Resource resource;
        Resource resource2 = resource = this._resourceBase == null ? this._httpContext.getResource(string) : this._resourceBase.addPath(string);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOURCE=" + resource));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        String string2 = null;
        if (string == null) {
            string = httpServletRequest.getServletPath();
            string2 = httpServletRequest.getPathInfo();
        } else {
            string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        }
        String string3 = URI.addPaths(string, string2);
        boolean bl = string3.endsWith("/");
        Resource resource = this.getResource(string3);
        String string4 = httpServletRequest.getMethod();
        if (this._AllowString.indexOf(string4) < 0) {
            if (resource != null && resource.exists()) {
                httpServletResponse.setHeader("Allow", this._AllowString);
                httpServletResponse.sendError(405);
                return;
            }
            httpServletResponse.sendError(404);
            return;
        }
        try {
            try {
                if (string4.equals("GET") || string4.equals("POST") || string4.equals("HEAD")) {
                    this.handleGet(httpServletRequest, httpServletResponse, string3, resource, bl);
                } else if (this._putAllowed && string4.equals("PUT")) {
                    this.handlePut(httpServletRequest, httpServletResponse, string3, resource);
                } else if (this._delAllowed && string4.equals("DELETE")) {
                    this.handleDelete(httpServletRequest, httpServletResponse, string3, resource);
                } else if (this._putAllowed && this._delAllowed && string4.equals("MOVE")) {
                    this.handleMove(httpServletRequest, httpServletResponse, string3, resource);
                } else if (string4.equals("OPTIONS")) {
                    this.handleOptions(httpServletRequest, httpServletResponse);
                } else if (string4.equals("TRACE")) {
                    this._servletHandler.handleTrace(httpServletRequest, httpServletResponse);
                } else {
                    try {
                        if (resource.exists()) {
                            httpServletResponse.sendError(501);
                        } else {
                            this._servletHandler.notFound(httpServletRequest, httpServletResponse);
                        }
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                    }
                }
                Object var11_11 = null;
                if (resource == null) return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogSupport.ignore(log, illegalArgumentException);
                Object var11_12 = null;
                if (resource == null) return;
                if (resource instanceof CachedResource) return;
                resource.release();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (resource == null) throw throwable;
            if (resource instanceof CachedResource) throw throwable;
            resource.release();
            throw throwable;
        }
        if (resource instanceof CachedResource) return;
        resource.release();
    }

    public void handleGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Resource resource, boolean bl) throws ServletException, IOException {
        if (resource == null || !resource.exists()) {
            httpServletResponse.sendError(404);
        } else if (resource.isDirectory()) {
            if (!bl && !string.equals("/")) {
                String string2 = httpServletRequest.getQueryString();
                StringBuffer stringBuffer = httpServletRequest.getRequestURL();
                if (string2 != null && string2.length() != 0) {
                    stringBuffer.append('?');
                    stringBuffer.append(string2);
                }
                httpServletResponse.setContentLength(0);
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URI.addPaths(stringBuffer.toString(), "/")));
                return;
            }
            String string3 = this._httpContext.getWelcomeFile(resource);
            if (string3 != null) {
                String string4 = URI.addPaths(string, string3);
                if (this._redirectWelcomeFiles) {
                    httpServletResponse.setContentLength(0);
                    httpServletResponse.sendRedirect(URI.addPaths(this._httpContext.getContextPath(), string4));
                } else {
                    RequestDispatcher requestDispatcher = this._servletHandler.getRequestDispatcher(string4);
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
                return;
            }
            if (!this.passConditionalHeaders(httpServletRequest, httpServletResponse, resource)) {
                return;
            }
            this.sendDirectory(httpServletRequest, httpServletResponse, resource, string.length() > 1);
        } else {
            if (!this.passConditionalHeaders(httpServletRequest, httpServletResponse, resource)) {
                return;
            }
            this.sendData(httpServletRequest, httpServletResponse, string, resource);
        }
    }

    public void handlePut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Resource resource) throws ServletException, IOException {
        boolean bl;
        boolean bl2 = bl = resource != null && resource.exists();
        if (bl && !this.passConditionalHeaders(httpServletRequest, httpServletResponse, resource)) {
            return;
        }
        if (string.endsWith("/")) {
            if (!bl) {
                if (!resource.getFile().mkdirs()) {
                    httpServletResponse.sendError(403, "Directories could not be created");
                } else {
                    httpServletResponse.setStatus(201);
                    httpServletResponse.flushBuffer();
                }
            } else {
                httpServletResponse.setStatus(200);
                httpServletResponse.flushBuffer();
            }
        } else {
            try {
                int n = httpServletRequest.getContentLength();
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                OutputStream outputStream = resource.getOutputStream();
                if (n >= 0) {
                    IO.copy((InputStream)servletInputStream, outputStream, (long)n);
                } else {
                    IO.copy((InputStream)servletInputStream, outputStream);
                }
                outputStream.close();
                httpServletResponse.setStatus(bl ? 200 : 201);
                httpServletResponse.flushBuffer();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                httpServletResponse.sendError(403, exception.getMessage());
            }
        }
    }

    public void handleDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Resource resource) throws ServletException, IOException {
        if (!resource.exists() || !this.passConditionalHeaders(httpServletRequest, httpServletResponse, resource)) {
            return;
        }
        try {
            if (resource.delete()) {
                httpServletResponse.setStatus(204);
                httpServletResponse.flushBuffer();
            } else {
                httpServletResponse.sendError(403);
            }
        }
        catch (SecurityException securityException) {
            log.warn((Object)"EXCEPTION ", (Throwable)securityException);
            httpServletResponse.sendError(403, securityException.getMessage());
        }
    }

    public void handleMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Resource resource) throws ServletException, IOException {
        if (!resource.exists() || !this.passConditionalHeaders(httpServletRequest, httpServletResponse, resource)) {
            return;
        }
        String string2 = URI.canonicalPath(httpServletRequest.getHeader("new-uri"));
        if (string2 == null) {
            httpServletResponse.sendError(400, "No new-uri");
            return;
        }
        String string3 = this._httpContext.getContextPath();
        if (string3 != null && !string2.startsWith(string3)) {
            httpServletResponse.sendError(405, "Not in context");
            return;
        }
        try {
            String string4 = string2;
            if (string3 != null) {
                string4 = string4.substring(string3.length());
            }
            Resource resource2 = this._httpContext.getBaseResource().addPath(string4);
            resource.renameTo(resource2);
            httpServletResponse.setStatus(204);
            httpServletResponse.flushBuffer();
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            httpServletResponse.sendError(500, "Error:" + exception);
            return;
        }
    }

    public void handleOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setIntHeader("Content-Length", 0);
        httpServletResponse.setHeader("Allow", this._AllowString);
        httpServletResponse.flushBuffer();
    }

    protected boolean passConditionalHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Resource resource) throws IOException {
        if (!httpServletRequest.getMethod().equals("HEAD") && httpServletRequest.getAttribute("javax.servlet.include.request_uri") == null) {
            ResourceCache.ResourceMetaData resourceMetaData = this._httpContext.getResourceMetaData(resource);
            if (resourceMetaData != null) {
                String string = httpServletRequest.getHeader("If-Modified-Since");
                String string2 = resourceMetaData.getLastModified();
                if (string != null && string2 != null && string.equals(string2)) {
                    httpServletResponse.reset();
                    httpServletResponse.setStatus(304);
                    httpServletResponse.flushBuffer();
                    return false;
                }
            }
            long l = 0L;
            l = httpServletRequest.getDateHeader("If-Unmodified-Since");
            if (l > 0L && resource.lastModified() / 1000L > l / 1000L) {
                httpServletResponse.sendError(412);
                return false;
            }
            l = httpServletRequest.getDateHeader("If-Modified-Since");
            if (l > 0L && resource.lastModified() / 1000L <= l / 1000L) {
                httpServletResponse.reset();
                httpServletResponse.setStatus(304);
                httpServletResponse.flushBuffer();
                return false;
            }
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Resource resource, boolean bl) throws IOException {
        if (!this._dirAllowed) {
            httpServletResponse.sendError(403);
            return;
        }
        byte[] byArray = null;
        if (resource instanceof CachedResource) {
            byArray = ((CachedResource)resource).getCachedData();
        }
        if (byArray == null) {
            String string = URI.addPaths(httpServletRequest.getRequestURI(), "/");
            String string2 = resource.getListHTML(string, bl);
            if (string2 == null) {
                httpServletResponse.sendError(403, "No directory");
                return;
            }
            byArray = string2.getBytes("UTF-8");
            if (resource instanceof CachedResource) {
                ((CachedResource)resource).setCachedData(byArray);
            }
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        httpServletResponse.setContentLength(byArray.length);
        if (!httpServletRequest.getMethod().equals("HEAD")) {
            httpServletResponse.getOutputStream().write(byArray);
        }
    }

    protected void sendData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Resource resource) throws IOException {
        Enumeration enumeration;
        long l = resource.length();
        boolean bl = httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null;
        Object object = null;
        try {
            object = httpServletResponse.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            object = new WriterOutputStream(httpServletResponse.getWriter());
        }
        Enumeration enumeration2 = enumeration = bl ? null : httpServletRequest.getHeaders("Range");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            Resource resource2 = resource;
            if (!bl) {
                Resource resource3;
                String string2;
                if (this._minGzipLength > 0 && (string2 = httpServletRequest.getHeader("Accept-Encoding")) != null && l > (long)this._minGzipLength && !string.endsWith(".gz") && (resource3 = this.getResource(string + ".gz")).exists() && string2.indexOf("gzip") >= 0 && httpServletRequest.getAttribute("javax.servlet.include.request_uri") == null) {
                    httpServletResponse.setHeader("Content-Encoding", "gzip");
                    resource2 = resource3;
                    l = resource2.length();
                }
                this.writeHeaders(httpServletResponse, resource, l);
            }
            resource2.writeTo((OutputStream)object, 0L, l);
            return;
        }
        List list = InclusiveByteRange.satisfiableRanges(enumeration, l);
        if (list == null || list.size() == 0) {
            this.writeHeaders(httpServletResponse, resource, l);
            httpServletResponse.setStatus(416);
            httpServletResponse.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(l));
            resource.writeTo((OutputStream)object, 0L, l);
            return;
        }
        if (list.size() == 1) {
            InclusiveByteRange inclusiveByteRange = (InclusiveByteRange)list.get(0);
            long l2 = inclusiveByteRange.getSize(l);
            this.writeHeaders(httpServletResponse, resource, l2);
            httpServletResponse.setStatus(206);
            httpServletResponse.setHeader("Content-Range", inclusiveByteRange.toHeaderRangeString(l));
            resource.writeTo((OutputStream)object, inclusiveByteRange.getFirst(l), l2);
            return;
        }
        this.writeHeaders(httpServletResponse, resource, -1L);
        ResourceCache.ResourceMetaData resourceMetaData = this._httpContext.getResourceMetaData(resource);
        String string3 = resourceMetaData.getMimeType();
        MultiPartResponse multiPartResponse = new MultiPartResponse((OutputStream)httpServletResponse.getOutputStream());
        httpServletResponse.setStatus(206);
        String string4 = httpServletRequest.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
        httpServletResponse.setContentType(string4 + multiPartResponse.getBoundary());
        InputStream inputStream = resource instanceof CachedResource ? null : resource.getInputStream();
        long l3 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            InclusiveByteRange inclusiveByteRange = (InclusiveByteRange)list.get(i);
            String string5 = "Content-Range: " + inclusiveByteRange.toHeaderRangeString(l);
            multiPartResponse.startPart(string3, new String[]{string5});
            long l4 = inclusiveByteRange.getFirst(l);
            long l5 = inclusiveByteRange.getSize(l);
            if (inputStream != null) {
                if (l4 < l3) {
                    inputStream.close();
                    inputStream = resource.getInputStream();
                    l3 = 0L;
                }
                if (l3 < l4) {
                    inputStream.skip(l4 - l3);
                    l3 = l4;
                }
                IO.copy(inputStream, (OutputStream)object, l5);
                l3 += l5;
                continue;
            }
            resource.writeTo((OutputStream)object, l4, l5);
        }
        if (inputStream != null) {
            inputStream.close();
        }
        multiPartResponse.close();
    }

    protected void writeHeaders(HttpServletResponse httpServletResponse, Resource resource, long l) throws IOException {
        ResourceCache.ResourceMetaData resourceMetaData = this._httpContext.getResourceMetaData(resource);
        httpServletResponse.setContentType(resourceMetaData.getMimeType());
        if (l != -1L) {
            if (l == resource.length()) {
                httpServletResponse.setHeader("Content-Length", resourceMetaData.getLength());
            } else {
                httpServletResponse.setContentLength((int)l);
            }
        }
        httpServletResponse.setHeader("Last-Modified", resourceMetaData.getLastModified());
        if (this._acceptRanges) {
            httpServletResponse.setHeader("Accept-Ranges", "bytes");
        }
    }
}

