/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.B64Code;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UnixCrypt;

public class HTAccessHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(HTAccessHandler.class);
    String _default = null;
    String _accessFile = ".htaccess";
    transient HashMap _htCache = new HashMap();

    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        block20: {
            String string3;
            String string4 = null;
            String string5 = null;
            boolean bl = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("HTAccessHandler pathInContext=" + string));
            }
            if ((string3 = httpRequest.getField("Authorization")) != null) {
                string3 = string3.substring(string3.indexOf(32) + 1);
                string3 = B64Code.decode(string3, StringUtil.__ISO_8859_1);
                int n = string3.indexOf(58);
                string4 = string3.substring(0, n);
                string5 = string3.substring(n + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User=" + string4 + ", password=" + "******************************".substring(0, string5.length())));
                }
            }
            HTAccess hTAccess = null;
            try {
                Object object;
                String string6;
                Resource resource = null;
                String string7 = string6 = string.endsWith("/") ? string : URI.parentPath(string);
                while (string6 != null) {
                    object = string6 + this._accessFile;
                    resource = this.getHttpContext().getResource((String)object);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("directory=" + string6 + " resource=" + resource));
                    }
                    if (resource != null && resource.exists() && !resource.isDirectory()) break;
                    resource = null;
                    string6 = URI.parentPath(string6);
                }
                if (resource == null && this._default != null && (!(resource = Resource.newResource(this._default)).exists() || resource.isDirectory())) {
                    return;
                }
                if (resource == null) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HTACCESS=" + resource));
                }
                if ((hTAccess = (HTAccess)this._htCache.get(resource)) == null || hTAccess.getLastModified() != resource.lastModified()) {
                    hTAccess = new HTAccess(resource);
                    this._htCache.put(resource, hTAccess);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HTCache loaded " + hTAccess));
                    }
                }
                if (string.endsWith(this._accessFile)) {
                    httpResponse.sendError(403);
                    httpRequest.setHandled(true);
                    return;
                }
                if (hTAccess.isForbidden()) {
                    log.warn((Object)("Mis-configured htaccess: " + hTAccess));
                    httpResponse.sendError(403);
                    httpRequest.setHandled(true);
                    return;
                }
                object = hTAccess.getMethods();
                if (object.size() > 0 && !object.containsKey(httpRequest.getMethod())) {
                    return;
                }
                int n = hTAccess.getSatisfy();
                bl = hTAccess.checkAccess("", httpRequest.getRemoteAddr());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IPValid = " + bl));
                }
                if (bl && n == 0) {
                    return;
                }
                if (!bl && n == 1) {
                    httpResponse.sendError(403);
                    httpRequest.setHandled(true);
                    return;
                }
                if (!hTAccess.checkAuth(string4, string5, this.getHttpContext(), httpRequest)) {
                    log.debug((Object)"Auth Failed");
                    httpResponse.setField("WWW-Authenticate", "basic realm=" + hTAccess.getName());
                    httpResponse.sendError(401);
                    httpResponse.commit();
                    httpRequest.setHandled(true);
                    return;
                }
                if (string4 != null) {
                    httpRequest.setAuthType("BASIC");
                    httpRequest.setAuthUser(string4);
                }
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                if (hTAccess == null) break block20;
                httpResponse.sendError(500);
                httpRequest.setHandled(true);
            }
        }
    }

    public void setDefault(String string) {
        this._default = string;
    }

    public void setAccessFile(String string) {
        this._accessFile = string == null ? ".htaccess" : string;
    }

    private static class HTAccess {
        static final int ANY = 0;
        static final int ALL = 1;
        static final String USER = "user";
        static final String GROUP = "group";
        static final String VALID_USER = "valid-user";
        String _userFile;
        Resource _userResource;
        HashMap _users = null;
        long _userModified;
        String _groupFile;
        Resource _groupResource;
        HashMap _groups = null;
        long _groupModified;
        int _satisfy = 0;
        String _type;
        String _name;
        HashMap _methods = new HashMap();
        HashSet _requireEntities = new HashSet();
        String _requireName;
        int _order;
        ArrayList _allowList = new ArrayList();
        ArrayList _denyList = new ArrayList();
        long _lastModified;
        boolean _forbidden = false;

        public HTAccess(Resource resource) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
                this.parse(bufferedReader);
                this._lastModified = resource.lastModified();
                if (this._userFile != null) {
                    this._userResource = Resource.newResource(this._userFile);
                    if (!this._userResource.exists()) {
                        this._forbidden = true;
                        log.warn((Object)("Could not find ht user file: " + this._userFile));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("user file: " + this._userResource));
                    }
                }
                if (this._groupFile != null) {
                    this._groupResource = Resource.newResource(this._groupFile);
                    if (!this._groupResource.exists()) {
                        this._forbidden = true;
                        log.warn((Object)("Could not find ht group file: " + this._groupResource));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("group file: " + this._groupResource));
                    }
                }
            }
            catch (IOException iOException) {
                this._forbidden = true;
                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
            }
        }

        public boolean isForbidden() {
            return this._forbidden;
        }

        public HashMap getMethods() {
            return this._methods;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Resource getUserResource() {
            return this._userResource;
        }

        public Resource getGroupResource() {
            return this._groupResource;
        }

        public int getSatisfy() {
            return this._satisfy;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public boolean checkAccess(String string, String string2) {
            char c;
            String string3;
            int n;
            boolean bl = false;
            boolean bl2 = false;
            if (this._allowList.size() == 0 && this._denyList.size() == 0) {
                return true;
            }
            for (n = 0; n < this._allowList.size(); ++n) {
                string3 = (String)this._allowList.get(n);
                if (string3.equals("all")) {
                    bl = true;
                    break;
                }
                c = string3.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (!string2.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (!string.endsWith(string3)) continue;
                bl = true;
                break;
            }
            for (n = 0; n < this._denyList.size(); ++n) {
                string3 = (String)this._denyList.get(n);
                if (string3.equals("all")) {
                    bl2 = true;
                    break;
                }
                c = string3.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (!string2.startsWith(string3)) continue;
                    bl2 = true;
                    break;
                }
                if (!string.endsWith(string3)) continue;
                bl2 = true;
                break;
            }
            if (this._order < 0) {
                return !bl2 || bl;
            }
            return bl && !bl2;
        }

        public boolean checkAuth(String string, String string2, HttpContext httpContext, HttpRequest httpRequest) {
            Object object;
            Principal principal;
            if (this._requireName == null) {
                return true;
            }
            UserRealm userRealm = httpContext.getRealm();
            Principal principal2 = principal = userRealm == null ? null : userRealm.authenticate(string, string2, httpRequest);
            if (principal == null) {
                String string3;
                object = this.getUserCode(string);
                String string4 = object != null ? ((String)object).substring(0, 2) : string;
                String string5 = string3 = string != null && string2 != null ? UnixCrypt.crypt(string2, string4) : null;
                if (object == null || ((String)object).equals("") && !string2.equals("") || !((String)object).equals(string3)) {
                    return false;
                }
            }
            if (this._requireName.equalsIgnoreCase(USER)) {
                if (this._requireEntities.contains(string)) {
                    return true;
                }
            } else if (this._requireName.equalsIgnoreCase(GROUP)) {
                object = this.getUserGroups(string);
                if (object != null) {
                    int n = ((ArrayList)object).size();
                    while (n-- > 0) {
                        if (!this._requireEntities.contains(((ArrayList)object).get(n))) continue;
                        return true;
                    }
                }
            } else if (this._requireName.equalsIgnoreCase(VALID_USER)) {
                return true;
            }
            return false;
        }

        public boolean isAccessLimited() {
            return this._allowList.size() > 0 || this._denyList.size() > 0;
        }

        public boolean isAuthLimited() {
            return this._requireName != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private String getUserCode(String string) {
            block15: {
                if (this._userResource == null) {
                    return null;
                }
                if (this._users == null || this._userModified != this._userResource.lastModified()) {
                    String string2;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LOAD " + this._userResource));
                    }
                    this._users = new HashMap();
                    BufferedReader bufferedReader = null;
                    bufferedReader = new BufferedReader(new InputStreamReader(this._userResource.getInputStream()));
                    this._userModified = this._userResource.lastModified();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n;
                        if ((string2 = string2.trim()).startsWith("#") || (n = string2.indexOf(58)) < 0) continue;
                        String string3 = string2.substring(0, n).trim();
                        String string4 = string2.substring(n + 1).trim();
                        this._users.put(string3, string4);
                    }
                    Object var8_8 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                    }
                    break block15;
                    {
                        catch (IOException iOException) {
                            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                            Object var8_9 = null;
                            try {
                                if (bufferedReader != null) {
                                    bufferedReader.close();
                                }
                                break block15;
                            }
                            catch (IOException iOException2) {
                                log.warn((Object)"EXCEPTION ", (Throwable)iOException2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                        }
                        throw throwable;
                    }
                }
            }
            return (String)this._users.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private ArrayList getUserGroups(String string) {
            block17: {
                if (this._groupResource == null) {
                    return null;
                }
                if (this._groups == null || this._groupModified != this._groupResource.lastModified()) {
                    String string2;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LOAD " + this._groupResource));
                    }
                    this._groups = new HashMap();
                    BufferedReader bufferedReader = null;
                    bufferedReader = new BufferedReader(new InputStreamReader(this._groupResource.getInputStream()));
                    this._groupModified = this._groupResource.lastModified();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer;
                        if ((string2 = string2.trim()).startsWith("#") || string2.length() == 0 || !(stringTokenizer = new StringTokenizer(string2, ": \t")).hasMoreTokens()) continue;
                        String string3 = stringTokenizer.nextToken();
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken();
                            ArrayList<String> arrayList = (ArrayList<String>)this._groups.get(string4);
                            if (arrayList == null) {
                                arrayList = new ArrayList<String>();
                                this._groups.put(string4, arrayList);
                            }
                            arrayList.add(string3);
                        }
                    }
                    Object var9_9 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                    }
                    break block17;
                    {
                        catch (IOException iOException) {
                            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                            Object var9_10 = null;
                            try {
                                if (bufferedReader != null) {
                                    bufferedReader.close();
                                }
                                break block17;
                            }
                            catch (IOException iOException2) {
                                log.warn((Object)"EXCEPTION ", (Throwable)iOException2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                        }
                        throw throwable;
                    }
                }
            }
            return (ArrayList)this._groups.get(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("AuthUserFile=");
            stringBuffer.append(this._userFile);
            stringBuffer.append(", AuthGroupFile=");
            stringBuffer.append(this._groupFile);
            stringBuffer.append(", AuthName=");
            stringBuffer.append(this._name);
            stringBuffer.append(", AuthType=");
            stringBuffer.append(this._type);
            stringBuffer.append(", Methods=");
            stringBuffer.append(this._methods);
            stringBuffer.append(", satisfy=");
            stringBuffer.append(this._satisfy);
            if (this._order < 0) {
                stringBuffer.append(", order=deny,allow");
            } else if (this._order > 0) {
                stringBuffer.append(", order=allow,deny");
            } else {
                stringBuffer.append(", order=mutual-failure");
            }
            stringBuffer.append(", Allow from=");
            stringBuffer.append(this._allowList);
            stringBuffer.append(", deny from=");
            stringBuffer.append(this._denyList);
            stringBuffer.append(", requireName=");
            stringBuffer.append(this._requireName);
            stringBuffer.append(" ");
            stringBuffer.append(this._requireEntities);
            return stringBuffer.toString();
        }

        private void parse(BufferedReader bufferedReader) throws IOException {
            String string;
            block0: while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#")) continue;
                if (string.startsWith("AuthUserFile")) {
                    this._userFile = string.substring(13).trim();
                    continue;
                }
                if (string.startsWith("AuthGroupFile")) {
                    this._groupFile = string.substring(14).trim();
                    continue;
                }
                if (string.startsWith("AuthName")) {
                    this._name = string.substring(8).trim();
                    continue;
                }
                if (string.startsWith("AuthType")) {
                    this._type = string.substring(8).trim();
                    continue;
                }
                if (!string.startsWith("<Limit")) continue;
                int n = string.length();
                int n2 = string.indexOf(62);
                if (n2 < 0) {
                    n2 = n;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(6, n2));
                while (stringTokenizer.hasMoreTokens()) {
                    this._methods.put(stringTokenizer.nextToken(), Boolean.TRUE);
                }
                while ((string = bufferedReader.readLine()) != null) {
                    int n3;
                    int n4;
                    if ((string = string.trim()).startsWith("#")) continue;
                    if (string.startsWith("satisfy")) {
                        n = string.length();
                        for (n4 = 7; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        for (n3 = n4; n3 < n && string.charAt(n3) > ' '; ++n3) {
                        }
                        String string2 = string.substring(n4, n3);
                        if (string2.equals("all")) {
                            this._satisfy = 1;
                            continue;
                        }
                        if (!string2.equals("any")) continue;
                        this._satisfy = 0;
                        continue;
                    }
                    if (string.startsWith("require")) {
                        n = string.length();
                        for (n4 = 7; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        for (n3 = n4; n3 < n && string.charAt(n3) > ' '; ++n3) {
                        }
                        this._requireName = string.substring(n4, n3).toLowerCase();
                        if (USER.equals(this._requireName)) {
                            this._requireName = USER;
                        } else if (GROUP.equals(this._requireName)) {
                            this._requireName = GROUP;
                        } else if (VALID_USER.equals(this._requireName)) {
                            this._requireName = VALID_USER;
                        }
                        if ((n4 = n3 + 1) >= n) continue;
                        while (n4 < n && string.charAt(n4) <= ' ') {
                            ++n4;
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n4));
                        while (stringTokenizer.hasMoreTokens()) {
                            this._requireEntities.add(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (string.startsWith("order")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("orderline=" + string + "order=" + this._order));
                        }
                        if (string.indexOf("allow,deny") > 0) {
                            log.debug((Object)"==>allow+deny");
                            this._order = 1;
                            continue;
                        }
                        if (string.indexOf("deny,allow") > 0) {
                            log.debug((Object)"==>deny,allow");
                            this._order = -1;
                            continue;
                        }
                        if (string.indexOf("mutual-failure") <= 0) continue;
                        log.debug((Object)"==>mutual");
                        this._order = 0;
                        continue;
                    }
                    if (string.startsWith("allow from")) {
                        n = string.length();
                        for (n4 = 10; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("allow process:" + string.substring(n4)));
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n4));
                        while (stringTokenizer.hasMoreTokens()) {
                            this._allowList.add(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (string.startsWith("deny from")) {
                        n = string.length();
                        for (n4 = 9; n4 < n && string.charAt(n4) <= ' '; ++n4) {
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("deny process:" + string.substring(n4)));
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n4));
                        while (stringTokenizer.hasMoreTokens()) {
                            this._denyList.add(stringTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (!string.startsWith("</Limit>")) continue;
                    continue block0;
                }
            }
        }
    }
}

