/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SSORealm;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Credential;
import org.mortbay.util.Password;
import org.mortbay.util.Resource;

public class HashUserRealm
extends HashMap
implements UserRealm,
SSORealm,
Externalizable {
    private static Log log = LogFactory.getLog(HashUserRealm.class);
    public static final String __SSO = "org.mortbay.http.SSO";
    private String _realmName;
    private String _config;
    protected HashMap _roles = new HashMap(7);
    private SSORealm _ssoRealm;

    public HashUserRealm() {
    }

    public HashUserRealm(String string) {
        this._realmName = string;
    }

    public HashUserRealm(String string, String string2) throws IOException {
        this._realmName = string;
        this.load(string2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._realmName);
        objectOutput.writeObject(this._config);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._realmName = (String)objectInput.readObject();
        this._config = (String)objectInput.readObject();
        if (this._config != null) {
            this.load(this._config);
        }
    }

    public void load(String string) throws IOException {
        this._config = string;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load " + this + " from " + string));
        }
        Properties properties = new Properties();
        Resource resource = Resource.newResource(string);
        properties.load(resource.getInputStream());
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = entry.getKey().toString().trim();
            String string3 = entry.getValue().toString().trim();
            String string4 = null;
            int n = string3.indexOf(44);
            if (n > 0) {
                string4 = string3.substring(n + 1).trim();
                string3 = string3.substring(0, n).trim();
            }
            if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0) continue;
            this.put(string2, string3);
            if (string4 == null || string4.length() <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                this.addUserToRole(string2, stringTokenizer.nextToken());
            }
        }
    }

    public void setName(String string) {
        this._realmName = string;
    }

    public String getName() {
        return this._realmName;
    }

    public Principal getPrincipal(String string) {
        return (Principal)super.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String string, Object object, HttpRequest httpRequest) {
        KnownUser knownUser;
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            knownUser = (KnownUser)super.get(string);
        }
        if (knownUser == null) {
            return null;
        }
        if (knownUser.authenticate(object)) {
            return knownUser;
        }
        return null;
    }

    public void disassociate(Principal principal) {
    }

    public Principal pushRole(Principal principal, String string) {
        if (principal == null) {
            principal = new User();
        }
        return new WrappedUser(principal, string);
    }

    public Principal popRole(Principal principal) {
        WrappedUser wrappedUser = (WrappedUser)principal;
        return wrappedUser.getUserPrincipal();
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 instanceof Principal) {
            return super.put(object.toString(), object2);
        }
        if (object2 instanceof Password) {
            return super.put(object, new KnownUser(object.toString(), (Password)object2));
        }
        if (object2 != null) {
            return super.put(object, new KnownUser(object.toString(), Credential.getCredential(object2.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String string, String string2) {
        HashSet<String> hashSet = (HashSet<String>)this._roles.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<String>(11);
            this._roles.put(string2, hashSet);
        }
        hashSet.add(string);
    }

    public boolean reauthenticate(Principal principal) {
        return ((User)principal).isAuthenticated();
    }

    public synchronized boolean isUserInRole(Principal principal, String string) {
        if (principal instanceof WrappedUser) {
            return ((WrappedUser)principal).isUserInRole(string);
        }
        if (principal == null || ((User)principal).getUserRealm() != this) {
            return false;
        }
        HashSet hashSet = (HashSet)this._roles.get(string);
        return hashSet != null && hashSet.contains(principal.getName());
    }

    public void logout(Principal principal) {
    }

    public String toString() {
        return "Realm[" + this._realmName + "]";
    }

    public void dump(PrintStream printStream) {
        printStream.println(this + ":");
        printStream.println(super.toString());
        printStream.println(this._roles);
    }

    public SSORealm getSSORealm() {
        return this._ssoRealm;
    }

    public void setSSORealm(SSORealm sSORealm) {
        this._ssoRealm = sSORealm;
    }

    public Credential getSingleSignOn(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (this._ssoRealm != null) {
            return this._ssoRealm.getSingleSignOn(httpRequest, httpResponse);
        }
        return null;
    }

    public void setSingleSignOn(HttpRequest httpRequest, HttpResponse httpResponse, Principal principal, Credential credential) {
        if (this._ssoRealm != null) {
            this._ssoRealm.setSingleSignOn(httpRequest, httpResponse, principal, credential);
        }
    }

    public void clearSingleSignOn(String string) {
        if (this._ssoRealm != null) {
            this._ssoRealm.clearSingleSignOn(string);
        }
    }

    private class WrappedUser
    extends User {
        private Principal user;
        private String role;

        WrappedUser(Principal principal, String string) {
            this.user = principal;
            this.role = string;
        }

        Principal getUserPrincipal() {
            return this.user;
        }

        public String getName() {
            return "role:" + this.role;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String string) {
            return this.role.equals(string);
        }
    }

    private class KnownUser
    extends User {
        private String _userName;
        private Credential _cred;

        KnownUser(String string, Credential credential) {
            this._userName = string;
            this._cred = credential;
        }

        boolean authenticate(Object object) {
            return this._cred != null && this._cred.check(object);
        }

        public String getName() {
            return this._userName;
        }

        public boolean isAuthenticated() {
            return true;
        }
    }

    private class User
    implements Principal {
        List roles = null;

        private User() {
        }

        private UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

