/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;

public class ClientCertAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(ClientCertAuthenticator.class);
    private int _maxHandShakeSeconds = 60;

    public ClientCertAuthenticator() {
        log.warn((Object)"Client Cert Authentication is EXPERIMENTAL");
    }

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int n) {
        this._maxHandShakeSeconds = n;
    }

    public Principal authenticate(UserRealm userRealm, String string, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        Object object;
        Object object2;
        X509Certificate[] x509CertificateArray = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (httpResponse != null && (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray[0] == null)) {
            object2 = HttpConnection.getHttpConnection().getConnection();
            if (!(object2 instanceof SSLSocket)) {
                return null;
            }
            object = (SSLSocket)object2;
            if (!((SSLSocket)object).getNeedClientAuth()) {
                ((SSLSocket)object).setNeedClientAuth(true);
                ((SSLSocket)object).startHandshake();
                int n = this._maxHandShakeSeconds * 4;
                while (n-- > 0 && ((x509CertificateArray = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate")) == null || x509CertificateArray.length <= 0 || x509CertificateArray[0] == null)) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray[0] == null) {
            return null;
        }
        object2 = x509CertificateArray[0].getSubjectDN();
        if (object2 == null) {
            object2 = x509CertificateArray[0].getIssuerDN();
        }
        object = object2 == null ? "clientcert" : object2.getName();
        Principal principal = userRealm.authenticate((String)object, x509CertificateArray, httpRequest);
        httpRequest.setAuthType("CLIENT_CERT");
        if (principal != null) {
            httpRequest.setAuthUser(principal.getName());
        }
        httpRequest.setUserPrincipal(principal);
        return principal;
    }

    public String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

