/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.Vector;

public class TetrisSzene {
    private Gitter3D m_Gitter = null;
    private SzeneObjekt[] m_BgrL;
    private SzeneObjekt[] m_Flaechen;
    private SzeneObjekt[] m_ABlock;
    private GQuadrat[] m_BlockQuad;
    private SzeneObjekt[] m_SortObjekte;
    private SzeneObjekt[] m_All;
    private Color m_FLinien;
    private Color m_FBlock;
    private Beleuchtungsmodell m_BModell = new Beleuchtungsmodell();

    public TetrisSzene() {
        this.m_BgrL = new SzeneObjekt[0];
        this.m_Flaechen = this.m_BgrL;
        this.m_ABlock = this.m_BgrL;
        this.m_SortObjekte = this.m_BgrL;
        this.m_All = this.m_BgrL;
    }

    public TetrisSzene(Gitter3D gitter3D, Color color, Color color2) {
        this();
        this.m_Gitter = gitter3D;
        this.m_FLinien = color;
        this.m_FBlock = color2;
    }

    public void setGitter(Gitter3D gitter3D) {
        this.m_Gitter = gitter3D;
    }

    public void nurBgrLinien() {
        this.m_All = this.m_BgrL;
    }

    public void setBgrL(Vector vector) {
        this.m_BgrL = new SzeneObjekt[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.m_BgrL[n] = new SzeneLinie((GLinie)vector.elementAt(n));
            this.m_BgrL[n].berechnen();
            ++n;
        }
        this.m_BgrL = (SzeneObjekt[])EfgSort.sortieren(null, this.m_BgrL, true);
        this.m_SortObjekte = this.m_BgrL;
        this.m_All = this.m_BgrL;
    }

    public void setABlock(TetrisBlock tetrisBlock) {
        if (tetrisBlock == null) {
            return;
        }
        this.m_BlockQuad = tetrisBlock.ermFlaechen();
        this.m_ABlock = new SzeneObjekt[this.m_BlockQuad.length];
        int n = 0;
        while (n < this.m_BlockQuad.length) {
            this.m_ABlock[n] = new SzeneQuadrat(this.m_BlockQuad[n]);
            this.m_ABlock[n].berechnen();
            ++n;
        }
        this.m_All = (SzeneObjekt[])EfgSort.sortieren(this.m_SortObjekte, this.m_ABlock, true);
    }

    public void setFlaechen(GQuadrat[] gQuadratArray) {
        this.m_Flaechen = new SzeneObjekt[gQuadratArray.length];
        int n = 0;
        while (n < gQuadratArray.length) {
            this.m_Flaechen[n] = new SzeneQuadrat(gQuadratArray[n]);
            this.m_Flaechen[n].berechnen();
            ++n;
        }
        this.m_SortObjekte = (SzeneObjekt[])EfgSort.sortieren(this.m_BgrL, this.m_Flaechen, true);
        this.m_All = this.m_SortObjekte;
    }

    public void darstellen(Graphics graphics) {
        int n = 0;
        while (n < this.m_All.length) {
            this.m_All[n].zeichnen(graphics);
            ++n;
        }
    }

    public final void neu() {
        int n = 0;
        while (n < this.m_BgrL.length) {
            this.m_BgrL[n].berechnen();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_Flaechen.length) {
            this.m_Flaechen[n2].berechnen();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.m_ABlock.length) {
            this.m_ABlock[n3].berechnen();
            ++n3;
        }
        this.m_BgrL = (SzeneObjekt[])EfgSort.sortieren(null, this.m_BgrL, true);
        this.m_SortObjekte = (SzeneObjekt[])EfgSort.sortieren(this.m_BgrL, this.m_Flaechen, true);
        this.m_All = (SzeneObjekt[])EfgSort.sortieren(this.m_SortObjekte, this.m_ABlock, true);
    }

    public void blockSortieren() {
        int n = 0;
        while (n < this.m_ABlock.length) {
            this.m_ABlock[n].berechnen();
            ++n;
        }
        this.m_All = (SzeneObjekt[])EfgSort.sortieren(this.m_SortObjekte, this.m_ABlock, true);
    }

    abstract class SzeneObjekt
    implements Vergleich {
        GitterElement m_Elm;
        Punkt3D m_PMittel;

        public SzeneObjekt(GitterElement gitterElement) {
            TetrisSzene.this = TetrisSzene.this;
            this.m_Elm = gitterElement;
        }

        public void berechnen() {
            GPunkt[] gPunktArray = this.m_Elm.ermPunkte();
            this.m_PMittel = TetrisSzene.this.m_Gitter.ermP3D(gPunktArray[0]);
            if (gPunktArray.length < 2) {
                return;
            }
            this.m_PMittel = Punkt3D.plus(this.m_PMittel, TetrisSzene.this.m_Gitter.ermP3D(gPunktArray[1]));
            int n = 2;
            while (n < gPunktArray.length) {
                this.m_PMittel.plus(TetrisSzene.this.m_Gitter.ermP3D(gPunktArray[n]));
                ++n;
            }
            this.m_PMittel.div(n);
        }

        public abstract void zeichnen(Graphics var1);

        public short vergleichen(Vergleich vergleich) {
            SzeneObjekt szeneObjekt = (SzeneObjekt)vergleich;
            if (this.m_PMittel == null || szeneObjekt.m_PMittel == null) {
                return -1;
            }
            if (this.m_PMittel.ermZ() == szeneObjekt.m_PMittel.ermZ()) {
                return 0;
            }
            if (this.m_PMittel.ermZ() > szeneObjekt.m_PMittel.ermZ()) {
                return 1;
            }
            if (this.m_PMittel.ermZ() < szeneObjekt.m_PMittel.ermZ()) {
                return 2;
            }
            return -1;
        }
    }

    class SzeneLinie
    extends SzeneObjekt {
        public SzeneLinie(GLinie gLinie) {
            super(gLinie);
            TetrisSzene.this = TetrisSzene.this;
        }

        public void zeichnen(Graphics graphics) {
            GPunkt[] gPunktArray = this.m_Elm.ermPunkte();
            Bildpunkt bildpunkt = TetrisSzene.this.m_Gitter.ermPBild(gPunktArray[0]);
            Bildpunkt bildpunkt2 = TetrisSzene.this.m_Gitter.ermPBild(gPunktArray[1]);
            graphics.setColor(TetrisSzene.this.m_FLinien);
            graphics.drawLine(bildpunkt.ermX(), bildpunkt.ermY(), bildpunkt2.ermX(), bildpunkt2.ermY());
        }
    }

    class SzeneQuadrat
    extends SzeneObjekt {
        Punkt3D m_Normale = new Punkt3D();

        public SzeneQuadrat(GQuadrat gQuadrat) {
            super(gQuadrat);
            TetrisSzene.this = TetrisSzene.this;
        }

        public void zeichnen(Graphics graphics) {
            GPunkt[] gPunktArray = this.m_Elm.ermPunkte();
            Bildpunkt bildpunkt = TetrisSzene.this.m_Gitter.ermPBild(gPunktArray[0]);
            Bildpunkt bildpunkt2 = TetrisSzene.this.m_Gitter.ermPBild(gPunktArray[1]);
            Bildpunkt bildpunkt3 = TetrisSzene.this.m_Gitter.ermPBild(gPunktArray[2]);
            Bildpunkt bildpunkt4 = TetrisSzene.this.m_Gitter.ermPBild(gPunktArray[3]);
            int[] nArray = new int[]{bildpunkt.ermX(), bildpunkt2.ermX(), bildpunkt3.ermX(), bildpunkt4.ermX()};
            int[] nArray2 = new int[]{bildpunkt.ermY(), bildpunkt2.ermY(), bildpunkt3.ermY(), bildpunkt4.ermY()};
            Polygon polygon = new Polygon(nArray, nArray2, 4);
            if (TetrisSzene.this.m_BModell.isRenderable()) {
                graphics.setColor(TetrisSzene.this.m_BModell.getOFFarbe(this.m_Elm.ermFarbe(), this.m_Normale));
                graphics.fillPolygon(polygon);
                return;
            }
            graphics.setColor(this.m_Elm.ermFarbe());
            graphics.fillPolygon(polygon);
            graphics.setColor(TetrisSzene.this.m_FBlock);
            graphics.drawPolygon(polygon);
        }

        public void berechnen() {
            super.berechnen();
            GPunkt[] gPunktArray = this.m_Elm.ermPunkte();
            Punkt3D punkt3D = TetrisSzene.this.m_Gitter.ermP3D(gPunktArray[0]);
            Punkt3D punkt3D2 = TetrisSzene.this.m_Gitter.ermP3D(gPunktArray[1]);
            Punkt3D punkt3D3 = TetrisSzene.this.m_Gitter.ermP3D(gPunktArray[2]);
            double d = punkt3D2.ermX() - punkt3D.ermX();
            double d2 = punkt3D2.ermY() - punkt3D.ermY();
            double d3 = punkt3D2.ermZ() - punkt3D.ermZ();
            double d4 = punkt3D3.ermX() - punkt3D.ermX();
            double d5 = punkt3D3.ermY() - punkt3D.ermY();
            double d6 = punkt3D3.ermZ() - punkt3D.ermZ();
            this.m_Normale.setPkt(d2 * d6 - d3 * d5, d3 * d4 - d * d6, d * d5 - d2 * d4);
        }
    }
}

