/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public abstract class TetrisBlock
implements GitterElement,
Cloneable {
    private GWuerfel[] m_Wuerfel;

    protected void setKoerper(GPunkt[] gPunktArray, Color color) {
        this.m_Wuerfel = new GWuerfel[gPunktArray.length];
        int n = 0;
        while (n < gPunktArray.length) {
            this.m_Wuerfel[n] = new GWuerfel(gPunktArray[n].ermBIndex(), gPunktArray[n].ermLIndex(), gPunktArray[n].ermHIndex(), color);
            ++n;
        }
    }

    public GQuadrat[] ermFlaechen() {
        Vergleich[] vergleichArray = new GQuadrat[]{};
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            vergleichArray = (GQuadrat[])EfgSort.sortieren(vergleichArray, this.m_Wuerfel[n].ermFlaechen(), false);
            ++n;
        }
        return vergleichArray;
    }

    public void ebenen(int n) {
        int n2 = 0;
        while (n2 < this.m_Wuerfel.length) {
            this.m_Wuerfel[n2].ebenen(n);
            ++n2;
        }
    }

    public void zeilen(int n) {
        int n2 = 0;
        while (n2 < this.m_Wuerfel.length) {
            this.m_Wuerfel[n2].zeilen(n);
            ++n2;
        }
    }

    public void spalten(int n) {
        int n2 = 0;
        while (n2 < this.m_Wuerfel.length) {
            this.m_Wuerfel[n2].spalten(n);
            ++n2;
        }
    }

    public void zurueck() {
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            this.m_Wuerfel[n].zurueck();
            ++n;
        }
    }

    public void rotZ(Punkt3D punkt3D) {
        punkt3D = this.ermPunkt(3);
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            this.m_Wuerfel[n].rotZ(punkt3D);
            ++n;
        }
    }

    public void rotY(Punkt3D punkt3D) {
        punkt3D = this.ermPunkt(2);
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            this.m_Wuerfel[n].rotY(punkt3D);
            ++n;
        }
    }

    public void rotX(Punkt3D punkt3D) {
        punkt3D = this.ermPunkt(1);
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            this.m_Wuerfel[n].rotX(punkt3D);
            ++n;
        }
    }

    private Punkt3D ermPunkt(int n) {
        Punkt3D punkt3D = this.berechneSchwerpunkt();
        switch (n) {
            case 1: {
                double[] dArray = this.berechneNPunkt(punkt3D.ermY(), punkt3D.ermZ());
                punkt3D.setPkt(punkt3D.ermX(), dArray[0], dArray[1]);
                break;
            }
            case 2: {
                double[] dArray = this.berechneNPunkt(punkt3D.ermX(), punkt3D.ermZ());
                punkt3D.setPkt(dArray[0], punkt3D.ermY(), dArray[1]);
                break;
            }
            case 3: {
                double[] dArray = this.berechneNPunkt(punkt3D.ermX(), punkt3D.ermY());
                punkt3D.setPkt(dArray[0], dArray[1], punkt3D.ermZ());
                break;
            }
            default: {
                return null;
            }
        }
        return punkt3D;
    }

    private Punkt3D berechneSchwerpunkt() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            d += (double)this.m_Wuerfel[n].ermBIndex();
            d2 += (double)this.m_Wuerfel[n].ermHIndex();
            d3 += (double)this.m_Wuerfel[n].ermLIndex();
            ++n;
        }
        return new Punkt3D(d / (double)this.m_Wuerfel.length, d2 / (double)this.m_Wuerfel.length, d3 / (double)this.m_Wuerfel.length);
    }

    private double[] berechneNPunkt(double d, double d2) {
        double d3 = d - (double)((int)d) < 0.5 ? (double)((int)d) : (double)((int)d) + 1.0;
        double d4 = (double)((int)d) + 0.5;
        double d5 = d2 - (double)((int)d2) < 0.5 ? (double)((int)d2) : (double)((int)d2) + 1.0;
        double d6 = (double)((int)d2) + 0.5;
        double d7 = Math.sqrt(d * d + d2 * d2);
        double d8 = Math.sqrt(d3 * d3 + d5 * d5);
        double d9 = Math.sqrt(d4 * d4 + d6 * d6);
        double[] dArray = new double[2];
        if (Math.abs(d7 - d8) > Math.abs(d7 - d9)) {
            dArray[0] = d4;
            dArray[1] = d6;
        } else {
            dArray[0] = d3;
            dArray[1] = d5;
        }
        return dArray;
    }

    public GWuerfel[] ermWuerfel() {
        return this.m_Wuerfel;
    }

    public Object clone() {
        TetrisBlock tetrisBlock;
        try {
            tetrisBlock = (TetrisBlock)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            return null;
        }
        tetrisBlock.m_Wuerfel = new GWuerfel[this.m_Wuerfel.length];
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            tetrisBlock.m_Wuerfel[n] = (GWuerfel)this.m_Wuerfel[n].clone();
            ++n;
        }
        return tetrisBlock;
    }

    public int[] ermEDim() {
        int[] nArray = new int[2];
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            if (n == 0) {
                nArray[0] = nArray[1] = this.m_Wuerfel[n].ermHIndex();
            }
            if (nArray[0] > this.m_Wuerfel[n].ermHIndex()) {
                nArray[0] = this.m_Wuerfel[n].ermHIndex();
            } else if (nArray[1] < this.m_Wuerfel[n].ermHIndex()) {
                nArray[1] = this.m_Wuerfel[n].ermHIndex();
            }
            ++n;
        }
        return nArray;
    }

    public int[] ermZDim() {
        int[] nArray = new int[2];
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            if (n == 0) {
                nArray[0] = nArray[1] = this.m_Wuerfel[n].ermLIndex();
            }
            if (nArray[0] > this.m_Wuerfel[n].ermLIndex()) {
                nArray[0] = this.m_Wuerfel[n].ermLIndex();
            } else if (nArray[1] < this.m_Wuerfel[n].ermLIndex()) {
                nArray[1] = this.m_Wuerfel[n].ermLIndex();
            }
            ++n;
        }
        return nArray;
    }

    public int[] ermSDim() {
        int[] nArray = new int[2];
        int n = 0;
        while (n < this.m_Wuerfel.length) {
            if (n == 0) {
                nArray[0] = nArray[1] = this.m_Wuerfel[n].ermBIndex();
            }
            if (nArray[0] > this.m_Wuerfel[n].ermBIndex()) {
                nArray[0] = this.m_Wuerfel[n].ermBIndex();
            } else if (nArray[1] < this.m_Wuerfel[n].ermBIndex()) {
                nArray[1] = this.m_Wuerfel[n].ermBIndex();
            }
            ++n;
        }
        return nArray;
    }

    public GPunkt[] ermPunkte() {
        return null;
    }

    public Color ermFarbe() {
        return Color.black;
    }

    public int[] ermDim() {
        int[] nArray = new int[3];
        return nArray;
    }
}

