/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageCanvas
extends Canvas {
    private Image image;
    private Image image1;
    private Image image2;
    private Image image3;
    private ImageObserver imageObserver;
    private int x;
    private int y;
    private int width;
    private int height;
    boolean aktiv = false;
    private static URL docbase;

    public ImageCanvas(URL uRL) {
        this.setImage(null, null, 0, 0, 0, 0);
        docbase = uRL;
        this.setBackground(Color.lightGray);
        this.setForeground(Color.lightGray);
        this.setSize(0, 0);
    }

    public ImageCanvas(String string, int n, int n2) {
        this.setJarImage(string, n, n2);
    }

    public ImageCanvas(Image image, int n, int n2) {
        this.setImage(image, null, 0, 0, n, n2);
    }

    public ImageCanvas(String string, String string2, String string3, int n, int n2) {
        this.setJarImage(string, string2, string3, n, n2);
    }

    public ImageCanvas(Image image, Image image2, Image image3, int n, int n2) {
        this.setImage(image, image2, image3, n, n2);
    }

    public void setAktiv(boolean bl) {
        this.aktiv = bl;
    }

    public void setImage(String string, int n, int n2) {
        if (docbase == null) {
            this.image = Toolkit.getDefaultToolkit().getImage(string);
            this.setImage(this.image, null, 0, 0, n, n2);
            return;
        }
        try {
            this.image = Toolkit.getDefaultToolkit().getImage(new URL(docbase, string));
            this.setImage(this.image, null, 0, 0, n, n2);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    public void setJarImage(String string, int n, int n2) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this.image = Toolkit.getDefaultToolkit().createImage(byArray);
                this.setImage(this.image, null, 0, 0, n, n2);
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        this.setImage(string, n, n2);
    }

    public void setImage(String string, String string2, String string3, int n, int n2) {
        if (docbase == null) {
            this.image1 = Toolkit.getDefaultToolkit().getImage(string);
            this.image2 = Toolkit.getDefaultToolkit().getImage(string2);
            this.image3 = Toolkit.getDefaultToolkit().getImage(string3);
            this.setImage(this.image1, null, 0, 0, n, n2);
        } else {
            try {
                this.image1 = Toolkit.getDefaultToolkit().getImage(new URL(docbase, string));
                this.image2 = Toolkit.getDefaultToolkit().getImage(new URL(docbase, string2));
                this.image3 = Toolkit.getDefaultToolkit().getImage(new URL(docbase, string3));
                this.setImage(this.image1, null, 0, 0, n, n2);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.addMouseListener(new SymMouse());
    }

    public void setJarImage(String string, String string2, String string3, int n, int n2) {
        byte[] byArray;
        boolean bl = false;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this.image1 = Toolkit.getDefaultToolkit().createImage(byArray);
                this.setImage(this.image1, null, 0, 0, n, n2);
                inputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            bl = true;
        }
        if ((inputStream = this.getClass().getResourceAsStream(string2)) != null) {
            try {
                byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this.image2 = Toolkit.getDefaultToolkit().createImage(byArray);
                inputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            bl = true;
        }
        if ((inputStream = this.getClass().getResourceAsStream(string3)) != null) {
            try {
                byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this.image3 = Toolkit.getDefaultToolkit().createImage(byArray);
                inputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            bl = true;
        }
        if (bl) {
            this.setImage(string, string2, string3, n, n2);
            return;
        }
        this.addMouseListener(new SymMouse());
    }

    public void setImage(Image image, Image image2, Image image3, int n, int n2) {
        this.image1 = image;
        this.image2 = image2;
        this.image3 = image3;
        this.setImage(this.image1, null, 0, 0, n, n2);
        this.addMouseListener(new SymMouse());
    }

    public void setImage(Image image, ImageObserver imageObserver, int n, int n2, int n3, int n4) {
        this.image = image;
        this.imageObserver = imageObserver == null ? this : imageObserver;
        if (this.image != null) {
            if (this.checkImage(this.image, this.imageObserver) > 0) {
                this.imageUpdate(this.image, 32, 0, 0, 0, 0);
            } else {
                this.prepareImage(this.image, this.imageObserver);
            }
        }
        this.setSize(n3, n4);
        this.width = n3;
        this.height = n4;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 32) {
            return true;
        }
        this.repaint();
        return false;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void paint(Graphics graphics) {
        this.setSize(this.width, this.height);
        graphics.clipRect(this.x, this.y, this.width, this.height);
        if (this.checkImage(this.image, this.imageObserver) != 64 && this.image != null) {
            graphics.drawImage(this.image, this.x, this.y, this.imageObserver);
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(this.x, this.y, this.width - 1, this.height - 1, true);
    }

    public void presskey() {
        if (this.aktiv) {
            this.setImage(this.image3, null, 0, 0, this.width, this.height);
            return;
        }
        this.setImage(this.image1, null, 0, 0, this.width, this.height);
    }

    public void releasekey() {
        this.setImage(this.image1, null, 0, 0, this.width, this.height);
    }

    class SymMouse
    extends MouseAdapter {
        boolean mode;

        public void mousePressed(MouseEvent mouseEvent) {
            ImageCanvas.this.presskey();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ImageCanvas.this.aktiv) {
                ImageCanvas.this.setImage(ImageCanvas.this.image2, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
                return;
            }
            ImageCanvas.this.setImage(ImageCanvas.this.image1, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ImageCanvas.this.aktiv) {
                this.mode = true;
                ImageCanvas.this.setImage(ImageCanvas.this.image2, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
                return;
            }
            ImageCanvas.this.setImage(ImageCanvas.this.image1, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (ImageCanvas.this.aktiv) {
                this.mode = false;
                ImageCanvas.this.setImage(ImageCanvas.this.image1, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
                return;
            }
            ImageCanvas.this.setImage(ImageCanvas.this.image1, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.mode && ImageCanvas.this.aktiv) {
                ImageCanvas.this.setImage(ImageCanvas.this.image2, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
                return;
            }
            ImageCanvas.this.setImage(ImageCanvas.this.image1, null, 0, 0, ImageCanvas.this.width, ImageCanvas.this.height);
        }

        SymMouse() {
            ImageCanvas.this = ImageCanvas.this;
        }
    }
}

