/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.ConfigurationFacade;
import com.pmease.quickbuild.model.BuildSettingFacade;
import com.pmease.quickbuild.model.VariableFacade;

import java.net.MalformedURLException;

/**
 * This sample demonstrates how to trigger build. Typical scenarios you may want to trigger build programmatically:
 * 1. Trigger a build right away when somebody checks code into the version control system. In order to do this, your
 * version control system should support some form of checkin triggers, and you need to hook this program to that trigger.
 * 2. After a project have been built, you want to build other projects that depend on it. To do this, you
 * call this program in the build script just before build finish.
 */
public class TriggerBuild {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // Specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // Specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");
        ConfigurationFacade configuration = remote.getConfigurationByHierarchyName("root.live-samples.sample1");
        if (configuration == null)
            throw new RuntimeException("Configuration does not exist!");

        BuildSettingFacade buildSetting = new BuildSettingFacade();
        buildSetting.setBuildCleanly(true);
        buildSetting.setBuildNecessaryCondition("effectingRepositoriesModified");

        // You can optionally specify what version to build as.
        //buildSetting.setBuildAsVersion("test-1.0.0");

        // You can optionall specify some variables.
/*
        VariableFacade variable = new VariableFacade();
        variable.setValue("value1");
        buildSetting.getVariables().put("var1", variable);
*/

        remote.triggerBuild(configuration.getId(), buildSetting);

        System.out.println("Build triggered successfully!");
    }
}
