/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.ConfigurationFacade;
import com.pmease.quickbuild.model.BuildFacade;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Iterator;
import java.util.Date;

/**
 * This sample demonstrates how to delete un-wanted builds. This program is useful to implement your
 * own build clean up strategy.
 */
public class DeleteUnwantedBuilds {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        ConfigurationFacade configuration = remote.getConfigurationByHierarchyName("root.live-samples.test");
        if (configuration == null)
            throw new RuntimeException("Can not find specified configuration!");
        List builds = remote.getHistoryBuilds(configuration.getId());

        // we want to erase all failed builds older than 30 days.
        Date yesterday = new Date(System.currentTimeMillis() - 30*24* 3600* 1000L);
        for (Iterator it = builds.iterator(); it.hasNext();) {
            BuildFacade build = (BuildFacade) it.next();
            if (build.getStatus().equals("failed") && build.getEndDate().compareTo(yesterday) <= 0) {
                System.out.println("Deleting build: " + build.getVersion());
                remote.deleteBuild(build.getId());
            }
        }
        System.out.println("Un-wanted builds have been deleted successfully!");
    }
}
