/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.schedule.CronScheduleFacade;
import com.pmease.quickbuild.step.CheckoutStepFacade;
import com.pmease.quickbuild.step.BuildStepFacade;
import com.pmease.quickbuild.step.SerialStepFacade;
import com.pmease.quickbuild.repository.CvsRepositoryFacade;
import com.pmease.quickbuild.repository.CvsModuleFacade;
import com.pmease.quickbuild.builder.AntBuilderFacade;
import com.pmease.quickbuild.buildcleanupstrategy.ReserveBuildsByDaysFacade;
import com.pmease.quickbuild.model.ConfigurationFacade;
import com.pmease.quickbuild.model.VariableFacade;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.rmi.dgc.VMID;

/**
 * This sample demonstrates how to create a new configuration.
 */
public class CreateConfiguration {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        // get the parent configuration.
        ConfigurationFacade parent = remote.getConfigurationByHierarchyName("root.live-samples");
        if (parent == null)
            throw new RuntimeException("Can not find specified configuration!");

        ConfigurationFacade configuration = new ConfigurationFacade();
        configuration.setGuid(new VMID().toString()); // make sure to call this for new configuration
        configuration.setParent(parent.getId());
        configuration.setName("test");
        configuration.setNextBuildVersion("test-1.0.0");
        configuration.setStatus("created"); // created, running, successful, or failed
        configuration.setStatusDate(new Date());
        configuration.setBuildCleanly(true);
        ReserveBuildsByDaysFacade buildCleanupStrategy = new ReserveBuildsByDaysFacade();
        buildCleanupStrategy.setDaysToReserve(30);
        configuration.setBuildCleanupStrategy(buildCleanupStrategy);
        configuration.setConfigurationSpecificPublishDir("${name}");
        configuration.setConfigurationSpecificWorkingDir("${name}");
        configuration.setBuildNecessaryCondition("effectingRepositoriesModified");
        configuration.setLogLevel("verbose"); // verbose, normal, or brief
        CronScheduleFacade schedule = new CronScheduleFacade();
        schedule.setExpression("0 0 1 * * ?");
        configuration.setSchedule(schedule);

        /**
         * Define a CVS repository.
         */
        CvsRepositoryFacade repository = new CvsRepositoryFacade();
        repository.setName("repository1");
        repository.setCvsExecutablePath("c:\\program files\\cvsnt\\cvs.exe");
        repository.setCvsRoot(":pserver:anonymous@livedemo.pmease.com:/home/cvsroot");
        CvsModuleFacade module = new CvsModuleFacade();
        module.setSrcPath("sample1");
        repository.getModules().add(module);
        configuration.getRepositories().add(repository);

        /**
         * Define an Ant builder.
         */
        AntBuilderFacade builder = new AntBuilderFacade();
        builder.setName("builder1");
        builder.setAntExecutablePath("C:\\apache-ant-1.6.3\\bin\\ant.bat");
        builder.setBuildScriptPath("sample1/build/build.xml");
        builder.setBuildSuccessCondition("this.result==0 and this.logContainsLine(\"BUILD SUCCESSFUL\")");
        // define environments in order to use JDK1.5 to build
        VariableFacade variable = new VariableFacade();
        variable.setValue("C:\\Program Files\\Java\\jdk1.5.0");
        builder.getEnvironments().put("JAVA_HOME", variable);
        // define builder properties
        variable = new VariableFacade();
        variable.setValue("${build.version}");
        builder.getBuildProperties().put("buildVersion", variable);
        variable = new VariableFacade();
        variable.setValue("${build.junitHtmlReportDir}");
        builder.getBuildProperties().put("junitHtmlReportDir", variable);
        variable = new VariableFacade();
        variable.setValue("${build.artifactsDir}");
        builder.getBuildProperties().put("artifactsDir", variable);
        variable = new VariableFacade();
        variable.setValue("${build.cloverHtmlReportDir}");
        builder.getBuildProperties().put("cloverHtmlReportDir", variable);
        variable = new VariableFacade();
        variable.setValue("${build.startDate}");
        builder.getBuildProperties().put("buildDate", variable);
        configuration.getBuilders().add(builder);

        /**
         * Define steps.
         */
        CheckoutStepFacade checkoutStep = new CheckoutStepFacade();
        checkoutStep.setName("check out");
        checkoutStep.setRepositoryName("repository1");
        checkoutStep.setStepNecessaryCondition("!this.parent.anyChildStepFailed");
        configuration.getSteps().add(checkoutStep);

        BuildStepFacade buildStep = new BuildStepFacade();
        buildStep.setName("build");
        buildStep.setBuilderName("builder1");
        buildStep.setStepNecessaryCondition("!this.parent.anyChildStepFailed");
        configuration.getSteps().add(buildStep);

        SerialStepFacade defaultStep = new SerialStepFacade();
        defaultStep.setName("default");
        defaultStep.setStepNecessaryCondition("!this.parent.anyChildStepFailed");
        defaultStep.setMembers(new ArrayList());
        defaultStep.getMembers().add("check out");
        defaultStep.getMembers().add("build");
        defaultStep.setStepSuccessCondition("!this.anyChildStepFailed");
        configuration.getSteps().add(defaultStep);

        ConfigurationFacade configurationInQuickBuild = remote.getConfigurationByName(parent.getId(), configuration.getName());
        if (configurationInQuickBuild != null) {
            System.out.println("Configuration \"root.live-samples.test\" already exist, deleting...");
            remote.deleteConfiguration(configurationInQuickBuild.getId());
        }
        remote.saveConfiguration(configuration);
        System.out.println("Configuration has been created successfully.");
    }
}
