/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;

public class DelayInformation
implements PacketExtension {
    public static SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static SimpleDateFormat NEW_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private Date stamp;
    private String from;
    private String reason;

    public DelayInformation(Date stamp) {
        this.stamp = stamp;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Date getStamp() {
        return this.stamp;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "jabber:x:delay";
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\"");
        buf.append(" stamp=\"").append(UTC_FORMAT.format(this.stamp)).append("\"");
        if (this.from != null && this.from.length() > 0) {
            buf.append(" from=\"").append(this.from).append("\"");
        }
        buf.append(">");
        if (this.reason != null && this.reason.length() > 0) {
            buf.append(this.reason);
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        NEW_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

