/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class RoomInfo {
    private String room;
    private String description = "";
    private String subject = "";
    private int occupantsCount = -1;
    private boolean membersOnly;
    private boolean moderated;
    private boolean nonanonymous;
    private boolean passwordProtected;
    private boolean persistent;

    RoomInfo(DiscoverInfo info) {
        this.room = info.getFrom();
        this.membersOnly = info.containsFeature("muc_membersonly");
        this.moderated = info.containsFeature("muc_moderated");
        this.nonanonymous = info.containsFeature("muc_nonanonymous");
        this.passwordProtected = info.containsFeature("muc_passwordprotected");
        this.persistent = info.containsFeature("muc_persistent");
        Form form = Form.getFormFrom(info);
        if (form != null) {
            this.description = (String)form.getField("muc#roominfo_description").getValues().next();
            this.subject = (String)form.getField("muc#roominfo_subject").getValues().next();
            this.occupantsCount = Integer.parseInt((String)form.getField("muc#roominfo_occupants").getValues().next());
        }
    }

    public String getRoom() {
        return this.room;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getOccupantsCount() {
        return this.occupantsCount;
    }

    public boolean isMembersOnly() {
        return this.membersOnly;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public boolean isNonanonymous() {
        return this.nonanonymous;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

