/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components.table;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITableSessionStateManager;
import org.apache.tapestry.contrib.table.model.simple.SimpleListTableDataModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableSessionStateManager;
import org.apache.tapestry.contrib.tree.components.table.TreeTableColumn;
import org.apache.tapestry.contrib.tree.model.ITreeDataModel;
import org.apache.tapestry.contrib.tree.model.ITreeModel;
import org.apache.tapestry.contrib.tree.model.ITreeModelSource;
import org.apache.tapestry.contrib.tree.model.ITreeRowSource;
import org.apache.tapestry.contrib.tree.model.TreeRowObject;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;

public class TreeTableDataView
extends BaseComponent
implements ITreeRowSource,
PageDetachListener {
    private int m_nTreeDeep = -1;
    private TreeRowObject m_objTreeRowObject = null;
    private ArrayList m_arrAllExpandedNodes = null;

    public TreeTableDataView() {
        this.initialize();
    }

    public void initialize() {
        this.m_nTreeDeep = -1;
        this.m_objTreeRowObject = null;
        this.m_arrAllExpandedNodes = null;
    }

    protected void finishLoad() {
        super.finishLoad();
        this.getPage().addPageDetachListener((PageDetachListener)this);
    }

    public void pageDetached(PageEvent arg0) {
        this.initialize();
    }

    public ITreeModelSource getTreeModelSource() {
        ITreeModelSource objSource = (ITreeModelSource)this.getPage().getRequestCycle().getAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource");
        if (objSource == null) {
            objSource = (ITreeModelSource)this.getBinding("treeView").getObject();
        }
        return objSource;
    }

    public ArrayList generateNodeList() {
        if (this.m_arrAllExpandedNodes == null) {
            ITreeModelSource objTreeModelSource = this.getTreeModelSource();
            ITreeModel objTreeModel = objTreeModelSource.getTreeModel();
            ITreeDataModel objTreeDataModel = objTreeModel.getTreeDataModel();
            Object objValue = objTreeDataModel.getRoot();
            Object objValueUID = objTreeDataModel.getUniqueKey(objValue, null);
            ArrayList arrAllExpandedNodes = new ArrayList();
            this.walkTree(arrAllExpandedNodes, objValue, objValueUID, 0, objTreeModel);
            this.m_arrAllExpandedNodes = arrAllExpandedNodes;
        }
        return this.m_arrAllExpandedNodes;
    }

    public void walkTree(ArrayList arrAllExpandedNodes, Object objParent, Object objParentUID, int nDepth, ITreeModel objTreeModel) {
        this.m_nTreeDeep = nDepth;
        TreeRowObject objTreeRowObject = new TreeRowObject(objParent, objParentUID, nDepth);
        arrAllExpandedNodes.add(objTreeRowObject);
        boolean bContain = objTreeModel.getTreeStateModel().isUniqueKeyExpanded(objParentUID);
        if (bContain) {
            Iterator colChildren;
            Iterator iter = colChildren = objTreeModel.getTreeDataModel().getChildren(objParent);
            while (iter.hasNext()) {
                Object objChild = iter.next();
                Object objChildUID = objTreeModel.getTreeDataModel().getUniqueKey(objChild, objParentUID);
                this.walkTree(arrAllExpandedNodes, objChild, objChildUID, nDepth + 1, objTreeModel);
            }
        }
    }

    public int getTreeDeep() {
        return this.m_nTreeDeep;
    }

    public ITableModel getTableModel() {
        return this.createTableModel();
    }

    private ITableModel createTableModel() {
        ArrayList arrAllNodes = this.generateNodeList();
        Object[] arrAllExpandedNodes = new Object[arrAllNodes.size()];
        arrAllNodes.toArray(arrAllExpandedNodes);
        SimpleTableModel objTableModel = new SimpleTableModel(arrAllExpandedNodes, this.getTableColunms());
        objTableModel.getPagingState().setPageSize(this.getEntriesPerTablePage());
        return objTableModel;
    }

    public ITableColumn[] getTableColunms() {
        ArrayList<TreeTableColumn> arrColumnsList = new ArrayList<TreeTableColumn>();
        arrColumnsList.add(new TreeTableColumn("Name", false, null));
        ArrayList arrTableColunms = this.getTableColunmsFromBinding();
        if (arrTableColunms != null) {
            arrColumnsList.addAll(arrTableColunms);
        }
        ITableColumn[] arrColumns = new ITableColumn[arrColumnsList.size()];
        arrColumnsList.toArray(arrColumns);
        return arrColumns;
    }

    public ArrayList getTableColunmsFromBinding() {
        IBinding objBinding = this.getBinding("tableColunms");
        if (objBinding != null) {
            return (ArrayList)objBinding.getObject();
        }
        return null;
    }

    public int getEntriesPerTablePage() {
        IBinding objBinding = this.getBinding("entriesPerTablePage");
        if (objBinding != null) {
            return objBinding.getInt();
        }
        return 50;
    }

    public TreeRowObject getTreeRow() {
        return this.getTreeRowObject();
    }

    public ITableSessionStateManager getTableSessionStateManager() {
        SimpleListTableDataModel objDataModel = new SimpleListTableDataModel(this.generateNodeList());
        SimpleTableColumnModel objColumnModel = new SimpleTableColumnModel(this.getTableColunms());
        SimpleTableSessionStateManager objStateManager = new SimpleTableSessionStateManager(objDataModel, objColumnModel);
        return objStateManager;
    }

    protected void renderComponent(IMarkupWriter arg0, IRequestCycle cycle) {
        Object objExistedTreeModelSource = cycle.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", (Object)this);
        super.renderComponent(arg0, cycle);
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", objExistedTreeModelSource);
    }

    public void renderBody(IMarkupWriter arg0, IRequestCycle cycle) {
        Object objExistedTreeModelSource = cycle.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", (Object)this);
        super.renderBody(arg0, cycle);
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", objExistedTreeModelSource);
    }

    public TreeRowObject getTreeRowObject() {
        return this.m_objTreeRowObject;
    }

    public void setTreeRowObject(TreeRowObject object) {
        this.m_objTreeRowObject = object;
    }
}

